/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record;

import java.io.IOException;
import java.io.Serializable;
import java.nio.CharBuffer;
import java.util.Arrays;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.IRawRecord;

public class CharArrayRecord
implements IRawRecord<char[]> {
    private char[] value;
    private int size;

    public CharArrayRecord(int initialCapacity) {
        this.value = new char[initialCapacity];
        this.size = 0;
    }

    public CharArrayRecord() {
        this.value = new char[4096];
        this.size = 0;
    }

    @Override
    public byte[] getBytes() {
        return new String(this.value).getBytes();
    }

    @Override
    public char[] get() {
        return this.value;
    }

    @Override
    public int size() {
        return this.size;
    }

    public void setValue(char[] recordBuffer, int offset, int length) {
        if (this.value.length < length) {
            this.value = new char[length];
        }
        System.arraycopy(recordBuffer, offset, this.value, 0, length);
        this.size = length;
    }

    private void ensureCapacity(int len) throws IOException {
        if (this.value.length < len) {
            if (len > 32000000) {
                throw new RuntimeDataException(3038, new Serializable[]{Integer.valueOf(32000000)});
            }
            int newSize = Math.min((int)((float)len * 1.5f), 32000000);
            this.value = Arrays.copyOf(this.value, newSize);
        }
    }

    public void append(char[] recordBuffer, int offset, int length) throws IOException {
        this.ensureCapacity(this.size + length);
        System.arraycopy(recordBuffer, offset, this.value, this.size, length);
        this.size += length;
    }

    @Override
    public void reset() {
        this.size = 0;
    }

    public String toString() {
        return String.valueOf(this.value, 0, this.size == 0 ? 0 : this.size - 1);
    }

    public void endRecord() throws IOException {
        if (this.size > 0 && this.value[this.size - 1] != '\n') {
            this.appendChar('\n');
        }
    }

    private void appendChar(char c) throws IOException {
        this.ensureCapacity(this.size + 1);
        this.value[this.size] = c;
        ++this.size;
    }

    public void append(char[] recordBuffer) throws IOException {
        this.ensureCapacity(this.size + recordBuffer.length);
        System.arraycopy(recordBuffer, 0, this.value, this.size, recordBuffer.length);
        this.size += recordBuffer.length;
    }

    public void append(CharBuffer chars) throws IOException {
        this.ensureCapacity(this.size + chars.limit());
        chars.get(this.value, this.size, chars.limit());
        this.size += chars.limit();
    }

    @Override
    public void set(char[] value) {
        this.value = value;
        this.size = value.length;
    }

    @Override
    public void set(StringBuilder builder) throws IOException {
        this.ensureCapacity(builder.length());
        builder.getChars(0, builder.length(), this.value, 0);
        this.size = builder.length();
    }
}

