/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.dataflow;

import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.external.api.IRecordReader;
import org.apache.asterix.external.dataflow.AbstractDataFlowController;
import org.apache.asterix.external.dataflow.TupleForwarder;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;

public class RecordDataFlowController<T>
extends AbstractDataFlowController {
    protected final IRecordDataParser<T> dataParser;
    protected final IRecordReader<? extends T> recordReader;
    protected final int numOfTupleFields;

    public RecordDataFlowController(IHyracksTaskContext ctx, IRecordDataParser<T> dataParser, IRecordReader<? extends T> recordReader, int numOfTupleFields) {
        super(ctx);
        this.dataParser = dataParser;
        this.recordReader = recordReader;
        this.numOfTupleFields = numOfTupleFields;
    }

    @Override
    public void start(IFrameWriter writer) throws HyracksDataException {
        try {
            ArrayTupleBuilder tb = new ArrayTupleBuilder(this.numOfTupleFields);
            TupleForwarder tupleForwarder = new TupleForwarder(this.ctx, writer);
            while (this.recordReader.hasNext()) {
                IRawRecord<? extends T> record = this.recordReader.next();
                tb.reset();
                this.dataParser.parse(record, tb.getDataOutput());
                tb.addFieldEndOffset();
                this.appendOtherTupleFields(tb);
                tupleForwarder.addTuple(tb);
            }
            tupleForwarder.complete();
            this.recordReader.close();
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    protected void appendOtherTupleFields(ArrayTupleBuilder tb) throws Exception {
    }
}

