/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public interface IExternalDataSourceFactory
extends Serializable {
    public DataSourceType getDataSourceType();

    public AlgebricksAbsolutePartitionConstraint getPartitionConstraint() throws AlgebricksException;

    public void configure(IServiceContext var1, Map<String, String> var2) throws AlgebricksException, HyracksDataException;

    default public boolean isIndexible() {
        return false;
    }

    public static AlgebricksAbsolutePartitionConstraint getPartitionConstraints(ICcApplicationContext appCtx, AlgebricksAbsolutePartitionConstraint constraints, int count) throws AlgebricksException {
        if (constraints == null) {
            IClusterStateManager clusterStateManager = appCtx.getClusterStateManager();
            ArrayList<String> locs = new ArrayList<String>();
            Set stores = appCtx.getMetadataProperties().getStores().keySet();
            if (stores.isEmpty()) {
                throw new AlgebricksException("Configurations don't have any stores");
            }
            int i = 0;
            block0: while (i < count) {
                for (String node : stores) {
                    int numIODevices = clusterStateManager.getIODevices(node).length;
                    for (int k = 0; k < numIODevices; ++k) {
                        locs.add(node);
                        if (++i == count) break block0;
                    }
                }
                if (i != 0) continue;
                throw new AlgebricksException("All stores have 0 IO devices");
            }
            return new AlgebricksAbsolutePartitionConstraint(locs.toArray(new String[locs.size()]));
        }
        return constraints;
    }

    public static enum DataSourceType {
        STREAM,
        RECORDS;

    }
}

