/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.BroadcastExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.LogicalPropertiesVisitor;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractJoinPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.HybridHashJoinPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.InMemoryHashJoinPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.NestedLoopJoinPOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.ILogicalPropertiesVector;
import org.apache.hyracks.algebricks.core.config.AlgebricksConfig;

public class JoinUtils {
    private JoinUtils() {
    }

    public static void setJoinAlgorithmAndExchangeAlgo(AbstractBinaryJoinOperator op, boolean topLevelOp, IOptimizationContext context) throws AlgebricksException {
        if (!topLevelOp) {
            throw new IllegalStateException("Micro operator not implemented for: " + op.getOperatorTag());
        }
        LinkedList<LogicalVariable> sideLeft = new LinkedList<LogicalVariable>();
        LinkedList<LogicalVariable> sideRight = new LinkedList<LogicalVariable>();
        List varsLeft = ((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue()).getSchema();
        List varsRight = ((ILogicalOperator)((Mutable)op.getInputs().get(1)).getValue()).getSchema();
        if (JoinUtils.isHashJoinCondition((ILogicalExpression)op.getCondition().getValue(), varsLeft, varsRight, sideLeft, sideRight)) {
            BroadcastExpressionAnnotation.BroadcastSide side = JoinUtils.getBroadcastJoinSide((ILogicalExpression)op.getCondition().getValue(), varsLeft, varsRight);
            if (side == null) {
                JoinUtils.setHashJoinOp(op, AbstractJoinPOperator.JoinPartitioningType.PAIRWISE, sideLeft, sideRight, context);
            } else {
                switch (side) {
                    case RIGHT: {
                        JoinUtils.setHashJoinOp(op, AbstractJoinPOperator.JoinPartitioningType.BROADCAST, sideLeft, sideRight, context);
                        break;
                    }
                    case LEFT: {
                        Mutable opRef0 = (Mutable)op.getInputs().get(0);
                        Mutable opRef1 = (Mutable)op.getInputs().get(1);
                        ILogicalOperator tmp = (ILogicalOperator)opRef0.getValue();
                        opRef0.setValue(opRef1.getValue());
                        opRef1.setValue((Object)tmp);
                        JoinUtils.setHashJoinOp(op, AbstractJoinPOperator.JoinPartitioningType.BROADCAST, sideRight, sideLeft, context);
                        break;
                    }
                    default: {
                        JoinUtils.setHashJoinOp(op, AbstractJoinPOperator.JoinPartitioningType.PAIRWISE, sideLeft, sideRight, context);
                    }
                }
            }
        } else {
            JoinUtils.setNestedLoopJoinOp(op, context);
        }
    }

    private static void setNestedLoopJoinOp(AbstractBinaryJoinOperator op, IOptimizationContext context) {
        op.setPhysicalOperator((IPhysicalOperator)new NestedLoopJoinPOperator(op.getJoinKind(), AbstractJoinPOperator.JoinPartitioningType.BROADCAST, context.getPhysicalOptimizationConfig().getMaxFramesForJoin()));
    }

    private static void setHashJoinOp(AbstractBinaryJoinOperator op, AbstractJoinPOperator.JoinPartitioningType partitioningType, List<LogicalVariable> sideLeft, List<LogicalVariable> sideRight, IOptimizationContext context) throws AlgebricksException {
        op.setPhysicalOperator((IPhysicalOperator)new HybridHashJoinPOperator(op.getJoinKind(), partitioningType, sideLeft, sideRight, context.getPhysicalOptimizationConfig().getMaxFramesForJoin(), context.getPhysicalOptimizationConfig().getMaxFramesForJoinLeftInput(), context.getPhysicalOptimizationConfig().getMaxRecordsPerFrame(), context.getPhysicalOptimizationConfig().getFudgeFactor()));
        if (partitioningType == AbstractJoinPOperator.JoinPartitioningType.BROADCAST) {
            JoinUtils.hybridToInMemHashJoin(op, context);
        }
    }

    private static void hybridToInMemHashJoin(AbstractBinaryJoinOperator op, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator opBuild = (ILogicalOperator)((Mutable)op.getInputs().get(1)).getValue();
        LogicalPropertiesVisitor.computeLogicalPropertiesDFS((ILogicalOperator)opBuild, (IOptimizationContext)context);
        ILogicalPropertiesVector v = context.getLogicalPropertiesVector(opBuild);
        boolean loggerDebugEnabled = AlgebricksConfig.ALGEBRICKS_LOGGER.isDebugEnabled();
        if (loggerDebugEnabled) {
            AlgebricksConfig.ALGEBRICKS_LOGGER.debug("// HybridHashJoin inner branch -- Logical properties for " + opBuild + ": " + v + "\n");
        }
        if (v != null) {
            int size2 = v.getMaxOutputFrames();
            HybridHashJoinPOperator hhj = (HybridHashJoinPOperator)op.getPhysicalOperator();
            if (size2 > 0 && (double)size2 * hhj.getFudgeFactor() <= (double)hhj.getMemSizeInFrames()) {
                if (loggerDebugEnabled) {
                    AlgebricksConfig.ALGEBRICKS_LOGGER.debug("// HybridHashJoin inner branch " + opBuild + " fits in memory\n");
                }
                op.setPhysicalOperator((IPhysicalOperator)new InMemoryHashJoinPOperator(hhj.getKind(), hhj.getPartitioningType(), hhj.getKeysLeftBranch(), hhj.getKeysRightBranch(), v.getNumberOfTuples() * 2, hhj.getMemSizeInFrames()));
            }
        }
    }

    private static boolean isHashJoinCondition(ILogicalExpression e, Collection<LogicalVariable> inLeftAll, Collection<LogicalVariable> inRightAll, Collection<LogicalVariable> outLeftFields, Collection<LogicalVariable> outRightFields) {
        switch (e.getExpressionTag()) {
            case FUNCTION_CALL: {
                AbstractFunctionCallExpression fexp = (AbstractFunctionCallExpression)e;
                FunctionIdentifier fi = fexp.getFunctionIdentifier();
                if (fi.equals((Object)AlgebricksBuiltinFunctions.AND)) {
                    for (Mutable a : fexp.getArguments()) {
                        if (JoinUtils.isHashJoinCondition((ILogicalExpression)a.getValue(), inLeftAll, inRightAll, outLeftFields, outRightFields)) continue;
                        return false;
                    }
                    return true;
                }
                AlgebricksBuiltinFunctions.ComparisonKind ck = AlgebricksBuiltinFunctions.getComparisonType((FunctionIdentifier)fi);
                if (ck != AlgebricksBuiltinFunctions.ComparisonKind.EQ) {
                    return false;
                }
                ILogicalExpression opLeft = (ILogicalExpression)((Mutable)fexp.getArguments().get(0)).getValue();
                ILogicalExpression opRight = (ILogicalExpression)((Mutable)fexp.getArguments().get(1)).getValue();
                if (opLeft.getExpressionTag() != LogicalExpressionTag.VARIABLE || opRight.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
                    return false;
                }
                LogicalVariable var1 = ((VariableReferenceExpression)opLeft).getVariableReference();
                if (inLeftAll.contains(var1) && !outLeftFields.contains(var1)) {
                    outLeftFields.add(var1);
                } else if (inRightAll.contains(var1) && !outRightFields.contains(var1)) {
                    outRightFields.add(var1);
                } else {
                    return false;
                }
                LogicalVariable var2 = ((VariableReferenceExpression)opRight).getVariableReference();
                if (inLeftAll.contains(var2) && !outLeftFields.contains(var2)) {
                    outLeftFields.add(var2);
                } else if (inRightAll.contains(var2) && !outRightFields.contains(var2)) {
                    outRightFields.add(var2);
                } else {
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static BroadcastExpressionAnnotation.BroadcastSide getBroadcastJoinSide(ILogicalExpression e, List<LogicalVariable> varsLeft, List<LogicalVariable> varsRight) {
        int i;
        if (e.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return null;
        }
        AbstractFunctionCallExpression fexp = (AbstractFunctionCallExpression)e;
        FunctionIdentifier fi = fexp.getFunctionIdentifier();
        if (fi.equals((Object)AlgebricksBuiltinFunctions.AND)) {
            BroadcastExpressionAnnotation.BroadcastSide fBcastSide = null;
            for (Mutable a : fexp.getArguments()) {
                BroadcastExpressionAnnotation.BroadcastSide aBcastSide = JoinUtils.getBroadcastJoinSide((ILogicalExpression)a.getValue(), varsLeft, varsRight);
                if (fBcastSide == null) {
                    fBcastSide = aBcastSide;
                    continue;
                }
                if (aBcastSide == null || aBcastSide.equals((Object)fBcastSide)) continue;
                return null;
            }
            return fBcastSide;
        }
        IExpressionAnnotation ann = (IExpressionAnnotation)fexp.getAnnotations().get("broadcast");
        if (ann == null) {
            return null;
        }
        BroadcastExpressionAnnotation.BroadcastSide side = (BroadcastExpressionAnnotation.BroadcastSide)ann.getObject();
        if (side == null) {
            return null;
        }
        switch (side) {
            case LEFT: {
                i = 0;
                break;
            }
            case RIGHT: {
                i = 1;
                break;
            }
            default: {
                return null;
            }
        }
        ArrayList vars = new ArrayList();
        ((ILogicalExpression)((Mutable)fexp.getArguments().get(i)).getValue()).getUsedVariables(vars);
        if (varsLeft.containsAll(vars)) {
            return BroadcastExpressionAnnotation.BroadcastSide.LEFT;
        }
        if (varsRight.containsAll(vars)) {
            return BroadcastExpressionAnnotation.BroadcastSide.RIGHT;
        }
        return null;
    }
}

