/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules.subplan;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class NestedSubplanToJoinRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue())) {
            return false;
        }
        context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue());
        ILogicalOperator op1 = (ILogicalOperator)opRef.getValue();
        if (op1.getInputs().size() == 0) {
            return false;
        }
        boolean rewritten = false;
        for (int index = 0; index < op1.getInputs().size(); ++index) {
            ILogicalOperator subplanInput;
            AbstractLogicalOperator subplanInputOp;
            AbstractLogicalOperator child = (AbstractLogicalOperator)((Mutable)op1.getInputs().get(index)).getValue();
            if (child.getOperatorTag() != LogicalOperatorTag.SUBPLAN) continue;
            AbstractOperatorWithNestedPlans subplan = (AbstractOperatorWithNestedPlans)child;
            HashSet freeVars = new HashSet();
            OperatorPropertiesUtil.getFreeVariablesInSubplans((AbstractOperatorWithNestedPlans)subplan, freeVars);
            if (!freeVars.isEmpty() || (subplanInputOp = (AbstractLogicalOperator)(subplanInput = (ILogicalOperator)((Mutable)subplan.getInputs().get(0)).getValue())).getOperatorTag() == LogicalOperatorTag.EMPTYTUPLESOURCE) continue;
            List nestedPlans = subplan.getNestedPlans();
            ArrayList nestedRoots = new ArrayList();
            for (ILogicalPlan nestedPlan : nestedPlans) {
                nestedRoots.addAll(nestedPlan.getRoots());
            }
            if (nestedRoots.size() == 0) continue;
            MutableObject expr = new MutableObject((Object)ConstantExpression.TRUE);
            Mutable nestedRootRef = (Mutable)nestedRoots.get(0);
            InnerJoinOperator join = new InnerJoinOperator((Mutable)expr, (Mutable)new MutableObject((Object)subplanInput), nestedRootRef);
            this.rewriteNestedTupleSource((Mutable<ILogicalOperator>)nestedRootRef, context);
            for (int i = 1; i < nestedRoots.size(); ++i) {
                join = new InnerJoinOperator((Mutable)expr, (Mutable)new MutableObject((Object)join), (Mutable)nestedRoots.get(i));
            }
            ((Mutable)op1.getInputs().get(index)).setValue((Object)join);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)join);
            rewritten = true;
        }
        return rewritten;
    }

    private void rewriteNestedTupleSource(Mutable<ILogicalOperator> nestedRootRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator nestedRoot = (AbstractLogicalOperator)nestedRootRef.getValue();
        if (nestedRoot.getOperatorTag() == LogicalOperatorTag.NESTEDTUPLESOURCE) {
            EmptyTupleSourceOperator ets = new EmptyTupleSourceOperator();
            nestedRootRef.setValue((Object)ets);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)ets);
        }
        List inputs = nestedRoot.getInputs();
        for (Mutable input : inputs) {
            this.rewriteNestedTupleSource((Mutable<ILogicalOperator>)input, context);
        }
    }
}

