/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class PullSelectOutOfEqJoin
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.INNERJOIN) {
            return false;
        }
        AbstractBinaryJoinOperator join = (AbstractBinaryJoinOperator)op;
        ILogicalExpression expr = (ILogicalExpression)join.getCondition().getValue();
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression fexp = (AbstractFunctionCallExpression)expr;
        FunctionIdentifier fi = fexp.getFunctionIdentifier();
        if (!fi.equals((Object)AlgebricksBuiltinFunctions.AND)) {
            return false;
        }
        ArrayList<Mutable<ILogicalExpression>> eqVarVarComps = new ArrayList<Mutable<ILogicalExpression>>();
        ArrayList<Mutable<ILogicalExpression>> otherPredicates = new ArrayList<Mutable<ILogicalExpression>>();
        for (Mutable arg : fexp.getArguments()) {
            if (this.isEqVarVar((ILogicalExpression)arg.getValue())) {
                eqVarVarComps.add(arg);
                continue;
            }
            otherPredicates.add((Mutable<ILogicalExpression>)arg);
        }
        if (eqVarVarComps.isEmpty() || otherPredicates.isEmpty()) {
            return false;
        }
        ILogicalExpression pulledCond = this.makeCondition(otherPredicates, context);
        SelectOperator select = new SelectOperator((Mutable)new MutableObject((Object)pulledCond), false, null);
        ILogicalExpression newJoinCond = this.makeCondition(eqVarVarComps, context);
        join.getCondition().setValue((Object)newJoinCond);
        select.getInputs().add(new MutableObject((Object)join));
        opRef.setValue((Object)select);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)select);
        return true;
    }

    private ILogicalExpression makeCondition(List<Mutable<ILogicalExpression>> predList, IOptimizationContext context) {
        if (predList.size() > 1) {
            IFunctionInfo finfo = context.getMetadataProvider().lookupFunction(AlgebricksBuiltinFunctions.AND);
            return new ScalarFunctionCallExpression(finfo, predList);
        }
        return (ILogicalExpression)predList.get(0).getValue();
    }

    private boolean isEqVarVar(ILogicalExpression expr) {
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)expr;
        if (!f.getFunctionIdentifier().equals((Object)AlgebricksBuiltinFunctions.EQ)) {
            return false;
        }
        ILogicalExpression e1 = (ILogicalExpression)((Mutable)f.getArguments().get(0)).getValue();
        if (e1.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            return false;
        }
        ILogicalExpression e2 = (ILogicalExpression)((Mutable)f.getArguments().get(1)).getValue();
        return e2.getExpressionTag() == LogicalExpressionTag.VARIABLE;
    }
}

