/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.HashSet;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.algebricks.rewriter.rules.AbstractIntroduceCombinerRule;

public class IntroduceAggregateCombinerRule
extends AbstractIntroduceCombinerRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op)) {
            return false;
        }
        context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op);
        if (op.getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
            return false;
        }
        AggregateOperator aggOp = (AggregateOperator)op;
        if (!aggOp.isGlobal() || aggOp.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.LOCAL) {
            return false;
        }
        HashSet<AbstractIntroduceCombinerRule.SimilarAggregatesInfo> toReplaceSet = new HashSet<AbstractIntroduceCombinerRule.SimilarAggregatesInfo>();
        Pair<Boolean, Mutable<ILogicalOperator>> result = this.tryToPushAgg(aggOp, null, toReplaceSet, context);
        if (!((Boolean)result.first).booleanValue() || result.second == null) {
            return false;
        }
        this.replaceOriginalAggFuncs(toReplaceSet);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)aggOp);
        return true;
    }
}

