/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class ExtractGroupByDecorVariablesRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.GROUP) {
            return false;
        }
        GroupByOperator groupByOperator = (GroupByOperator)op;
        List decorList = groupByOperator.getDecorList();
        if (groupByOperator.getDecorList() == null || groupByOperator.getDecorList().isEmpty()) {
            return false;
        }
        boolean changed = false;
        ArrayList<LogicalVariable> vars = new ArrayList<LogicalVariable>();
        ArrayList<Mutable> exprs = new ArrayList<Mutable>();
        for (Pair decorVarExpr : decorList) {
            Mutable exprRef = (Mutable)decorVarExpr.second;
            ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
            if (expr == null || expr.getExpressionTag() == LogicalExpressionTag.VARIABLE) continue;
            changed = true;
            LogicalVariable newVar = context.newVar();
            vars.add(newVar);
            exprs.add(exprRef);
            decorVarExpr.second = new MutableObject((Object)new VariableReferenceExpression(newVar));
        }
        if (!changed) {
            return false;
        }
        AssignOperator assignOperator = new AssignOperator(vars, exprs);
        assignOperator.getInputs().addAll(op.getInputs());
        op.getInputs().set(0, new MutableObject((Object)assignOperator));
        return changed;
    }
}

