/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class ExtractFunctionsFromJoinConditionRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.INNERJOIN && op.getOperatorTag() != LogicalOperatorTag.LEFTOUTERJOIN) {
            return false;
        }
        AbstractBinaryJoinOperator joinOp = (AbstractBinaryJoinOperator)op;
        ILogicalExpression expr = (ILogicalExpression)joinOp.getCondition().getValue();
        return this.assignFunctionExpressions((AbstractLogicalOperator)joinOp, expr, context);
    }

    private boolean assignFunctionExpressions(AbstractLogicalOperator joinOp, ILogicalExpression expr, IOptimizationContext context) throws AlgebricksException {
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression fexp = (AbstractFunctionCallExpression)expr;
        FunctionIdentifier fi = fexp.getFunctionIdentifier();
        boolean modified = false;
        if (fi.equals((Object)AlgebricksBuiltinFunctions.AND) || fi.equals((Object)AlgebricksBuiltinFunctions.OR) || this.processArgumentsToFunction(fi)) {
            for (Mutable a : fexp.getArguments()) {
                if (!this.assignFunctionExpressions(joinOp, (ILogicalExpression)a.getValue(), context)) continue;
                modified = true;
            }
            return modified;
        }
        if (AlgebricksBuiltinFunctions.isComparisonFunction((FunctionIdentifier)fi) || this.isComparisonFunction(fi)) {
            for (Mutable exprRef : fexp.getArguments()) {
                if (((ILogicalExpression)exprRef.getValue()).getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
                LogicalVariable newVar = context.newVar();
                AssignOperator newAssign = new AssignOperator(newVar, (Mutable)new MutableObject((Object)((ILogicalExpression)exprRef.getValue()).cloneExpression()));
                newAssign.setExecutionMode(joinOp.getExecutionMode());
                ArrayList used = new ArrayList();
                VariableUtilities.getUsedVariables((ILogicalOperator)newAssign, used);
                Mutable leftBranchRef = (Mutable)joinOp.getInputs().get(0);
                ILogicalOperator leftBranch = (ILogicalOperator)leftBranchRef.getValue();
                ArrayList leftBranchVariables = new ArrayList();
                VariableUtilities.getLiveVariables((ILogicalOperator)leftBranch, leftBranchVariables);
                if (leftBranchVariables.containsAll(used)) {
                    newAssign.getInputs().add(new MutableObject((Object)leftBranch));
                    leftBranchRef.setValue((Object)newAssign);
                    modified = true;
                } else {
                    Mutable rightBranchRef = (Mutable)joinOp.getInputs().get(1);
                    ILogicalOperator rightBranch = (ILogicalOperator)rightBranchRef.getValue();
                    ArrayList rightBranchVariables = new ArrayList();
                    VariableUtilities.getLiveVariables((ILogicalOperator)rightBranch, rightBranchVariables);
                    if (rightBranchVariables.containsAll(used)) {
                        newAssign.getInputs().add(new MutableObject((Object)rightBranch));
                        rightBranchRef.setValue((Object)newAssign);
                        modified = true;
                    }
                }
                if (!modified) continue;
                exprRef.setValue((Object)new VariableReferenceExpression(newVar));
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)newAssign);
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)joinOp);
            }
            return modified;
        }
        return false;
    }

    protected boolean processArgumentsToFunction(FunctionIdentifier fi) {
        return false;
    }

    protected boolean isComparisonFunction(FunctionIdentifier fi) {
        return false;
    }
}

