/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class EliminateGroupByEmptyKeyRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.GROUP) {
            return false;
        }
        GroupByOperator groupOp = (GroupByOperator)op;
        if (!groupOp.isGroupAll()) {
            return false;
        }
        List groupVars = groupOp.getGbyVarList();
        List decorList = groupOp.getDecorList();
        if (!groupVars.isEmpty() || !decorList.isEmpty()) {
            return false;
        }
        List nestedPlans = groupOp.getNestedPlans();
        if (nestedPlans.size() > 1) {
            return false;
        }
        ILogicalPlan nestedPlan = (ILogicalPlan)nestedPlans.get(0);
        if (nestedPlan.getRoots().size() > 1) {
            return false;
        }
        Mutable topOpRef = (Mutable)nestedPlan.getRoots().get(0);
        ILogicalOperator topOp = (ILogicalOperator)((Mutable)nestedPlan.getRoots().get(0)).getValue();
        Mutable<ILogicalOperator> nestedTupleSourceRef = this.getNestedTupleSourceReference((Mutable<ILogicalOperator>)topOpRef);
        opRef.setValue((Object)topOp);
        nestedTupleSourceRef.setValue(((Mutable)groupOp.getInputs().get(0)).getValue());
        return true;
    }

    private Mutable<ILogicalOperator> getNestedTupleSourceReference(Mutable<ILogicalOperator> nestedTopOperatorRef) {
        Mutable currentOpRef = nestedTopOperatorRef;
        while (((ILogicalOperator)currentOpRef.getValue()).getInputs() != null && !((ILogicalOperator)currentOpRef.getValue()).getInputs().isEmpty()) {
            currentOpRef = (Mutable)((ILogicalOperator)currentOpRef.getValue()).getInputs().get(0);
        }
        return currentOpRef;
    }
}

