/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.storage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class IndexCheckpoint {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final long INITIAL_CHECKPOINT_ID = 0L;
    private long id;
    private String validComponentTimestamp;
    private long lowWatermark;
    private Map<Long, Long> masterNodeFlushMap;

    public static IndexCheckpoint first(long lowWatermark) {
        IndexCheckpoint firstCheckpoint = new IndexCheckpoint();
        firstCheckpoint.id = 0L;
        firstCheckpoint.lowWatermark = lowWatermark;
        firstCheckpoint.validComponentTimestamp = null;
        firstCheckpoint.masterNodeFlushMap = new HashMap<Long, Long>();
        return firstCheckpoint;
    }

    public static IndexCheckpoint next(IndexCheckpoint latest, long lowWatermark, String validComponentTimestamp) {
        if (lowWatermark < latest.getLowWatermark()) {
            throw new IllegalStateException("Low watermark should always be increasing");
        }
        IndexCheckpoint next = new IndexCheckpoint();
        next.id = latest.getId() + 1L;
        next.lowWatermark = lowWatermark;
        next.validComponentTimestamp = validComponentTimestamp;
        next.masterNodeFlushMap = latest.getMasterNodeFlushMap();
        next.masterNodeFlushMap.values().removeIf(lsn -> lsn <= lowWatermark);
        return next;
    }

    @JsonCreator
    private IndexCheckpoint() {
    }

    public String getValidComponentTimestamp() {
        return this.validComponentTimestamp;
    }

    public long getLowWatermark() {
        return this.lowWatermark;
    }

    public Map<Long, Long> getMasterNodeFlushMap() {
        return this.masterNodeFlushMap;
    }

    public long getId() {
        return this.id;
    }

    public String asJson() throws HyracksDataException {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static IndexCheckpoint fromJson(String json) throws HyracksDataException {
        try {
            return (IndexCheckpoint)OBJECT_MAPPER.readValue(json, IndexCheckpoint.class);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

