/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.context;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.asterix.common.context.BaseOperationTracker;
import org.apache.asterix.common.context.DatasetInfo;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.ioopcallbacks.AbstractLSMIOOperationCallback;
import org.apache.asterix.common.metadata.MetadataIndexImmutableProperties;
import org.apache.asterix.common.transactions.AbstractOperationCallback;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.LogRecord;
import org.apache.asterix.common.utils.TransactionUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentIdGenerator;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentId;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;

public class PrimaryIndexOperationTracker
extends BaseOperationTracker {
    private final int partition;
    private final AtomicInteger numActiveOperations;
    private final ILogManager logManager;
    private final ILSMComponentIdGenerator idGenerator;
    private boolean flushOnExit = false;
    private boolean flushLogCreated = false;

    public PrimaryIndexOperationTracker(int datasetID, int partition, ILogManager logManager, DatasetInfo dsInfo, ILSMComponentIdGenerator idGenerator) {
        super(datasetID, dsInfo);
        this.partition = partition;
        this.logManager = logManager;
        this.numActiveOperations = new AtomicInteger();
        this.idGenerator = idGenerator;
    }

    @Override
    public void beforeOperation(ILSMIndex index, LSMOperationType opType, ISearchOperationCallback searchCallback, IModificationOperationCallback modificationCallback) throws HyracksDataException {
        if (opType == LSMOperationType.MODIFICATION || opType == LSMOperationType.FORCE_MODIFICATION) {
            this.incrementNumActiveOperations(modificationCallback);
        } else if (opType == LSMOperationType.FLUSH || opType == LSMOperationType.MERGE || opType == LSMOperationType.REPLICATE) {
            this.dsInfo.declareActiveIOOperation();
        }
    }

    @Override
    public void afterOperation(ILSMIndex index, LSMOperationType opType, ISearchOperationCallback searchCallback, IModificationOperationCallback modificationCallback) throws HyracksDataException {
        if (opType == LSMOperationType.REPLICATE) {
            this.completeOperation(index, opType, searchCallback, modificationCallback);
        }
    }

    @Override
    public synchronized void completeOperation(ILSMIndex index, LSMOperationType opType, ISearchOperationCallback searchCallback, IModificationOperationCallback modificationCallback) throws HyracksDataException {
        if (opType == LSMOperationType.MODIFICATION || opType == LSMOperationType.FORCE_MODIFICATION) {
            this.decrementNumActiveOperations(modificationCallback);
            this.flushIfNeeded();
        } else if (opType == LSMOperationType.FLUSH || opType == LSMOperationType.MERGE || opType == LSMOperationType.REPLICATE) {
            this.dsInfo.undeclareActiveIOOperation();
        }
    }

    public synchronized void flushIfNeeded() throws HyracksDataException {
        if (this.canSafelyFlush()) {
            this.flushIfRequested();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushIfRequested() throws HyracksDataException {
        boolean needsFlush = false;
        Set<ILSMIndex> indexes = this.dsInfo.getDatasetPartitionOpenIndexes(this.partition);
        if (!this.flushOnExit) {
            for (ILSMIndex lsmIndex : indexes) {
                if (!lsmIndex.hasFlushRequestForCurrentMutableComponent()) continue;
                needsFlush = true;
                break;
            }
        }
        if (needsFlush || this.flushOnExit) {
            LSMComponentId primaryId = null;
            for (ILSMIndex lsmIndex : indexes) {
                ILSMOperationTracker opTracker;
                ILSMOperationTracker iLSMOperationTracker = opTracker = lsmIndex.getOperationTracker();
                synchronized (iLSMOperationTracker) {
                    ILSMMemoryComponent memComponent = lsmIndex.getCurrentMemoryComponent();
                    if (memComponent.getState() == ILSMComponent.ComponentState.READABLE_WRITABLE && memComponent.isModified()) {
                        memComponent.setState(ILSMComponent.ComponentState.READABLE_UNWRITABLE);
                    }
                    if (lsmIndex.isPrimaryIndex()) {
                        primaryId = (LSMComponentId)memComponent.getId();
                    }
                }
            }
            if (primaryId == null) {
                throw new IllegalStateException("Primary index not found in dataset " + this.dsInfo.getDatasetID());
            }
            LogRecord logRecord = new LogRecord();
            this.flushOnExit = false;
            if (this.dsInfo.isDurable()) {
                TransactionUtil.formFlushLogRecord(logRecord, this.datasetID, this.partition, primaryId.getMinId(), primaryId.getMaxId(), this);
                try {
                    this.logManager.log(logRecord);
                }
                catch (ACIDException e) {
                    throw new IllegalStateException("could not write flush log", e);
                }
                this.flushLogCreated = true;
            } else {
                this.triggerScheduleFlush(logRecord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void triggerScheduleFlush(LogRecord logRecord) throws HyracksDataException {
        try {
            if (!this.canSafelyFlush()) {
                if (MetadataIndexImmutableProperties.isMetadataDataset(this.datasetID)) {
                    return;
                }
                throw new IllegalStateException("Operation started while index was pending scheduling a flush");
            }
            this.idGenerator.refresh();
            for (ILSMIndex lsmIndex : this.dsInfo.getDatasetPartitionOpenIndexes(this.partition)) {
                ILSMIndexAccessor accessor = lsmIndex.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
                AbstractLSMIOOperationCallback ioOpCallback = (AbstractLSMIOOperationCallback)lsmIndex.getIOOperationCallback();
                ioOpCallback.updateLastLSN(logRecord.getLSN());
                accessor.scheduleFlush(lsmIndex.getIOOperationCallback());
            }
        }
        finally {
            this.flushLogCreated = false;
        }
    }

    public int getNumActiveOperations() {
        return this.numActiveOperations.get();
    }

    private void incrementNumActiveOperations(IModificationOperationCallback modificationCallback) {
        if (modificationCallback != NoOpOperationCallback.INSTANCE) {
            this.numActiveOperations.incrementAndGet();
            ((AbstractOperationCallback)modificationCallback).beforeOperation();
        }
    }

    private void decrementNumActiveOperations(IModificationOperationCallback modificationCallback) {
        if (modificationCallback != NoOpOperationCallback.INSTANCE) {
            if (this.numActiveOperations.decrementAndGet() < 0) {
                throw new IllegalStateException("The number of active operations cannot be negative!");
            }
            ((AbstractOperationCallback)modificationCallback).afterOperation();
        }
    }

    public boolean isFlushOnExit() {
        return this.flushOnExit;
    }

    public void setFlushOnExit(boolean flushOnExit) {
        this.flushOnExit = flushOnExit;
    }

    public boolean isFlushLogCreated() {
        return this.flushLogCreated;
    }

    public int getPartition() {
        return this.partition;
    }

    private boolean canSafelyFlush() {
        return this.numActiveOperations.get() == 0;
    }
}

