/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.impls.ComparableTracedIOOperation;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.util.trace.ITracer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class TracedIOOperation
implements ILSMIOOperation {
    static final Logger LOGGER = LogManager.getLogger();
    protected final ILSMIOOperation ioOp;
    private final ILSMIOOperation.LSMIOOperationType ioOpType;
    private final ITracer tracer;
    private final long traceCategory;

    protected TracedIOOperation(ILSMIOOperation ioOp, ITracer tracer, long traceCategory) {
        this.ioOp = ioOp;
        this.tracer = tracer;
        this.ioOpType = ioOp.getIOOpertionType();
        this.traceCategory = traceCategory;
    }

    public static ILSMIOOperation wrap(ILSMIOOperation ioOp, ITracer tracer) {
        String ioOpName = ioOp.getIOOpertionType().name().toLowerCase();
        long traceCategory = tracer.getRegistry().get("IndexIoOperations");
        if (tracer.isEnabled(traceCategory)) {
            tracer.instant("schedule-" + ioOpName, traceCategory, ITracer.Scope.p, "{\"path\": \"" + ioOp.getTarget().getRelativePath() + "\"}");
        }
        if (tracer.isEnabled(traceCategory)) {
            return ioOp instanceof Comparable ? new ComparableTracedIOOperation(ioOp, tracer, traceCategory) : new TracedIOOperation(ioOp, tracer, traceCategory);
        }
        return ioOp;
    }

    protected ILSMIOOperation getIoOp() {
        return this.ioOp;
    }

    @Override
    public IODeviceHandle getDevice() {
        return this.ioOp.getDevice();
    }

    @Override
    public ILSMIOOperationCallback getCallback() {
        return this.ioOp.getCallback();
    }

    @Override
    public String getIndexIdentifier() {
        return this.ioOp.getIndexIdentifier();
    }

    @Override
    public ILSMIOOperation.LSMIOOperationType getIOOpertionType() {
        return this.ioOpType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() throws HyracksDataException {
        String name = this.getTarget().getRelativePath();
        long tid = this.tracer.durationB(name, this.traceCategory, null);
        try {
            Boolean bl = this.ioOp.call();
            return bl;
        }
        finally {
            this.tracer.durationE(this.ioOp.getIOOpertionType().name().toLowerCase(), this.traceCategory, tid, "{\"size\":" + this.getTarget().getFile().length() + ", \"path\": \"" + this.ioOp.getTarget().getRelativePath() + "\"}");
        }
    }

    @Override
    public FileReference getTarget() {
        return this.ioOp.getTarget();
    }

    @Override
    public ILSMIndexAccessor getAccessor() {
        return this.ioOp.getAccessor();
    }

    @Override
    public LSMComponentFileReferences getComponentFiles() {
        return this.ioOp.getComponentFiles();
    }
}

