/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.common.IIndexAccessParameters;

public class PrefixMergePolicy
implements ILSMMergePolicy {
    protected long maxMergableComponentSize;
    protected int maxToleranceComponentCount;
    private static final double MAX_MERGABLE_COMPONENT_SIZE_RATIO = 1.2;

    @Override
    public void diskComponentAdded(ILSMIndex index, boolean fullMergeIsRequested) throws HyracksDataException {
        ArrayList<ILSMDiskComponent> immutableComponents = new ArrayList<ILSMDiskComponent>(index.getDiskComponents());
        if (!this.areComponentsReadableWritableState(immutableComponents)) {
            return;
        }
        if (fullMergeIsRequested) {
            ILSMIndexAccessor accessor = index.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
            accessor.scheduleFullMerge(index.getIOOperationCallback());
            return;
        }
        this.scheduleMerge(index);
    }

    @Override
    public void configure(Map<String, String> properties) {
        this.maxMergableComponentSize = Long.parseLong(properties.get("max-mergable-component-size"));
        this.maxToleranceComponentCount = Integer.parseInt(properties.get("max-tolerance-component-count"));
    }

    @Override
    public boolean isMergeLagging(ILSMIndex index) throws HyracksDataException {
        ArrayList<ILSMDiskComponent> immutableComponents = new ArrayList<ILSMDiskComponent>(index.getDiskComponents());
        Collections.reverse(immutableComponents);
        int mergableImmutableComponentCount = this.getMergableImmutableComponentCount(immutableComponents);
        if (mergableImmutableComponentCount < this.maxToleranceComponentCount) {
            return false;
        }
        boolean isMergeOngoing = this.isMergeOngoing(immutableComponents);
        if (isMergeOngoing) {
            return true;
        }
        if (!this.areComponentsReadableWritableState(immutableComponents)) {
            throw new IllegalStateException();
        }
        boolean isMergeTriggered = this.scheduleMerge(index);
        if (!isMergeTriggered) {
            throw new IllegalStateException();
        }
        return true;
    }

    protected boolean isMergeOngoing(List<ILSMDiskComponent> immutableComponents) {
        int size = immutableComponents.size();
        for (int i = 0; i < size; ++i) {
            if (immutableComponents.get(i).getState() != ILSMComponent.ComponentState.READABLE_MERGING) continue;
            return true;
        }
        return false;
    }

    protected int getMergableImmutableComponentCount(List<ILSMDiskComponent> immutableComponents) {
        Pair<Integer, Integer> mergableIndexes = this.getMergableComponentsIndex(immutableComponents);
        return mergableIndexes == null ? 0 : (Integer)mergableIndexes.getRight() - (Integer)mergableIndexes.getLeft() + 1;
    }

    protected boolean areComponentsReadableWritableState(List<ILSMDiskComponent> immutableComponents) {
        for (ILSMComponent iLSMComponent : immutableComponents) {
            if (iLSMComponent.getState() == ILSMComponent.ComponentState.READABLE_UNWRITABLE) continue;
            return false;
        }
        return true;
    }

    protected boolean scheduleMerge(ILSMIndex index) throws HyracksDataException {
        ArrayList<ILSMDiskComponent> immutableComponents = new ArrayList<ILSMDiskComponent>(index.getDiskComponents());
        Collections.reverse(immutableComponents);
        Pair<Integer, Integer> mergeableIndexes = this.getMergableComponentsIndex(immutableComponents);
        if (mergeableIndexes != null) {
            this.triggerScheduleMerge(index, immutableComponents, (Integer)mergeableIndexes.getLeft(), (Integer)mergeableIndexes.getRight());
            return true;
        }
        return false;
    }

    private void triggerScheduleMerge(ILSMIndex index, List<ILSMDiskComponent> immutableComponents, int startIndex, int endIndex) throws HyracksDataException {
        ArrayList<ILSMDiskComponent> mergableComponents = new ArrayList<ILSMDiskComponent>(immutableComponents.subList(startIndex, endIndex + 1));
        Collections.reverse(mergableComponents);
        ILSMIndexAccessor accessor = index.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
        accessor.scheduleMerge(index.getIOOperationCallback(), mergableComponents);
    }

    protected Pair<Integer, Integer> getMergableComponentsIndex(List<ILSMDiskComponent> immutableComponents) {
        int numComponents = immutableComponents.size();
        for (int i = 0; i < numComponents; ++i) {
            long componentSize;
            int j;
            long startComponentSize;
            if (immutableComponents.get(i).getComponentSize() > this.maxMergableComponentSize || immutableComponents.get(i).getState() != ILSMComponent.ComponentState.READABLE_UNWRITABLE) continue;
            long totalSize = startComponentSize = immutableComponents.get(i).getComponentSize();
            boolean mergeable = true;
            for (j = i + 1; j < numComponents && (componentSize = immutableComponents.get(j).getComponentSize()) <= this.maxMergableComponentSize && immutableComponents.get(j).getState() == ILSMComponent.ComponentState.READABLE_UNWRITABLE; ++j) {
                boolean bl = mergeable = (double)startComponentSize < 1.2 * (double)((totalSize += componentSize) - startComponentSize);
                if (totalSize > this.maxMergableComponentSize && mergeable) {
                    return Pair.of((Object)i, (Object)j);
                }
                if ((double)startComponentSize >= 1.2 * (double)(totalSize + componentSize * (long)(numComponents - j - 1) - startComponentSize)) break;
            }
            if (j != numComponents) continue;
            if (numComponents - i >= this.maxToleranceComponentCount && mergeable) {
                return Pair.of((Object)i, (Object)(numComponents - 1));
            }
            if (numComponents - i >= this.maxToleranceComponentCount) continue;
            return null;
        }
        return null;
    }
}

