/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndexMetadataFrame;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentMetadata;
import org.apache.hyracks.storage.am.lsm.common.impls.DiskComponentMetadata;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MemoryComponentMetadata
implements IComponentMetadata {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final List<Pair<IValueReference, ArrayBackedValueStorage>> store = new ArrayList<Pair<IValueReference, ArrayBackedValueStorage>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(IValueReference key, IValueReference value) throws HyracksDataException {
        this.lock.writeLock().lock();
        try {
            ArrayBackedValueStorage stored = this.get(key);
            if (stored == null) {
                stored = new ArrayBackedValueStorage();
                this.store.add((Pair<IValueReference, ArrayBackedValueStorage>)Pair.of((Object)key, (Object)stored));
            }
            stored.assign(value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(IValueReference key, ArrayBackedValueStorage value) throws HyracksDataException {
        this.lock.readLock().lock();
        try {
            value.reset();
            ArrayBackedValueStorage stored = this.get(key);
            if (stored != null) {
                value.append((IValueReference)stored);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayBackedValueStorage get(IValueReference key) {
        this.lock.readLock().lock();
        try {
            for (Pair<IValueReference, ArrayBackedValueStorage> pair : this.store) {
                if (!((IValueReference)pair.getKey()).equals(key)) continue;
                ArrayBackedValueStorage arrayBackedValueStorage = (ArrayBackedValueStorage)pair.getValue();
                return arrayBackedValueStorage;
            }
            Iterator<Pair<IValueReference, ArrayBackedValueStorage>> iterator = null;
            return iterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(IMetadataPageManager mdpManager) throws HyracksDataException {
        this.lock.readLock().lock();
        try {
            LOGGER.log(Level.INFO, "Copying Metadata into a different component");
            ITreeIndexMetadataFrame frame = mdpManager.createMetadataFrame();
            for (Pair<IValueReference, ArrayBackedValueStorage> pair : this.store) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.log(Level.INFO, "Copying " + pair.getKey() + " : " + ((ArrayBackedValueStorage)pair.getValue()).getLength() + " bytes");
                }
                mdpManager.put(frame, (IValueReference)pair.getKey(), (IValueReference)pair.getValue());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void copy(DiskComponentMetadata metadata) throws HyracksDataException {
        this.lock.readLock().lock();
        try {
            metadata.put(this);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void reset() {
        this.lock.writeLock().lock();
        try {
            this.store.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

