/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.common.IIndexBulkLoader;

public class LSMIndexDiskComponentBulkLoader
implements IIndexBulkLoader {
    private final AbstractLSMIndex lsmIndex;
    private final ILSMDiskComponentBulkLoader componentBulkLoader;
    private ILSMIndexOperationContext opCtx;

    public LSMIndexDiskComponentBulkLoader(AbstractLSMIndex lsmIndex, ILSMIndexOperationContext opCtx, float fillFactor, boolean verifyInput, long numElementsHint) throws HyracksDataException {
        this.lsmIndex = lsmIndex;
        this.opCtx = opCtx;
        opCtx.setNewComponent(lsmIndex.createBulkLoadTarget());
        this.componentBulkLoader = opCtx.getNewComponent().createBulkLoader(fillFactor, verifyInput, numElementsHint, false, true, true);
    }

    public ILSMDiskComponent getComponent() {
        return this.opCtx.getNewComponent();
    }

    public void add(ITupleReference tuple) throws HyracksDataException {
        this.componentBulkLoader.add(tuple);
    }

    public void delete(ITupleReference tuple) throws HyracksDataException {
        this.componentBulkLoader.delete(tuple);
    }

    public void end() throws HyracksDataException {
        try {
            this.componentBulkLoader.end();
            if (this.opCtx.getNewComponent().getComponentSize() > 0L) {
                this.lsmIndex.getIOOperationCallback().afterOperation(this.opCtx);
                this.lsmIndex.getHarness().addBulkLoadedComponent(this.opCtx.getNewComponent());
            }
        }
        finally {
            this.lsmIndex.getIOOperationCallback().afterFinalize(this.opCtx);
        }
    }

    public void abort() throws HyracksDataException {
        try {
            this.componentBulkLoader.abort();
            this.opCtx.setNewComponent(null);
            this.lsmIndex.getIOOperationCallback().afterOperation(this.opCtx);
        }
        finally {
            this.lsmIndex.getIOOperationCallback().afterFinalize(this.opCtx);
        }
    }
}

