/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.replication.IReplicationJob;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.IFrameOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.IFrameTupleProcessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.BlockingIOOperationCallbackWrapper;
import org.apache.hyracks.storage.am.lsm.common.impls.ComponentReplacementContext;
import org.apache.hyracks.storage.am.lsm.common.impls.EmptyComponent;
import org.apache.hyracks.storage.am.lsm.common.util.IOOperationUtils;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.util.trace.ITracer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LSMHarness
implements ILSMHarness {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final ILSMIndex lsmIndex;
    protected final ComponentReplacementContext componentReplacementCtx;
    protected final ILSMMergePolicy mergePolicy;
    protected final ILSMOperationTracker opTracker;
    protected final AtomicBoolean fullMergeIsRequested;
    protected final boolean replicationEnabled;
    protected List<ILSMDiskComponent> componentsToBeReplicated;
    protected ITracer tracer;
    protected long traceCategory;

    public LSMHarness(ILSMIndex lsmIndex, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, boolean replicationEnabled, ITracer tracer) {
        this.lsmIndex = lsmIndex;
        this.opTracker = opTracker;
        this.mergePolicy = mergePolicy;
        this.tracer = tracer;
        this.traceCategory = tracer.getRegistry().get("release-memory-component");
        this.fullMergeIsRequested = new AtomicBoolean();
        boolean bl = this.replicationEnabled = replicationEnabled && lsmIndex.isDurable();
        if (replicationEnabled) {
            this.componentsToBeReplicated = new ArrayList<ILSMDiskComponent>();
        }
        this.componentReplacementCtx = new ComponentReplacementContext(lsmIndex);
    }

    /*
     * Exception decompiling
     */
    protected boolean getAndEnterComponents(ILSMIndexOperationContext ctx, LSMOperationType opType, boolean isTryOperation) throws HyracksDataException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 12[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void recycle(ILSMMemoryComponent flushingComponent) throws HyracksDataException {
        if (flushingComponent.getState() == ILSMComponent.ComponentState.READABLE_UNWRITABLE) {
            flushingComponent.setState(ILSMComponent.ComponentState.READABLE_WRITABLE);
            this.opTracker.notifyAll();
            this.lsmIndex.getIOOperationCallback().recycled(flushingComponent, false);
        }
    }

    protected boolean enterComponents(ILSMIndexOperationContext ctx, LSMOperationType opType) throws HyracksDataException {
        boolean entranceSuccessful;
        block15: {
            int i;
            this.validateOperationEnterComponentsState(ctx);
            List<ILSMComponent> components = ctx.getComponentHolder();
            int numEntered = 0;
            entranceSuccessful = false;
            try {
                for (ILSMComponent c : components) {
                    boolean isMutableComponent;
                    boolean bl = isMutableComponent = numEntered == 0 && c.getType() == ILSMComponent.LSMComponentType.MEMORY;
                    if (!c.threadEnter(opType, isMutableComponent)) break;
                    ++numEntered;
                }
                boolean bl = entranceSuccessful = numEntered == components.size();
                if (entranceSuccessful) break block15;
                i = 0;
            }
            catch (Throwable e) {
                try {
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.log(Level.ERROR, opType.name() + " failed to enter components on " + this.lsmIndex, e);
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    if (!entranceSuccessful) {
                        int i2 = 0;
                        for (ILSMComponent c : components) {
                            if (numEntered == 0) break;
                            boolean isMutableComponent = i2 == 0 && c.getType() == ILSMComponent.LSMComponentType.MEMORY;
                            c.threadExit(opType, true, isMutableComponent);
                            ++i2;
                            --numEntered;
                        }
                    }
                    throw throwable;
                }
            }
            for (ILSMComponent c : components) {
                if (numEntered != 0) {
                    boolean isMutableComponent = i == 0 && c.getType() == ILSMComponent.LSMComponentType.MEMORY;
                    c.threadExit(opType, true, isMutableComponent);
                    ++i;
                    --numEntered;
                    continue;
                }
                break;
            }
        }
        if (!entranceSuccessful) {
            return false;
        }
        ctx.setAccessingComponents(true);
        switch (opType) {
            case FLUSH: {
                ctx.setIoOperationType(ILSMIOOperation.LSMIOOperationType.FLUSH);
                this.lsmIndex.getIOOperationCallback().beforeOperation(ctx);
                this.lsmIndex.changeFlushStatusForCurrentMutableCompoent(false);
                this.lsmIndex.changeMutableComponent();
                this.opTracker.notifyAll();
                break;
            }
            case MERGE: {
                ctx.setIoOperationType(ILSMIOOperation.LSMIOOperationType.MERGE);
                this.lsmIndex.getIOOperationCallback().beforeOperation(ctx);
                break;
            }
        }
        this.opTracker.beforeOperation(this.lsmIndex, opType, ctx.getSearchOperationCallback(), (IModificationOperationCallback)ctx.getModificationCallback());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExitComponents(ILSMIndexOperationContext ctx, LSMOperationType opType, ILSMDiskComponent newComponent, boolean failedOperation) throws HyracksDataException {
        if (!ctx.isAccessingComponents() && opType != LSMOperationType.FLUSH && opType != LSMOperationType.MERGE) {
            return;
        }
        List<ILSMDiskComponent> inactiveDiskComponents = null;
        List inactiveDiskComponentsToBeDeleted = null;
        try {
            ILSMOperationTracker iLSMOperationTracker = this.opTracker;
            synchronized (iLSMOperationTracker) {
                block34: {
                    block32: {
                        try {
                            if (opType == LSMOperationType.FLUSH) {
                                this.opTracker.notifyAll();
                                if (!failedOperation) {
                                    this.waitForLaggingMerge();
                                }
                            } else if (opType == LSMOperationType.MERGE) {
                                this.opTracker.notifyAll();
                            }
                            this.exitOperationalComponents(ctx, opType, failedOperation);
                            ctx.setAccessingComponents(false);
                            this.exitOperation(ctx, opType, newComponent, failedOperation);
                            if (!failedOperation || opType != LSMOperationType.MODIFICATION && opType != LSMOperationType.FORCE_MODIFICATION) break block32;
                        }
                        catch (Throwable e) {
                            try {
                                if (LOGGER.isErrorEnabled()) {
                                    LOGGER.log(Level.ERROR, e.getMessage(), e);
                                }
                                throw e;
                            }
                            catch (Throwable throwable) {
                                if (failedOperation && (opType == LSMOperationType.MODIFICATION || opType == LSMOperationType.FORCE_MODIFICATION)) {
                                    this.opTracker.completeOperation(this.lsmIndex, opType, ctx.getSearchOperationCallback(), (IModificationOperationCallback)ctx.getModificationCallback());
                                } else {
                                    this.opTracker.afterOperation(this.lsmIndex, opType, ctx.getSearchOperationCallback(), (IModificationOperationCallback)ctx.getModificationCallback());
                                }
                                inactiveDiskComponents = this.lsmIndex.getInactiveDiskComponents();
                                if (!inactiveDiskComponents.isEmpty()) {
                                    for (ILSMDiskComponent inactiveComp : inactiveDiskComponents) {
                                        if (inactiveComp.getFileReferenceCount() != 1) continue;
                                        inactiveDiskComponentsToBeDeleted = inactiveDiskComponentsToBeDeleted == null ? new LinkedList() : inactiveDiskComponentsToBeDeleted;
                                        inactiveDiskComponentsToBeDeleted.add(inactiveComp);
                                    }
                                    if (inactiveDiskComponentsToBeDeleted != null) {
                                        inactiveDiskComponents.removeAll(inactiveDiskComponentsToBeDeleted);
                                    }
                                }
                                throw throwable;
                            }
                        }
                        this.opTracker.completeOperation(this.lsmIndex, opType, ctx.getSearchOperationCallback(), (IModificationOperationCallback)ctx.getModificationCallback());
                        break block34;
                    }
                    this.opTracker.afterOperation(this.lsmIndex, opType, ctx.getSearchOperationCallback(), (IModificationOperationCallback)ctx.getModificationCallback());
                }
                inactiveDiskComponents = this.lsmIndex.getInactiveDiskComponents();
                if (!inactiveDiskComponents.isEmpty()) {
                    for (ILSMDiskComponent inactiveComp : inactiveDiskComponents) {
                        if (inactiveComp.getFileReferenceCount() != 1) continue;
                        inactiveDiskComponentsToBeDeleted = inactiveDiskComponentsToBeDeleted == null ? new LinkedList() : inactiveDiskComponentsToBeDeleted;
                        inactiveDiskComponentsToBeDeleted.add(inactiveComp);
                    }
                    if (inactiveDiskComponentsToBeDeleted != null) {
                        inactiveDiskComponents.removeAll(inactiveDiskComponentsToBeDeleted);
                    }
                }
            }
        }
        finally {
            if (inactiveDiskComponentsToBeDeleted != null) {
                try {
                    if (this.replicationEnabled) {
                        this.lsmIndex.scheduleReplication(null, inactiveDiskComponentsToBeDeleted, false, IReplicationJob.ReplicationOperation.DELETE, opType);
                    }
                    for (ILSMDiskComponent c : inactiveDiskComponentsToBeDeleted) {
                        c.deactivateAndDestroy();
                    }
                }
                catch (Throwable e) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.log(Level.WARN, "Failure scheduling replication or destroying merged component", e);
                    }
                    throw e;
                }
            }
        }
    }

    private void exitOperation(ILSMIndexOperationContext ctx, LSMOperationType opType, ILSMDiskComponent newComponent, boolean failedOperation) throws HyracksDataException {
        switch (opType) {
            case FLUSH: {
                if (failedOperation || newComponent == null) break;
                this.lsmIndex.addDiskComponent(newComponent);
                if (this.replicationEnabled && newComponent != EmptyComponent.INSTANCE) {
                    this.componentsToBeReplicated.clear();
                    this.componentsToBeReplicated.add(newComponent);
                    this.triggerReplication(this.componentsToBeReplicated, false, opType);
                }
                this.mergePolicy.diskComponentAdded(this.lsmIndex, false);
                break;
            }
            case MERGE: {
                if (failedOperation || newComponent == null) break;
                this.lsmIndex.subsumeMergedComponents(newComponent, ctx.getComponentHolder());
                if (this.replicationEnabled && newComponent != EmptyComponent.INSTANCE) {
                    this.componentsToBeReplicated.clear();
                    this.componentsToBeReplicated.add(newComponent);
                    this.triggerReplication(this.componentsToBeReplicated, false, opType);
                }
                this.mergePolicy.diskComponentAdded(this.lsmIndex, this.fullMergeIsRequested.get());
                break;
            }
        }
    }

    private void exitOperationalComponents(ILSMIndexOperationContext ctx, LSMOperationType opType, boolean failedOperation) throws HyracksDataException {
        block4: for (int i = 0; i < ctx.getComponentHolder().size(); ++i) {
            ILSMComponent c = ctx.getComponentHolder().get(i);
            boolean isMutableComponent = i == 0 && c.getType() == ILSMComponent.LSMComponentType.MEMORY;
            c.threadExit(opType, failedOperation, isMutableComponent);
            if (c.getType() == ILSMComponent.LSMComponentType.MEMORY) {
                switch (c.getState()) {
                    case READABLE_UNWRITABLE: {
                        if (!isMutableComponent || opType != LSMOperationType.MODIFICATION && opType != LSMOperationType.FORCE_MODIFICATION) continue block4;
                        this.lsmIndex.changeFlushStatusForCurrentMutableCompoent(true);
                        break;
                    }
                    case INACTIVE: {
                        this.tracer.instant(c.toString(), this.traceCategory, ITracer.Scope.p, this.lsmIndex.toString());
                        ((AbstractLSMMemoryComponent)c).reset();
                        this.opTracker.notifyAll();
                        break;
                    }
                }
                continue;
            }
            if (c.getState() != ILSMComponent.ComponentState.INACTIVE) continue;
            this.lsmIndex.addInactiveDiskComponent((AbstractLSMDiskComponent)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitComponents(ILSMIndexOperationContext ctx, LSMOperationType opType, ILSMDiskComponent newComponent, boolean failedOperation) throws HyracksDataException {
        long before = 0L;
        if (ctx.isTracingEnabled()) {
            before = System.nanoTime();
        }
        try {
            this.doExitComponents(ctx, opType, newComponent, failedOperation);
        }
        finally {
            if (ctx.isTracingEnabled()) {
                ctx.incrementEnterExitTime(System.nanoTime() - before);
            }
        }
    }

    @Override
    public void forceModify(ILSMIndexOperationContext ctx, ITupleReference tuple) throws HyracksDataException {
        LSMOperationType opType = LSMOperationType.FORCE_MODIFICATION;
        this.modify(ctx, false, tuple, opType);
    }

    @Override
    public boolean modify(ILSMIndexOperationContext ctx, boolean tryOperation, ITupleReference tuple) throws HyracksDataException {
        LSMOperationType opType = LSMOperationType.MODIFICATION;
        return this.modify(ctx, tryOperation, tuple, opType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMeta(ILSMIndexOperationContext ctx, IValueReference key, IValueReference value) throws HyracksDataException {
        if (!this.lsmIndex.isMemoryComponentsAllocated()) {
            this.lsmIndex.allocateMemoryComponents();
        }
        this.getAndEnterComponents(ctx, LSMOperationType.MODIFICATION, false);
        try {
            AbstractLSMMemoryComponent c = (AbstractLSMMemoryComponent)ctx.getComponentHolder().get(0);
            c.getMetadata().put(key, value);
            c.setModified();
        }
        finally {
            this.exitAndComplete(ctx, LSMOperationType.MODIFICATION);
        }
    }

    private void exitAndComplete(ILSMIndexOperationContext ctx, LSMOperationType op) throws HyracksDataException {
        try {
            this.exitComponents(ctx, op, null, false);
        }
        finally {
            this.opTracker.completeOperation(null, op, null, (IModificationOperationCallback)ctx.getModificationCallback());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceUpdateMeta(ILSMIndexOperationContext ctx, IValueReference key, IValueReference value) throws HyracksDataException {
        if (!this.lsmIndex.isMemoryComponentsAllocated()) {
            this.lsmIndex.allocateMemoryComponents();
        }
        this.getAndEnterComponents(ctx, LSMOperationType.FORCE_MODIFICATION, false);
        try {
            AbstractLSMMemoryComponent c = (AbstractLSMMemoryComponent)ctx.getComponentHolder().get(0);
            c.getMetadata().put(key, value);
            c.setModified();
        }
        finally {
            this.exitAndComplete(ctx, LSMOperationType.FORCE_MODIFICATION);
        }
    }

    private boolean modify(ILSMIndexOperationContext ctx, boolean tryOperation, ITupleReference tuple, LSMOperationType opType) throws HyracksDataException {
        if (!this.lsmIndex.isMemoryComponentsAllocated()) {
            this.lsmIndex.allocateMemoryComponents();
        }
        boolean failedOperation = false;
        if (!this.getAndEnterComponents(ctx, opType, tryOperation)) {
            return false;
        }
        try {
            this.lsmIndex.modify(ctx, tuple);
            AbstractLSMMemoryComponent mutableComponent = (AbstractLSMMemoryComponent)ctx.getComponentHolder().get(0);
            mutableComponent.setModified();
        }
        catch (Exception e) {
            failedOperation = true;
            throw e;
        }
        finally {
            this.exitComponents(ctx, opType, null, failedOperation);
        }
        return true;
    }

    @Override
    public void search(ILSMIndexOperationContext ctx, IIndexCursor cursor, ISearchPredicate pred) throws HyracksDataException {
        LSMOperationType opType = LSMOperationType.SEARCH;
        ctx.setSearchPredicate(pred);
        this.getAndEnterComponents(ctx, opType, false);
        try {
            ctx.getSearchOperationCallback().before(pred.getLowKey());
            this.lsmIndex.search(ctx, cursor, pred);
        }
        catch (Exception e) {
            this.exitComponents(ctx, opType, null, true);
            throw e;
        }
    }

    @Override
    public void endSearch(ILSMIndexOperationContext ctx) throws HyracksDataException {
        if (ctx.getOperation() == IndexOperation.SEARCH) {
            try {
                this.exitComponents(ctx, LSMOperationType.SEARCH, null, false);
            }
            catch (Exception e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }

    @Override
    public void scanDiskComponents(ILSMIndexOperationContext ctx, IIndexCursor cursor) throws HyracksDataException {
        if (!this.lsmIndex.isPrimaryIndex()) {
            throw HyracksDataException.create((int)56, (Serializable[])new Serializable[0]);
        }
        LSMOperationType opType = LSMOperationType.DISK_COMPONENT_SCAN;
        this.getAndEnterComponents(ctx, opType, false);
        try {
            ctx.getSearchOperationCallback().before(null);
            this.lsmIndex.scanDiskComponents(ctx, cursor);
        }
        catch (Exception e) {
            this.exitComponents(ctx, opType, null, true);
            throw e;
        }
    }

    @Override
    public void endScanDiskComponents(ILSMIndexOperationContext ctx) throws HyracksDataException {
        if (ctx.getOperation() == IndexOperation.DISK_COMPONENT_SCAN) {
            try {
                this.exitComponents(ctx, LSMOperationType.DISK_COMPONENT_SCAN, null, false);
            }
            catch (Exception e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }

    @Override
    public void scheduleFlush(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException {
        if (!this.getAndEnterComponents(ctx, LSMOperationType.FLUSH, true)) {
            ctx.setIoOperationType(ILSMIOOperation.LSMIOOperationType.FLUSH);
            callback.afterFinalize(ctx);
            return;
        }
        this.lsmIndex.scheduleFlush(ctx, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(ILSMIndexOperationContext ctx, ILSMIOOperation operation) throws HyracksDataException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Started a flush operation for index: " + this.lsmIndex + " ...");
        }
        try {
            ILSMDiskComponent newComponent = null;
            boolean failedOperation = false;
            try {
                newComponent = this.lsmIndex.flush(operation);
                ctx.setNewComponent(newComponent);
                ctx.setIoOperationType(ILSMIOOperation.LSMIOOperationType.FLUSH);
                operation.getCallback().afterOperation(ctx);
                newComponent.markAsValid(this.lsmIndex.isDurable());
            }
            catch (Throwable e) {
                failedOperation = true;
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.log(Level.ERROR, "Flush failed on " + this.lsmIndex, e);
                }
                throw e;
            }
            finally {
                this.exitComponents(ctx, LSMOperationType.FLUSH, newComponent, failedOperation);
                ctx.setIoOperationType(ILSMIOOperation.LSMIOOperationType.FLUSH);
                operation.getCallback().afterFinalize(ctx);
            }
        }
        finally {
            this.opTracker.completeOperation(this.lsmIndex, LSMOperationType.FLUSH, ctx.getSearchOperationCallback(), (IModificationOperationCallback)ctx.getModificationCallback());
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Finished the flush operation for index: " + this.lsmIndex);
        }
    }

    @Override
    public void scheduleMerge(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException {
        if (!this.getAndEnterComponents(ctx, LSMOperationType.MERGE, true)) {
            LOGGER.info("Failed to enter components for merge operation. Calling finalize");
            ctx.setIoOperationType(ILSMIOOperation.LSMIOOperationType.MERGE);
            callback.afterFinalize(ctx);
            return;
        }
        this.lsmIndex.scheduleMerge(ctx, callback);
    }

    @Override
    public void scheduleFullMerge(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException {
        this.fullMergeIsRequested.set(true);
        if (!this.getAndEnterComponents(ctx, LSMOperationType.MERGE, true)) {
            ctx.setIoOperationType(ILSMIOOperation.LSMIOOperationType.MERGE);
            callback.afterFinalize(ctx);
            return;
        }
        this.fullMergeIsRequested.set(false);
        this.lsmIndex.scheduleMerge(ctx, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(ILSMIndexOperationContext ctx, ILSMIOOperation operation) throws HyracksDataException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Started a merge operation for index: " + this.lsmIndex + " ...");
        }
        try {
            ILSMDiskComponent newComponent = null;
            boolean failedOperation = false;
            try {
                newComponent = this.lsmIndex.merge(operation);
                ctx.setNewComponent(newComponent);
                ctx.setIoOperationType(ILSMIOOperation.LSMIOOperationType.MERGE);
                operation.getCallback().afterOperation(ctx);
                newComponent.markAsValid(this.lsmIndex.isDurable());
            }
            catch (Throwable e) {
                failedOperation = true;
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.log(Level.ERROR, "Failed merge operation on " + this.lsmIndex, e);
                }
                throw e;
            }
            finally {
                this.exitComponents(ctx, LSMOperationType.MERGE, newComponent, failedOperation);
                operation.getCallback().afterFinalize(ctx);
            }
        }
        finally {
            this.opTracker.completeOperation(this.lsmIndex, LSMOperationType.MERGE, ctx.getSearchOperationCallback(), (IModificationOperationCallback)ctx.getModificationCallback());
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Finished the merge operation for index: " + this.lsmIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBulkLoadedComponent(ILSMDiskComponent c) throws HyracksDataException {
        c.markAsValid(this.lsmIndex.isDurable());
        ILSMOperationTracker iLSMOperationTracker = this.opTracker;
        synchronized (iLSMOperationTracker) {
            this.lsmIndex.addDiskComponent(c);
            if (this.replicationEnabled) {
                this.componentsToBeReplicated.clear();
                this.componentsToBeReplicated.add(c);
                this.triggerReplication(this.componentsToBeReplicated, true, LSMOperationType.MERGE);
            }
            this.mergePolicy.diskComponentAdded(this.lsmIndex, false);
        }
    }

    @Override
    public ILSMOperationTracker getOperationTracker() {
        return this.opTracker;
    }

    protected void triggerReplication(List<ILSMDiskComponent> lsmComponents, boolean bulkload, LSMOperationType opType) throws HyracksDataException {
        ILSMIndexAccessor accessor = this.lsmIndex.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
        accessor.scheduleReplication(lsmComponents, bulkload, opType);
    }

    @Override
    public void scheduleReplication(ILSMIndexOperationContext ctx, List<ILSMDiskComponent> lsmComponents, boolean bulkload, LSMOperationType opType) throws HyracksDataException {
        if (!this.getAndEnterComponents(ctx, LSMOperationType.REPLICATE, false)) {
            return;
        }
        this.lsmIndex.scheduleReplication(ctx, lsmComponents, bulkload, IReplicationJob.ReplicationOperation.REPLICATE, opType);
    }

    @Override
    public void endReplication(ILSMIndexOperationContext ctx) throws HyracksDataException {
        this.exitComponents(ctx, LSMOperationType.REPLICATE, null, false);
    }

    protected void validateOperationEnterComponentsState(ILSMIndexOperationContext ctx) {
        if (ctx.isAccessingComponents()) {
            throw new IllegalStateException("Operation already has access to components of index " + this.lsmIndex);
        }
    }

    @Override
    public void updateFilter(ILSMIndexOperationContext ctx, ITupleReference tuple) throws HyracksDataException {
        if (!this.lsmIndex.isMemoryComponentsAllocated()) {
            this.lsmIndex.allocateMemoryComponents();
        }
        this.lsmIndex.updateFilter(ctx, tuple);
    }

    private void enter(ILSMIndexOperationContext ctx) throws HyracksDataException {
        if (!this.lsmIndex.isMemoryComponentsAllocated()) {
            this.lsmIndex.allocateMemoryComponents();
        }
        this.getAndEnterComponents(ctx, LSMOperationType.MODIFICATION, false);
    }

    private void exit(ILSMIndexOperationContext ctx) throws HyracksDataException {
        this.getAndExitComponentsAndComplete(ctx, LSMOperationType.MODIFICATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAndExitComponentsAndComplete(ILSMIndexOperationContext ctx, LSMOperationType op) throws HyracksDataException {
        this.validateOperationEnterComponentsState(ctx);
        ILSMOperationTracker iLSMOperationTracker = this.opTracker;
        synchronized (iLSMOperationTracker) {
            this.lsmIndex.getOperationalComponents(ctx);
            ctx.setAccessingComponents(true);
            this.exitAndComplete(ctx, op);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchOperate(ILSMIndexOperationContext ctx, FrameTupleAccessor accessor, FrameTupleReference tuple, IFrameTupleProcessor processor, IFrameOperationCallback frameOpCallback) throws HyracksDataException {
        processor.start();
        this.enter(ctx);
        try {
            try {
                LSMHarness.processFrame(accessor, tuple, processor);
                frameOpCallback.frameCompleted();
            }
            finally {
                processor.finish();
            }
        }
        catch (HyracksDataException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.log(Level.ERROR, "Failed to process frame", (Throwable)e);
            }
            throw e;
        }
        finally {
            this.exit(ctx);
            ctx.logPerformanceCounters(accessor.getTupleCount());
        }
    }

    private void ensureIndexModifiable() throws HyracksDataException {
        if (this.lsmIndex.hasFlushRequestForCurrentMutableComponent()) {
            return;
        }
        for (ILSMMemoryComponent memoryComponent : this.lsmIndex.getMemoryComponents()) {
            switch (memoryComponent.getState()) {
                case INACTIVE: 
                case UNREADABLE_UNWRITABLE: 
                case READABLE_WRITABLE: 
                case READABLE_UNWRITABLE_FLUSHING: {
                    return;
                }
            }
        }
        throw HyracksDataException.create((int)88, (Serializable[])new Serializable[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForLaggingMerge() throws HyracksDataException {
        ILSMOperationTracker iLSMOperationTracker = this.opTracker;
        synchronized (iLSMOperationTracker) {
            while (this.mergePolicy.isMergeLagging(this.lsmIndex)) {
                try {
                    this.opTracker.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    if (!LOGGER.isWarnEnabled()) continue;
                    LOGGER.log(Level.WARN, "Ignoring interrupt while waiting for lagging merge on " + this.lsmIndex, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteComponents(ILSMIndexOperationContext ctx, Predicate<ILSMComponent> predicate) throws HyracksDataException {
        ArrayList<ILSMDiskComponent> toBeDeleted;
        BlockingIOOperationCallbackWrapper ioCallback = new BlockingIOOperationCallbackWrapper(this.lsmIndex.getIOOperationCallback());
        boolean deleteMemoryComponent = false;
        ILSMOperationTracker iLSMOperationTracker = this.opTracker;
        synchronized (iLSMOperationTracker) {
            this.waitForFlushesAndMerges();
            this.ensureNoFailedFlush();
            if (this.lsmIndex.isMemoryComponentsAllocated()) {
                ILSMMemoryComponent memComponent = this.lsmIndex.getCurrentMemoryComponent();
                deleteMemoryComponent = predicate.test(memComponent);
                if (deleteMemoryComponent) {
                    ctx.reset();
                    ctx.setOperation(IndexOperation.DELETE_MEMORY_COMPONENT);
                    this.scheduleFlush(ctx, ioCallback);
                } else {
                    return;
                }
            }
        }
        if (deleteMemoryComponent) {
            IOOperationUtils.waitForIoOperation(ioCallback);
        }
        ctx.reset();
        ioCallback = new BlockingIOOperationCallbackWrapper(this.lsmIndex.getIOOperationCallback());
        ctx.setOperation(IndexOperation.DELETE_DISK_COMPONENTS);
        ILSMOperationTracker iLSMOperationTracker2 = this.opTracker;
        synchronized (iLSMOperationTracker2) {
            this.waitForFlushesAndMerges();
            this.ensureNoFailedFlush();
            List<ILSMDiskComponent> diskComponents = this.lsmIndex.getDiskComponents();
            for (ILSMDiskComponent component : diskComponents) {
                if (!predicate.test(component)) break;
                ctx.getComponentsToBeMerged().add(component);
            }
            if (ctx.getComponentsToBeMerged().isEmpty()) {
                return;
            }
            toBeDeleted = new ArrayList<ILSMDiskComponent>(ctx.getComponentsToBeMerged());
            this.scheduleMerge(ctx, ioCallback);
        }
        IOOperationUtils.waitForIoOperation(ioCallback);
        iLSMOperationTracker2 = this.opTracker;
        synchronized (iLSMOperationTracker2) {
            for (ILSMDiskComponent component : toBeDeleted) {
                if (!this.lsmIndex.getDiskComponents().contains(component)) continue;
                throw HyracksDataException.create((int)99, (Serializable[])new Serializable[]{component.toString()});
            }
        }
    }

    private void ensureNoFailedFlush() throws HyracksDataException {
        for (ILSMMemoryComponent memoryComponent : this.lsmIndex.getMemoryComponents()) {
            if (memoryComponent.getState() != ILSMComponent.ComponentState.READABLE_UNWRITABLE) continue;
            throw HyracksDataException.create((int)98, (Serializable[])new Serializable[0]);
        }
    }

    private void waitForFlushesAndMerges() throws HyracksDataException {
        while (this.flushingOrMerging()) {
            try {
                this.opTracker.wait();
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARN, "Interrupted while attempting component level delete", (Throwable)e);
                Thread.currentThread().interrupt();
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }

    private boolean flushingOrMerging() {
        for (ILSMMemoryComponent memComponent : this.lsmIndex.getMemoryComponents()) {
            if (memComponent.getState() != ILSMComponent.ComponentState.READABLE_UNWRITABLE_FLUSHING) continue;
            return true;
        }
        for (ILSMDiskComponent diskComponent : this.lsmIndex.getDiskComponents()) {
            if (diskComponent.getState() != ILSMComponent.ComponentState.READABLE_MERGING) continue;
            return true;
        }
        return false;
    }

    private static void processFrame(FrameTupleAccessor accessor, FrameTupleReference tuple, IFrameTupleProcessor processor) throws HyracksDataException {
        int tupleCount = accessor.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            tuple.reset((IFrameTupleAccessor)accessor, i);
            processor.process((ITupleReference)tuple, i);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.lsmIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceMemoryComponentsWithDiskComponents(ILSMIndexOperationContext ctx, int startIndex) throws HyracksDataException {
        ILSMOperationTracker iLSMOperationTracker = this.opTracker;
        synchronized (iLSMOperationTracker) {
            this.componentReplacementCtx.reset();
            for (int i = 0; i < ctx.getComponentHolder().size(); ++i) {
                ILSMComponent next;
                if (i < startIndex || (next = ctx.getComponentHolder().get(i)).getType() != ILSMComponent.LSMComponentType.MEMORY || next.getState() != ILSMComponent.ComponentState.UNREADABLE_UNWRITABLE) continue;
                this.componentReplacementCtx.getComponentHolder().add(next);
                this.componentReplacementCtx.swapIndex(i);
            }
            if (this.componentReplacementCtx.getComponentHolder().isEmpty()) {
                throw new IllegalStateException("replaceMemoryComponentsWithDiskComponents called with no potential components");
            }
            if (this.componentReplacementCtx.proceed(this.lsmIndex.getDiskComponents())) {
                this.exitComponents(this.componentReplacementCtx, LSMOperationType.SEARCH, null, false);
                this.componentReplacementCtx.prepareToEnter();
                this.enterComponents(this.componentReplacementCtx, LSMOperationType.SEARCH);
                this.componentReplacementCtx.replace(ctx);
            }
        }
    }
}

