/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;

public class LSMComponentId
implements ILSMComponentId {
    public static final long NOT_FOUND = -1L;
    public static final ILSMComponentId MISSING_COMPONENT_ID = new LSMComponentId(-1L, -1L);
    public static final ILSMComponentId DEFAULT_COMPONENT_ID = new LSMComponentId(0L, 0L);
    private long minId;
    private long maxId;

    public LSMComponentId(long minId, long maxId) {
        assert (minId <= maxId);
        this.minId = minId;
        this.maxId = maxId;
    }

    public void reset(long minId, long maxId) {
        this.minId = minId;
        this.maxId = maxId;
    }

    public long getMinId() {
        return this.minId;
    }

    public long getMaxId() {
        return this.maxId;
    }

    @Override
    public boolean missing() {
        return this.minId == -1L || this.maxId == -1L;
    }

    public String toString() {
        return "[" + this.minId + "," + this.maxId + "]";
    }

    public int hashCode() {
        return 31 * Long.hashCode(this.minId) + Long.hashCode(this.maxId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LSMComponentId)) {
            return false;
        }
        LSMComponentId other = (LSMComponentId)obj;
        return this.maxId == other.maxId && this.minId == other.minId;
    }

    @Override
    public ILSMComponentId.IdCompareResult compareTo(ILSMComponentId id) {
        if (this.missing() || id == null || id.missing()) {
            return ILSMComponentId.IdCompareResult.UNKNOWN;
        }
        LSMComponentId componentId = (LSMComponentId)id;
        if (this.getMinId() > componentId.getMaxId()) {
            return ILSMComponentId.IdCompareResult.GREATER_THAN;
        }
        if (this.getMaxId() < componentId.getMinId()) {
            return ILSMComponentId.IdCompareResult.LESS_THAN;
        }
        if (this.getMinId() <= componentId.getMinId() && this.getMaxId() >= componentId.getMaxId()) {
            return ILSMComponentId.IdCompareResult.INCLUDE;
        }
        return ILSMComponentId.IdCompareResult.INTERSECT;
    }
}

