/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.Objects;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractIoOperation;

public abstract class FlushOperation
extends AbstractIoOperation
implements Comparable<ILSMIOOperation> {
    public FlushOperation(ILSMIndexAccessor accessor, FileReference target, ILSMIOOperationCallback callback, String indexIdentifier) {
        super(accessor, target, callback, indexIdentifier);
    }

    @Override
    public Boolean call() throws HyracksDataException {
        this.accessor.flush(this);
        return true;
    }

    @Override
    public ILSMIOOperationCallback getCallback() {
        return this.callback;
    }

    @Override
    public ILSMIndexAccessor getAccessor() {
        return this.accessor;
    }

    public ILSMComponent getFlushingComponent() {
        return this.accessor.getOpContext().getComponentHolder().get(0);
    }

    @Override
    public String getIndexIdentifier() {
        return this.indexIdentifier;
    }

    @Override
    public ILSMIOOperation.LSMIOOperationType getIOOpertionType() {
        return ILSMIOOperation.LSMIOOperationType.FLUSH;
    }

    @Override
    public int compareTo(ILSMIOOperation o) {
        if (o instanceof FlushOperation) {
            return this.target.getFile().getName().compareTo(((FlushOperation)o).getTarget().getFile().getName());
        }
        return -1;
    }

    public boolean equals(Object o) {
        return o instanceof FlushOperation && Objects.equals(this.target.getFile().getName(), ((FlushOperation)o).target.getFile().getName());
    }

    public int hashCode() {
        return this.target.getFile().getName().hashCode();
    }
}

