/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.LinkedList;
import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.impls.IChainedComponentBulkLoader;

public class ChainedLSMDiskComponentBulkLoader
implements ILSMDiskComponentBulkLoader {
    private List<IChainedComponentBulkLoader> bulkloaderChain = new LinkedList<IChainedComponentBulkLoader>();
    private boolean isEmptyComponent = true;
    private boolean cleanedUpArtifacts = false;
    private final ILSMDiskComponent diskComponent;
    private final boolean cleanupEmptyComponent;

    public ChainedLSMDiskComponentBulkLoader(ILSMDiskComponent diskComponent, boolean cleanupEmptyComponent) {
        this.diskComponent = diskComponent;
        this.cleanupEmptyComponent = cleanupEmptyComponent;
    }

    public void addBulkLoader(IChainedComponentBulkLoader bulkloader) {
        this.bulkloaderChain.add(bulkloader);
    }

    public void add(ITupleReference tuple) throws HyracksDataException {
        try {
            ITupleReference t = tuple;
            for (IChainedComponentBulkLoader lsmBulkloader : this.bulkloaderChain) {
                t = lsmBulkloader.add(t);
            }
        }
        catch (Exception e) {
            this.cleanupArtifacts();
            throw e;
        }
        if (this.isEmptyComponent) {
            this.isEmptyComponent = false;
        }
    }

    @Override
    public void delete(ITupleReference tuple) throws HyracksDataException {
        try {
            ITupleReference t = tuple;
            for (IChainedComponentBulkLoader lsmOperation : this.bulkloaderChain) {
                t = lsmOperation.delete(t);
            }
        }
        catch (Exception e) {
            this.cleanupArtifacts();
            throw e;
        }
        if (this.isEmptyComponent) {
            this.isEmptyComponent = false;
        }
    }

    @Override
    public void cleanupArtifacts() throws HyracksDataException {
        if (!this.cleanedUpArtifacts) {
            this.cleanedUpArtifacts = true;
            for (IChainedComponentBulkLoader lsmOperation : this.bulkloaderChain) {
                lsmOperation.cleanupArtifacts();
            }
        }
        this.diskComponent.deactivateAndDestroy();
    }

    public void end() throws HyracksDataException {
        if (!this.cleanedUpArtifacts) {
            for (IChainedComponentBulkLoader lsmOperation : this.bulkloaderChain) {
                lsmOperation.end();
            }
            if (this.isEmptyComponent && this.cleanupEmptyComponent) {
                this.cleanupArtifacts();
            }
        }
    }

    public void abort() throws HyracksDataException {
        for (IChainedComponentBulkLoader lsmOperation : this.bulkloaderChain) {
            lsmOperation.abort();
        }
    }
}

