/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.util.IoUtil;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexMetadataFrame;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public abstract class AbstractLSMIndexFileManager
implements ILSMIndexFileManager {
    public static final String DELIMITER = "_";
    public static final String BTREE_SUFFIX = "b";
    public static final String RTREE_SUFFIX = "r";
    public static final String BLOOM_FILTER_SUFFIX = "f";
    public static final String DELETE_TREE_SUFFIX = "d";
    public static final String TXN_PREFIX = ".T";
    public static final String COMPONENT_TIMESTAMP_FORMAT = "yyyy-MM-dd-HH-mm-ss-SSS";
    public static final FilenameFilter COMPONENT_FILES_FILTER = (dir, name) -> !name.startsWith(".");
    protected static final FilenameFilter txnFileNameFilter = (dir, name) -> name.startsWith(TXN_PREFIX);
    protected static FilenameFilter bloomFilterFilter = (dir, name) -> !name.startsWith(".") && name.endsWith(BLOOM_FILTER_SUFFIX);
    protected static final FilenameFilter dummyFilter = (dir, name) -> true;
    protected static final Comparator<String> cmp = new FileNameComparator();
    protected final IIOManager ioManager;
    protected final FileReference baseDir;
    protected final Format formatter = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
    protected final Comparator<ComparableFileName> recencyCmp = new RecencyComparator();
    protected final TreeIndexFactory<? extends ITreeIndex> treeFactory;
    private String prevTimestamp = null;

    public AbstractLSMIndexFileManager(IIOManager ioManager, FileReference file, TreeIndexFactory<? extends ITreeIndex> treeFactory) {
        this.ioManager = ioManager;
        this.baseDir = file;
        this.treeFactory = treeFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TreeIndexState isValidTreeIndex(ITreeIndex treeIndex) throws HyracksDataException {
        IBufferCache bufferCache = treeIndex.getBufferCache();
        treeIndex.activate();
        try {
            ICachedPage page;
            block13: {
                ITreeIndexMetadataFrame metadataFrame;
                block12: {
                    TreeIndexState treeIndexState;
                    int metadataPage = treeIndex.getPageManager().getMetadataPageId();
                    if (metadataPage < 0) {
                        TreeIndexState treeIndexState2 = TreeIndexState.INVALID;
                        return treeIndexState2;
                    }
                    metadataFrame = treeIndex.getPageManager().createMetadataFrame();
                    page = bufferCache.pin(BufferedFileHandle.getDiskPageId((int)treeIndex.getFileId(), (int)metadataPage), false);
                    page.acquireReadLatch();
                    try {
                        metadataFrame.setPage(page);
                        if (metadataFrame.isValid()) break block12;
                        treeIndexState = TreeIndexState.INVALID;
                    }
                    catch (Throwable throwable) {
                        page.releaseReadLatch();
                        bufferCache.unpin(page);
                        throw throwable;
                    }
                    page.releaseReadLatch();
                    bufferCache.unpin(page);
                    return treeIndexState;
                }
                if (metadataFrame.getVersion() == 6) break block13;
                TreeIndexState treeIndexState = TreeIndexState.VERSION_MISMATCH;
                page.releaseReadLatch();
                bufferCache.unpin(page);
                return treeIndexState;
            }
            TreeIndexState treeIndexState = TreeIndexState.VALID;
            page.releaseReadLatch();
            bufferCache.unpin(page);
            return treeIndexState;
        }
        finally {
            treeIndex.deactivate();
        }
    }

    protected void cleanupAndGetValidFilesInternal(FilenameFilter filter, TreeIndexFactory<? extends ITreeIndex> treeFactory, ArrayList<ComparableFileName> allFiles) throws HyracksDataException {
        String[] files;
        for (String fileName : files = AbstractLSMIndexFileManager.listDirFiles(this.baseDir, filter)) {
            FileReference fileRef = this.baseDir.getChild(fileName);
            if (treeFactory == null) {
                allFiles.add(new ComparableFileName(fileRef));
                continue;
            }
            TreeIndexState idxState = this.isValidTreeIndex((ITreeIndex)treeFactory.createIndexInstance(fileRef));
            if (idxState == TreeIndexState.VALID) {
                allFiles.add(new ComparableFileName(fileRef));
                continue;
            }
            if (idxState != TreeIndexState.INVALID) continue;
            fileRef.delete();
        }
    }

    static String[] listDirFiles(FileReference dir, FilenameFilter filter) throws HyracksDataException {
        String[] files = dir.getFile().list(filter);
        if (files == null) {
            if (!dir.getFile().canRead()) {
                throw HyracksDataException.create((int)28, (Serializable[])new Serializable[]{dir});
            }
            if (!dir.getFile().exists()) {
                throw HyracksDataException.create((int)30, (Serializable[])new Serializable[]{dir});
            }
            if (!dir.getFile().isDirectory()) {
                throw HyracksDataException.create((int)27, (Serializable[])new Serializable[]{dir});
            }
            throw HyracksDataException.create((int)29, (Serializable[])new Serializable[]{dir});
        }
        return files;
    }

    protected void validateFiles(HashSet<String> groundTruth, ArrayList<ComparableFileName> validFiles, FilenameFilter filter, TreeIndexFactory<? extends ITreeIndex> treeFactory) throws HyracksDataException {
        ArrayList<ComparableFileName> tmpAllInvListsFiles = new ArrayList<ComparableFileName>();
        this.cleanupAndGetValidFilesInternal(filter, treeFactory, tmpAllInvListsFiles);
        for (ComparableFileName cmpFileName : tmpAllInvListsFiles) {
            int index = cmpFileName.fileName.lastIndexOf(DELIMITER);
            String file = cmpFileName.fileName.substring(0, index);
            if (groundTruth.contains(file)) {
                validFiles.add(cmpFileName);
                continue;
            }
            File invalidFile = new File(cmpFileName.fullPath);
            IoUtil.delete((File)invalidFile);
        }
    }

    @Override
    public void createDirs() throws HyracksDataException {
        if (this.baseDir.getFile().exists()) {
            throw HyracksDataException.create((int)80, (Serializable[])new Serializable[0]);
        }
        this.baseDir.getFile().mkdirs();
    }

    @Override
    public void deleteDirs() throws HyracksDataException {
        IoUtil.delete((FileReference)this.baseDir);
    }

    @Override
    public LSMComponentFileReferences getRelFlushFileReference() throws HyracksDataException {
        String ts = this.getCurrentTimestamp();
        return new LSMComponentFileReferences(this.baseDir.getChild(ts + DELIMITER + ts), null, null);
    }

    @Override
    public LSMComponentFileReferences getRelMergeFileReference(String firstFileName, String lastFileName) throws HyracksDataException {
        String[] firstTimestampRange = firstFileName.split(DELIMITER);
        String[] lastTimestampRange = lastFileName.split(DELIMITER);
        return new LSMComponentFileReferences(this.baseDir.getChild(firstTimestampRange[0] + DELIMITER + lastTimestampRange[1]), null, null);
    }

    @Override
    public List<LSMComponentFileReferences> cleanupAndGetValidFiles() throws HyracksDataException {
        ArrayList<LSMComponentFileReferences> validFiles = new ArrayList<LSMComponentFileReferences>();
        ArrayList<ComparableFileName> allFiles = new ArrayList<ComparableFileName>();
        this.cleanupAndGetValidFilesInternal(COMPONENT_FILES_FILTER, this.treeFactory, allFiles);
        if (allFiles.isEmpty()) {
            return validFiles;
        }
        if (allFiles.size() == 1) {
            validFiles.add(new LSMComponentFileReferences(allFiles.get((int)0).fileRef, null, null));
            return validFiles;
        }
        Collections.sort(allFiles);
        ArrayList<ComparableFileName> validComparableFiles = new ArrayList<ComparableFileName>();
        ComparableFileName last = allFiles.get(0);
        validComparableFiles.add(last);
        for (int i = 1; i < allFiles.size(); ++i) {
            ComparableFileName current = allFiles.get(i);
            if (current.interval[0].compareTo(last.interval[1]) > 0) {
                validComparableFiles.add(current);
                last = current;
                continue;
            }
            if (current.interval[0].compareTo(last.interval[0]) >= 0 && current.interval[1].compareTo(last.interval[1]) <= 0) {
                current.fileRef.delete();
                continue;
            }
            throw HyracksDataException.create((int)84, (Serializable[])new Serializable[]{this.baseDir});
        }
        Collections.sort(validComparableFiles, this.recencyCmp);
        for (ComparableFileName cmpFileName : validComparableFiles) {
            validFiles.add(new LSMComponentFileReferences(cmpFileName.fileRef, null, null));
        }
        return validFiles;
    }

    @Override
    public Comparator<String> getFileNameComparator() {
        return cmp;
    }

    @Override
    public FileReference getBaseDir() {
        return this.baseDir;
    }

    @Override
    public void recoverTransaction() throws HyracksDataException {
        String[] files = AbstractLSMIndexFileManager.listDirFiles(this.baseDir, txnFileNameFilter);
        if (files.length != 0) {
            if (files.length > 1) {
                throw HyracksDataException.create((int)85, (Serializable[])new Serializable[]{this.baseDir});
            }
            IoUtil.delete((FileReference)this.baseDir.getChild(files[0]));
        }
    }

    @Override
    public void deleteTransactionFiles() throws HyracksDataException {
        String[] files = AbstractLSMIndexFileManager.listDirFiles(this.baseDir, txnFileNameFilter);
        if (files.length != 0) {
            String[] componentsFiles;
            if (files.length > 1) {
                throw HyracksDataException.create((int)85, (Serializable[])new Serializable[]{this.baseDir});
            }
            FilenameFilter transactionFilter = AbstractLSMIndexFileManager.createTransactionFilter(files[0], true);
            for (String fileName : componentsFiles = AbstractLSMIndexFileManager.listDirFiles(this.baseDir, transactionFilter)) {
                FileReference file = this.baseDir.getChild(fileName);
                IoUtil.delete((FileReference)file);
            }
            IoUtil.delete((FileReference)this.baseDir.getChild(files[0]));
        }
    }

    @Override
    public LSMComponentFileReferences getNewTransactionFileReference() throws IOException {
        return null;
    }

    @Override
    public LSMComponentFileReferences getTransactionFileReferenceForCommit() throws HyracksDataException {
        return null;
    }

    protected static FilenameFilter createTransactionFilter(String transactionFileName, boolean inclusive) {
        String timeStamp = transactionFileName.substring(transactionFileName.indexOf(TXN_PREFIX) + TXN_PREFIX.length());
        return (dir, name) -> inclusive ? name.startsWith(timeStamp) : !name.startsWith(timeStamp);
    }

    protected FilenameFilter getTransactionFileFilter(boolean inclusive) throws HyracksDataException {
        String[] files = AbstractLSMIndexFileManager.listDirFiles(this.baseDir, txnFileNameFilter);
        if (files.length == 0) {
            return dummyFilter;
        }
        return AbstractLSMIndexFileManager.createTransactionFilter(files[0], inclusive);
    }

    protected FilenameFilter getCompoundFilter(FilenameFilter filter1, FilenameFilter filter2) {
        return (dir, name) -> filter1.accept(dir, name) && filter2.accept(dir, name);
    }

    protected String getCurrentTimestamp() {
        Date date = new Date();
        String ts = this.formatter.format(date);
        while (this.prevTimestamp != null && ts.compareTo(this.prevTimestamp) == 0) {
            try {
                Thread.sleep(1L);
                date = new Date();
                ts = this.formatter.format(date);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.prevTimestamp = ts;
        return ts;
    }

    public static String getComponentStartTime(String fileName) {
        return fileName.split(DELIMITER)[0];
    }

    public static String getComponentEndTime(String fileName) {
        return fileName.split(DELIMITER)[1];
    }

    private class RecencyComparator
    implements Comparator<ComparableFileName> {
        private RecencyComparator() {
        }

        @Override
        public int compare(ComparableFileName a, ComparableFileName b) {
            int cmp = -a.interval[0].compareTo(b.interval[0]);
            if (cmp != 0) {
                return cmp;
            }
            return -a.interval[1].compareTo(b.interval[1]);
        }
    }

    protected class ComparableFileName
    implements Comparable<ComparableFileName> {
        public final FileReference fileRef;
        public final String fullPath;
        public final String fileName;
        public final String[] interval;

        public ComparableFileName(FileReference fileRef) {
            this.fileRef = fileRef;
            this.fullPath = fileRef.getFile().getAbsolutePath();
            this.fileName = fileRef.getFile().getName();
            this.interval = this.fileName.split(AbstractLSMIndexFileManager.DELIMITER);
        }

        @Override
        public int compareTo(ComparableFileName b) {
            int startCmp = this.interval[0].compareTo(b.interval[0]);
            if (startCmp != 0) {
                return startCmp;
            }
            return b.interval[1].compareTo(this.interval[1]);
        }
    }

    private static class FileNameComparator
    implements Comparator<String> {
        private FileNameComparator() {
        }

        @Override
        public int compare(String a, String b) {
            return -a.compareTo(b);
        }
    }

    public static enum TreeIndexState {
        INVALID,
        VERSION_MISMATCH,
        VALID;

    }
}

