/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.ChainedLSMDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.impls.DiskComponentMetadata;
import org.apache.hyracks.storage.am.lsm.common.impls.FilterBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.impls.IChainedComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.util.ComponentUtils;
import org.apache.hyracks.storage.am.lsm.common.util.LSMComponentIdUtils;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractLSMDiskComponent
extends AbstractLSMComponent
implements ILSMDiskComponent {
    private static final Logger LOGGER = LogManager.getLogger();
    private final DiskComponentMetadata metadata;
    private final ArrayBackedValueStorage buffer = new ArrayBackedValueStorage(8);
    private ILSMComponentId componentId;

    public AbstractLSMDiskComponent(AbstractLSMIndex lsmIndex, IMetadataPageManager mdPageManager, ILSMComponentFilter filter) {
        super(lsmIndex, filter);
        this.state = ILSMComponent.ComponentState.READABLE_UNWRITABLE;
        this.metadata = new DiskComponentMetadata(mdPageManager);
    }

    @Override
    public boolean threadEnter(LSMOperationType opType, boolean isMutableComponent) {
        if (this.state == ILSMComponent.ComponentState.INACTIVE) {
            throw new IllegalStateException("Trying to enter an inactive disk component");
        }
        switch (opType) {
            case FORCE_MODIFICATION: 
            case MODIFICATION: 
            case REPLICATE: 
            case SEARCH: 
            case DISK_COMPONENT_SCAN: {
                ++this.readerCount;
                break;
            }
            case MERGE: {
                if (this.state == ILSMComponent.ComponentState.READABLE_MERGING) {
                    return false;
                }
                this.state = ILSMComponent.ComponentState.READABLE_MERGING;
                ++this.readerCount;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported operation " + (Object)((Object)opType));
            }
        }
        return true;
    }

    @Override
    public void threadExit(LSMOperationType opType, boolean failedOperation, boolean isMutableComponent) throws HyracksDataException {
        switch (opType) {
            case MERGE: {
                if (failedOperation) {
                    this.state = ILSMComponent.ComponentState.READABLE_UNWRITABLE;
                }
            }
            case FORCE_MODIFICATION: 
            case MODIFICATION: 
            case REPLICATE: 
            case SEARCH: 
            case DISK_COMPONENT_SCAN: {
                --this.readerCount;
                if (this.readerCount != 0 || this.state != ILSMComponent.ComponentState.READABLE_MERGING) break;
                this.state = ILSMComponent.ComponentState.INACTIVE;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported operation " + (Object)((Object)opType));
            }
        }
        if (this.readerCount <= -1) {
            throw new IllegalStateException("Invalid LSM disk component readerCount: " + this.readerCount);
        }
    }

    @Override
    public DiskComponentMetadata getMetadata() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILSMComponentId getId() throws HyracksDataException {
        if (this.componentId != null) {
            return this.componentId;
        }
        AbstractLSMDiskComponent abstractLSMDiskComponent = this;
        synchronized (abstractLSMDiskComponent) {
            if (this.componentId == null) {
                this.componentId = LSMComponentIdUtils.readFrom(this.metadata, this.buffer);
            }
        }
        if (this.componentId.missing()) {
            LOGGER.warn("Component Id not found from disk component metadata");
        }
        return this.componentId;
    }

    @Override
    public void markAsValid(boolean persist) throws HyracksDataException {
        ComponentUtils.markAsValid(this.getMetadataHolder(), persist);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.log(Level.INFO, "Marked as valid component with id: " + this.getId());
        }
    }

    @Override
    public void activate(boolean createNewComponent) throws HyracksDataException {
        if (createNewComponent) {
            this.getIndex().create();
        }
        this.getIndex().activate();
        if (this.getLSMComponentFilter() != null && !createNewComponent) {
            this.getLsmIndex().getFilterManager().readFilter(this.getLSMComponentFilter(), this.getMetadataHolder());
        }
    }

    @Override
    public void deactivateAndDestroy() throws HyracksDataException {
        this.getIndex().deactivate();
        this.getIndex().destroy();
    }

    @Override
    public void destroy() throws HyracksDataException {
        this.getIndex().destroy();
    }

    @Override
    public void deactivate() throws HyracksDataException {
        this.getIndex().deactivate();
    }

    @Override
    public void deactivateAndPurge() throws HyracksDataException {
        this.getIndex().deactivate();
        this.getIndex().purge();
    }

    @Override
    public void validate() throws HyracksDataException {
        this.getIndex().validate();
    }

    @Override
    public IChainedComponentBulkLoader createFilterBulkLoader() throws HyracksDataException {
        return new FilterBulkLoader(this.getLSMComponentFilter(), this.getMetadataHolder(), this.getLsmIndex().getFilterManager(), this.getLsmIndex().getTreeFields(), this.getLsmIndex().getFilterFields(), MultiComparator.create((IBinaryComparatorFactory[])this.getLSMComponentFilter().getFilterCmpFactories()));
    }

    @Override
    public IChainedComponentBulkLoader createIndexBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex) throws HyracksDataException {
        return new LSMIndexBulkLoader(this.getIndex().createBulkLoader(fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex));
    }

    @Override
    public ChainedLSMDiskComponentBulkLoader createBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, boolean withFilter, boolean cleanupEmptyComponent) throws HyracksDataException {
        ChainedLSMDiskComponentBulkLoader chainedBulkLoader = new ChainedLSMDiskComponentBulkLoader(this, cleanupEmptyComponent);
        if (withFilter && this.getLsmIndex().getFilterFields() != null) {
            chainedBulkLoader.addBulkLoader(this.createFilterBulkLoader());
        }
        chainedBulkLoader.addBulkLoader(this.createIndexBulkLoader(fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex));
        return chainedBulkLoader;
    }

    public String toString() {
        return "{\"class\":" + this.getClass().getSimpleName() + "\", \"index\":" + this.getIndex().toString() + "}";
    }
}

