/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.aggreg;

import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluatorFactory;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.std.group.AbstractAccumulatingAggregatorDescriptorFactory;
import org.apache.hyracks.dataflow.std.group.AggregateState;
import org.apache.hyracks.dataflow.std.group.IAggregatorDescriptor;

public class SimpleAlgebricksAccumulatingAggregatorFactory
extends AbstractAccumulatingAggregatorDescriptorFactory {
    private static final long serialVersionUID = 1L;
    private IAggregateEvaluatorFactory[] aggFactories;

    public SimpleAlgebricksAccumulatingAggregatorFactory(IAggregateEvaluatorFactory[] aggFactories, int[] keys) {
        this.aggFactories = aggFactories;
    }

    public IAggregatorDescriptor createAggregator(final IHyracksTaskContext ctx, RecordDescriptor inRecordDesc, RecordDescriptor outRecordDescriptor, int[] aggKeys, int[] partialKeys, long memoryBudget) throws HyracksDataException {
        return new IAggregatorDescriptor(){
            private FrameTupleReference ftr = new FrameTupleReference();
            private IPointable p = VoidPointable.FACTORY.createPointable();

            public void init(ArrayTupleBuilder tupleBuilder, IFrameTupleAccessor accessor, int tIndex, AggregateState state) throws HyracksDataException {
                int i;
                IAggregateEvaluator[] agg = (IAggregateEvaluator[])state.state;
                for (i = 0; i < agg.length; ++i) {
                    agg[i].init();
                }
                this.ftr.reset(accessor, tIndex);
                for (i = 0; i < agg.length; ++i) {
                    agg[i].step((IFrameTupleReference)this.ftr);
                }
            }

            public void aggregate(IFrameTupleAccessor accessor, int tIndex, IFrameTupleAccessor stateAccessor, int stateTupleIndex, AggregateState state) throws HyracksDataException {
                IAggregateEvaluator[] agg = (IAggregateEvaluator[])state.state;
                this.ftr.reset(accessor, tIndex);
                for (int i = 0; i < agg.length; ++i) {
                    agg[i].step((IFrameTupleReference)this.ftr);
                }
            }

            public boolean outputFinalResult(ArrayTupleBuilder tupleBuilder, IFrameTupleAccessor stateAccessor, int tIndex, AggregateState state) throws HyracksDataException {
                IAggregateEvaluator[] agg = (IAggregateEvaluator[])state.state;
                for (int i = 0; i < agg.length; ++i) {
                    agg[i].finish(this.p);
                    tupleBuilder.addField(this.p.getByteArray(), this.p.getStartOffset(), this.p.getLength());
                }
                return true;
            }

            public AggregateState createAggregateStates() throws HyracksDataException {
                IAggregateEvaluator[] agg = new IAggregateEvaluator[SimpleAlgebricksAccumulatingAggregatorFactory.this.aggFactories.length];
                for (int i = 0; i < agg.length; ++i) {
                    agg[i] = SimpleAlgebricksAccumulatingAggregatorFactory.this.aggFactories[i].createAggregateEvaluator(ctx);
                }
                return new AggregateState((Object)agg);
            }

            public void reset() {
            }

            public boolean outputPartialResult(ArrayTupleBuilder tupleBuilder, IFrameTupleAccessor stateAccessor, int tIndex, AggregateState state) throws HyracksDataException {
                IAggregateEvaluator[] agg = (IAggregateEvaluator[])state.state;
                for (int i = 0; i < agg.length; ++i) {
                    agg[i].finishPartial(this.p);
                    tupleBuilder.addField(this.p.getByteArray(), this.p.getStartOffset(), this.p.getLength());
                }
                return true;
            }

            public void close() {
            }
        };
    }
}

