/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.aggregators;

import java.io.IOException;
import org.apache.hyracks.algebricks.runtime.base.IRunningAggregateEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IRunningAggregateEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class TupleCountRunningAggregateFunctionFactory
implements IRunningAggregateEvaluatorFactory {
    private static final long serialVersionUID = 1L;

    @Override
    public IRunningAggregateEvaluator createRunningAggregateEvaluator(IHyracksTaskContext ctx) throws HyracksDataException {
        final ArrayBackedValueStorage abvs = new ArrayBackedValueStorage();
        return new IRunningAggregateEvaluator(){
            int cnt;

            @Override
            public void step(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                try {
                    ++this.cnt;
                    abvs.reset();
                    abvs.getDataOutput().writeInt(this.cnt);
                    result.set((IValueReference)abvs);
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }

            @Override
            public void init() throws HyracksDataException {
                this.cnt = 0;
            }
        };
    }
}

