/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.work;

import java.util.List;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.dataset.IDatasetPartitionManager;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.Task;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NotifyTaskFailureWork
extends AbstractWork {
    private static final Logger LOGGER = LogManager.getLogger();
    private final NodeControllerService ncs;
    private final Task task;
    private final JobId jobId;
    private final TaskAttemptId taskId;
    private final List<Exception> exceptions;

    public NotifyTaskFailureWork(NodeControllerService ncs, Task task, List<Exception> exceptions, JobId jobId, TaskAttemptId taskId) {
        this.ncs = ncs;
        this.task = task;
        this.exceptions = exceptions;
        this.jobId = jobId;
        this.taskId = taskId;
    }

    public void run() {
        LOGGER.log(Level.WARN, this.ncs.getId() + " is sending a notification to cc that task " + this.taskId + " has failed", (Throwable)this.exceptions.get(0));
        try {
            IDatasetPartitionManager dpm = this.ncs.getDatasetPartitionManager();
            if (dpm != null) {
                dpm.abortReader(this.jobId);
            }
            this.ncs.getClusterController(this.jobId.getCcId()).notifyTaskFailure(this.jobId, this.taskId, this.ncs.getId(), this.exceptions);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Failure reporting task failure to cluster controller", (Throwable)e);
        }
        if (this.task != null) {
            this.task.getJoblet().removeTask(this.task);
        }
    }
}

