/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.work;

import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.ActivityClusterGraph;
import org.apache.hyracks.api.job.DeployedJobSpecId;
import org.apache.hyracks.control.common.deployment.DeploymentUtils;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.nc.NodeControllerService;

public class DeployJobSpecWork
extends AbstractWork {
    private final NodeControllerService ncs;
    private final byte[] acgBytes;
    private final CcId ccId;
    private final DeployedJobSpecId deployedJobSpecId;

    public DeployJobSpecWork(NodeControllerService ncs, DeployedJobSpecId deployedJobSpecId, byte[] acgBytes, CcId ccId) {
        this.ncs = ncs;
        this.deployedJobSpecId = deployedJobSpecId;
        this.acgBytes = acgBytes;
        this.ccId = ccId;
    }

    public void run() {
        try {
            this.ncs.checkForDuplicateDeployedJobSpec(this.deployedJobSpecId);
            ActivityClusterGraph acg = (ActivityClusterGraph)DeploymentUtils.deserialize((byte[])this.acgBytes, null, (IServiceContext)this.ncs.getContext());
            this.ncs.storeActivityClusterGraph(this.deployedJobSpecId, acg);
        }
        catch (HyracksException e) {
            try {
                this.ncs.getClusterController(this.ccId).notifyDeployedJobSpecFailure(this.deployedJobSpecId, this.ncs.getId());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }
}

