/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.work;

import java.util.ArrayDeque;
import java.util.Collection;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.dataset.IDatasetPartitionManager;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.common.work.SynchronizableWork;
import org.apache.hyracks.control.nc.Joblet;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.Task;
import org.apache.hyracks.control.nc.work.CleanupJobletWork;
import org.apache.hyracks.control.nc.work.EnsureAllCcTasksCompleted;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AbortAllJobsWork
extends SynchronizableWork {
    private static final Logger LOGGER = LogManager.getLogger();
    private final NodeControllerService ncs;
    private final CcId ccId;

    public AbortAllJobsWork(NodeControllerService ncs, CcId ccId) {
        this.ncs = ncs;
        this.ccId = ccId;
    }

    protected void doRun() throws Exception {
        LOGGER.info("Aborting all tasks for controller {}", (Object)this.ccId);
        IDatasetPartitionManager dpm = this.ncs.getDatasetPartitionManager();
        if (dpm == null) {
            LOGGER.log(Level.WARN, "DatasetPartitionManager is null on " + this.ncs.getId());
        }
        ArrayDeque<Task> abortedTasks = new ArrayDeque<Task>();
        Collection<Joblet> joblets = this.ncs.getJobletMap().values();
        joblets.stream().filter(joblet -> joblet.getJobId().getCcId().equals((Object)this.ccId)).forEach(joblet -> {
            joblet.getTaskMap().values().forEach(task -> {
                task.abort();
                abortedTasks.add((Task)task);
            });
            JobId jobId = joblet.getJobId();
            if (dpm != null) {
                dpm.abortReader(jobId);
                dpm.sweep(jobId);
            }
            this.ncs.getWorkQueue().schedule((AbstractWork)new CleanupJobletWork(this.ncs, jobId, JobStatus.FAILURE));
        });
        this.ncs.getExecutor().submit(new EnsureAllCcTasksCompleted(this.ncs, this.ccId, abortedTasks));
    }
}

