/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IChannelInterfaceFactory;
import org.apache.hyracks.api.comm.ICloseableBufferAcceptor;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.dataflow.ConnectorDescriptorId;
import org.apache.hyracks.api.exceptions.NetException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.partitions.PartitionId;
import org.apache.hyracks.comm.channels.IChannelConnectionFactory;
import org.apache.hyracks.comm.channels.NetworkOutputChannel;
import org.apache.hyracks.control.nc.partitions.PartitionManager;
import org.apache.hyracks.net.protocols.muxdemux.ChannelControlBlock;
import org.apache.hyracks.net.protocols.muxdemux.IChannelOpenListener;
import org.apache.hyracks.net.protocols.muxdemux.MultiplexedConnection;
import org.apache.hyracks.net.protocols.muxdemux.MuxDemux;
import org.apache.hyracks.net.protocols.muxdemux.MuxDemuxPerformanceCounters;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkManager
implements IChannelConnectionFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_CONNECTION_ATTEMPTS = 5;
    static final int INITIAL_MESSAGE_SIZE = 20;
    private final PartitionManager partitionManager;
    private final int nBuffers;
    private final MuxDemux md;
    private NetworkAddress localNetworkAddress;
    private NetworkAddress publicNetworkAddress;

    public NetworkManager(String inetAddress, int inetPort, PartitionManager partitionManager, int nThreads, int nBuffers, String publicInetAddress, int publicInetPort, IChannelInterfaceFactory channelInterfaceFactory) {
        this.partitionManager = partitionManager;
        this.nBuffers = nBuffers;
        this.md = new MuxDemux(new InetSocketAddress(inetAddress, inetPort), (IChannelOpenListener)new ChannelOpenListener(), nThreads, 5, channelInterfaceFactory);
        this.publicNetworkAddress = new NetworkAddress(publicInetAddress, publicInetPort);
    }

    public void start() throws IOException {
        this.md.start();
        InetSocketAddress sockAddr = this.md.getLocalAddress();
        this.localNetworkAddress = new NetworkAddress(sockAddr.getHostString(), sockAddr.getPort());
        if (this.publicNetworkAddress.getAddress() == null) {
            this.publicNetworkAddress = this.localNetworkAddress;
        } else if (this.publicNetworkAddress.getPort() == 0) {
            this.publicNetworkAddress = new NetworkAddress(this.publicNetworkAddress.getAddress(), sockAddr.getPort());
        }
    }

    public NetworkAddress getLocalNetworkAddress() {
        return this.localNetworkAddress;
    }

    public NetworkAddress getPublicNetworkAddress() {
        return this.publicNetworkAddress;
    }

    public void stop() {
    }

    public ChannelControlBlock connect(SocketAddress remoteAddress) throws InterruptedException, NetException {
        MultiplexedConnection mConn = this.md.connect((InetSocketAddress)remoteAddress);
        return mConn.openChannel();
    }

    private static PartitionId readInitialMessage(ByteBuffer buffer) {
        JobId jobId = new JobId(buffer.getLong());
        ConnectorDescriptorId cdid = new ConnectorDescriptorId(buffer.getInt());
        int senderIndex = buffer.getInt();
        int receiverIndex = buffer.getInt();
        return new PartitionId(jobId, cdid, senderIndex, receiverIndex);
    }

    public MuxDemuxPerformanceCounters getPerformanceCounters() {
        return this.md.getPerformanceCounters();
    }

    private class InitialBufferAcceptor
    implements ICloseableBufferAcceptor {
        private final ChannelControlBlock ccb;
        private NetworkOutputChannel noc;

        public InitialBufferAcceptor(ChannelControlBlock ccb) {
            this.ccb = ccb;
        }

        public void accept(ByteBuffer buffer) {
            PartitionId pid = NetworkManager.readInitialMessage(buffer);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Received initial partition request: " + pid + " on channel: " + this.ccb);
            }
            this.noc = new NetworkOutputChannel(this.ccb, NetworkManager.this.nBuffers);
            NetworkManager.this.partitionManager.registerPartitionRequest(pid, this.noc);
        }

        public void close() {
        }

        public void error(int ecode) {
            if (this.noc != null) {
                this.noc.abort();
            }
        }
    }

    private class ChannelOpenListener
    implements IChannelOpenListener {
        private ChannelOpenListener() {
        }

        public void channelOpened(ChannelControlBlock channel) {
            channel.getReadInterface().setFullBufferAcceptor((ICloseableBufferAcceptor)new InitialBufferAcceptor(channel));
            channel.getReadInterface().getEmptyBufferAcceptor().accept(ByteBuffer.allocate(20));
        }
    }
}

