/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.io;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IFileDeviceResolver;
import org.apache.hyracks.api.io.IFileHandle;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.api.util.InvokeUtil;
import org.apache.hyracks.api.util.IoUtil;
import org.apache.hyracks.control.nc.io.FileHandle;
import org.apache.hyracks.control.nc.io.IoRequest;
import org.apache.hyracks.control.nc.io.IoRequestHandler;
import org.apache.hyracks.util.InterruptibleAction;
import org.apache.hyracks.util.file.FileUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IOManager
implements IIOManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int IO_REQUEST_QUEUE_SIZE = 100;
    private static final String WORKSPACE_FILE_SUFFIX = ".waf";
    private static final FilenameFilter WORKSPACE_FILES_FILTER = (dir, name) -> name.endsWith(WORKSPACE_FILE_SUFFIX);
    private final ExecutorService executor;
    private final BlockingQueue<IoRequest> submittedRequests;
    private final BlockingQueue<IoRequest> freeRequests;
    private final List<IODeviceHandle> ioDevices;
    private final List<IODeviceHandle> workspaces;
    private int workspaceIndex;
    private IFileDeviceResolver deviceComputer;

    public IOManager(List<IODeviceHandle> devices, IFileDeviceResolver deviceComputer) throws HyracksDataException {
        this.ioDevices = Collections.unmodifiableList(devices);
        this.checkDeviceValidity(devices);
        this.workspaces = new ArrayList<IODeviceHandle>();
        for (IODeviceHandle d : this.ioDevices) {
            if (d.getWorkspace() == null) continue;
            try {
                FileUtil.forceMkdirs((File)new File(d.getMount(), d.getWorkspace()));
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            this.workspaces.add(d);
        }
        if (this.workspaces.isEmpty()) {
            throw new HyracksDataException("No devices with workspace found");
        }
        this.workspaceIndex = 0;
        this.deviceComputer = deviceComputer;
        this.submittedRequests = new ArrayBlockingQueue<IoRequest>(100);
        this.freeRequests = new ArrayBlockingQueue<IoRequest>(100);
        int numIoThreads = this.ioDevices.size() * 2;
        this.executor = Executors.newFixedThreadPool(numIoThreads);
        for (int i = 0; i < numIoThreads; ++i) {
            this.executor.execute(new IoRequestHandler(i, this.submittedRequests));
        }
    }

    public IoRequest getOrAllocRequest() {
        IoRequest request = (IoRequest)this.freeRequests.poll();
        if (request == null) {
            request = new IoRequest(this, this.submittedRequests, this.freeRequests);
        }
        return request;
    }

    private void checkDeviceValidity(List<IODeviceHandle> devices) throws HyracksDataException {
        for (IODeviceHandle d : devices) {
            Path p = Paths.get(d.getMount().toURI());
            for (IODeviceHandle e : devices) {
                if (e == d) continue;
                Path q = Paths.get(e.getMount().toURI());
                if (p.equals(q)) {
                    throw HyracksDataException.create((int)13, (Serializable[])new Serializable[0]);
                }
                if (!p.startsWith(q)) continue;
                throw HyracksDataException.create((int)14, (Serializable[])new Serializable[0]);
            }
        }
    }

    public List<IODeviceHandle> getIODevices() {
        return this.ioDevices;
    }

    public IFileHandle open(FileReference fileRef, IIOManager.FileReadWriteMode rwMode, IIOManager.FileSyncMode syncMode) throws HyracksDataException {
        FileHandle fHandle = new FileHandle(fileRef);
        try {
            fHandle.open(rwMode, syncMode);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        return fHandle;
    }

    public int syncWrite(IFileHandle fHandle, long offset, ByteBuffer data) throws HyracksDataException {
        IoRequest req = this.asyncWrite(fHandle, offset, data);
        InvokeUtil.doUninterruptibly((InterruptibleAction)req);
        try {
            if (req.getState() == IoRequest.State.OPERATION_SUCCEEDED) {
                int n = req.getWrite();
                return n;
            }
            if (req.getState() == IoRequest.State.OPERATION_FAILED) {
                throw req.getFailure();
            }
            throw new IllegalStateException("Write request completed with state " + (Object)((Object)req.getState()));
        }
        finally {
            req.recycle();
        }
    }

    public long syncWrite(IFileHandle fHandle, long offset, ByteBuffer[] dataArray) throws HyracksDataException {
        IoRequest req = this.asyncWrite(fHandle, offset, dataArray);
        InvokeUtil.doUninterruptibly((InterruptibleAction)req);
        try {
            if (req.getState() == IoRequest.State.OPERATION_SUCCEEDED) {
                long l = req.getWrites();
                return l;
            }
            if (req.getState() == IoRequest.State.OPERATION_FAILED) {
                throw req.getFailure();
            }
            throw new IllegalStateException("Write request completed with state " + (Object)((Object)req.getState()));
        }
        finally {
            req.recycle();
        }
    }

    public int doSyncWrite(IFileHandle fHandle, long offset, ByteBuffer data) throws HyracksDataException {
        try {
            if (fHandle == null) {
                throw new IllegalStateException("Trying to write to a deleted file.");
            }
            int n = 0;
            int remaining = data.remaining();
            while (remaining > 0) {
                int len = ((FileHandle)fHandle).getFileChannel().write(data, offset);
                if (len < 0) {
                    throw new HyracksDataException("Error writing to file: " + fHandle.getFileReference().toString());
                }
                remaining -= len;
                offset += (long)len;
                n += len;
            }
            return n;
        }
        catch (HyracksDataException e) {
            throw e;
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long doSyncWrite(IFileHandle fHandle, long offset, ByteBuffer[] dataArray) throws HyracksDataException {
        try {
            if (fHandle == null) {
                throw new IllegalStateException("Trying to write to a deleted file.");
            }
            int n = 0;
            int remaining = 0;
            for (ByteBuffer buf : dataArray) {
                remaining += buf.remaining();
            }
            FileChannel fileChannel = ((FileHandle)fHandle).getFileChannel();
            while (remaining > 0) {
                long len;
                FileChannel fileChannel2 = fileChannel;
                synchronized (fileChannel2) {
                    fileChannel.position(offset);
                    len = fileChannel.write(dataArray);
                }
                if (len < 0L) {
                    throw new HyracksDataException("Error writing to file: " + fHandle.getFileReference().toString());
                }
                remaining = (int)((long)remaining - len);
                offset += len;
                n = (int)((long)n + len);
            }
            return n;
        }
        catch (HyracksDataException e) {
            throw e;
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public int syncRead(IFileHandle fHandle, long offset, ByteBuffer data) throws HyracksDataException {
        IoRequest req = this.asyncRead(fHandle, offset, data);
        InvokeUtil.doUninterruptibly((InterruptibleAction)req);
        try {
            if (req.getState() == IoRequest.State.OPERATION_SUCCEEDED) {
                int n = req.getRead();
                return n;
            }
            if (req.getState() == IoRequest.State.OPERATION_FAILED) {
                throw req.getFailure();
            }
            throw new IllegalStateException("Reqd request completed with state " + (Object)((Object)req.getState()));
        }
        finally {
            req.recycle();
        }
    }

    public int doSyncRead(IFileHandle fHandle, long offset, ByteBuffer data) throws HyracksDataException {
        try {
            int n = 0;
            int remaining = data.remaining();
            while (remaining > 0) {
                int len = ((FileHandle)fHandle).getFileChannel().read(data, offset);
                if (len < 0) {
                    return n == 0 ? -1 : n;
                }
                remaining -= len;
                offset += (long)len;
                n += len;
            }
            return n;
        }
        catch (ClosedByInterruptException e) {
            Thread.currentThread().interrupt();
            ((FileHandle)fHandle).ensureOpen();
            throw HyracksDataException.create((Throwable)e);
        }
        catch (ClosedChannelException e) {
            throw HyracksDataException.create((int)94, (Throwable)e, (Serializable[])new Serializable[]{fHandle.getFileReference()});
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public IoRequest asyncWrite(IFileHandle fHandle, long offset, ByteBuffer[] dataArray) throws HyracksDataException {
        IoRequest req = this.getOrAllocRequest();
        try {
            req.write(fHandle, offset, dataArray);
        }
        catch (HyracksDataException e) {
            req.recycle();
            throw e;
        }
        return req;
    }

    public IoRequest asyncWrite(IFileHandle fHandle, long offset, ByteBuffer data) throws HyracksDataException {
        IoRequest req = this.getOrAllocRequest();
        try {
            req.write(fHandle, offset, data);
        }
        catch (HyracksDataException e) {
            req.recycle();
            throw e;
        }
        return req;
    }

    public IoRequest asyncRead(IFileHandle fHandle, long offset, ByteBuffer data) throws HyracksDataException {
        IoRequest req = this.getOrAllocRequest();
        try {
            req.read(fHandle, offset, data);
        }
        catch (HyracksDataException e) {
            req.recycle();
            throw e;
        }
        return req;
    }

    public void close(IFileHandle fHandle) throws HyracksDataException {
        try {
            ((FileHandle)fHandle).close();
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public synchronized FileReference createWorkspaceFile(String prefix) throws HyracksDataException {
        File waf;
        IODeviceHandle dev = this.workspaces.get(this.workspaceIndex);
        this.workspaceIndex = (this.workspaceIndex + 1) % this.workspaces.size();
        String waPath = dev.getWorkspace();
        try {
            waf = File.createTempFile(prefix, WORKSPACE_FILE_SUFFIX, new File(dev.getMount(), waPath));
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        return dev.createFileRef(waPath + File.separator + waf.getName());
    }

    public void sync(IFileHandle fileHandle, boolean metadata) throws HyracksDataException {
        try {
            ((FileHandle)fileHandle).getFileChannel().force(metadata);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public long getSize(IFileHandle fileHandle) {
        return fileHandle.getFileReference().getFile().length();
    }

    public void deleteWorkspaceFiles() throws HyracksDataException {
        for (IODeviceHandle ioDevice : this.workspaces) {
            File[] workspaceFiles;
            File workspaceFolder = new File(ioDevice.getMount(), ioDevice.getWorkspace());
            if (!workspaceFolder.exists() || !workspaceFolder.isDirectory()) continue;
            for (File workspaceFile : workspaceFiles = workspaceFolder.listFiles(WORKSPACE_FILES_FILTER)) {
                IoUtil.delete((File)workspaceFile);
            }
        }
    }

    public synchronized FileReference getFileReference(int ioDeviceId, String relativePath) {
        IODeviceHandle devHandle = this.ioDevices.get(ioDeviceId);
        return new FileReference(devHandle, relativePath);
    }

    public FileReference resolve(String path) throws HyracksDataException {
        return new FileReference(this.deviceComputer.resolve(path, this.getIODevices()), path);
    }

    public FileReference resolveAbsolutePath(String path) throws HyracksDataException {
        IODeviceHandle devHandle = this.getDevice(path);
        if (devHandle == null) {
            throw HyracksDataException.create((int)4, (Serializable[])new Serializable[]{path});
        }
        String relativePath = devHandle.getRelativePath(path);
        return new FileReference(devHandle, relativePath);
    }

    public IODeviceHandle getDevice(String fullPath) {
        Path full = Paths.get(fullPath, new String[0]);
        for (IODeviceHandle d : this.ioDevices) {
            if (!full.startsWith(Paths.get(d.getMount().getAbsolutePath(), new String[0]))) continue;
            return d;
        }
        return null;
    }

    public void close() throws IOException {
        InvokeUtil.doUninterruptibly(() -> this.submittedRequests.put(IoRequestHandler.POISON_PILL));
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                LOGGER.log(Level.WARN, "Failure shutting down {} executor service", (Object)this.getClass().getSimpleName());
            }
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARN, "Interrupted while shutting down {} executor service", (Object)this.getClass().getSimpleName());
            Thread.currentThread().interrupt();
        }
    }
}

