/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.active;

import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.common.transactions.ITxnIdFactory;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.job.DeployedJobSpecId;
import org.apache.hyracks.api.job.JobId;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeployedJobService {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final byte[] TRANSACTION_ID_PARAMETER_NAME = "TxnIdParameter".getBytes();
    private static final int POOL_SIZE = 1;

    public static ScheduledExecutorService startRepetitiveDeployedJobSpec(final DeployedJobSpecId distributedId, final IHyracksClientConnection hcc, final long duration, final Map<byte[], byte[]> jobParameters, final EntityId entityId, final ITxnIdFactory txnIdFactory) {
        final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!DeployedJobService.runRepetitiveDeployedJobSpec(distributedId, hcc, jobParameters, duration, entityId, txnIdFactory)) {
                        scheduledExecutorService.shutdown();
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.ERROR, "Job Failed to run for " + entityId.getExtensionName() + " " + entityId.getDataverse() + "." + entityId.getEntityName() + ".", (Throwable)e);
                }
            }
        }, duration, duration, TimeUnit.MILLISECONDS);
        return scheduledExecutorService;
    }

    public static boolean runRepetitiveDeployedJobSpec(DeployedJobSpecId distributedId, IHyracksClientConnection hcc, Map<byte[], byte[]> jobParameters, long duration, EntityId entityId, ITxnIdFactory txnIdFactory) throws Exception {
        long executionMilliseconds = DeployedJobService.runDeployedJobSpec(distributedId, hcc, jobParameters, entityId, txnIdFactory);
        if (executionMilliseconds > duration && LOGGER.isErrorEnabled()) {
            LOGGER.log(Level.ERROR, "Periodic job for " + entityId.getExtensionName() + " " + entityId.getDataverse() + "." + entityId.getEntityName() + " was unable to meet the required period of " + duration + " milliseconds. Actually took " + executionMilliseconds + " execution will shutdown" + new Date());
            return false;
        }
        return true;
    }

    public static synchronized long runDeployedJobSpec(DeployedJobSpecId distributedId, IHyracksClientConnection hcc, Map<byte[], byte[]> jobParameters, EntityId entityId, ITxnIdFactory txnIdFactory) throws Exception {
        long startTime = Instant.now().toEpochMilli();
        jobParameters.put(TRANSACTION_ID_PARAMETER_NAME, String.valueOf(txnIdFactory.create().getId()).getBytes());
        JobId jobId = hcc.startJob(distributedId, jobParameters);
        hcc.waitForCompletion(jobId);
        long executionMilliseconds = Instant.now().toEpochMilli() - startTime;
        LOGGER.log(Level.INFO, "Deployed Job execution completed for " + entityId.getExtensionName() + " " + entityId.getDataverse() + "." + entityId.getEntityName() + ". Took " + executionMilliseconds + " milliseconds ");
        return executionMilliseconds;
    }

    public String toString() {
        return "DeployedJobSpecService";
    }
}

