/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common.buffercache;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.common.IResourceMemoryManager;
import org.apache.hyracks.storage.common.buffercache.ICacheMemoryAllocator;

public class ResourceHeapBufferAllocator
implements ICacheMemoryAllocator {
    final IResourceMemoryManager memoryManager;
    final String resourceName;

    public ResourceHeapBufferAllocator(IResourceMemoryManager memoryManager, String resourceName) {
        this.memoryManager = memoryManager;
        this.resourceName = resourceName;
    }

    @Override
    public ByteBuffer[] allocate(int pageSize, int numPages) {
        ByteBuffer[] buffers = new ByteBuffer[numPages];
        for (int i = 0; i < numPages; ++i) {
            buffers[i] = ByteBuffer.allocate(pageSize);
        }
        return buffers;
    }

    @Override
    public ByteBuffer[] ensureAvailabilityThenAllocate(int pageSize, int numPages) throws HyracksDataException {
        this.reserveAllocation(pageSize, numPages);
        return this.allocate(pageSize, numPages);
    }

    @Override
    public void reserveAllocation(int pageSize, int numPages) throws HyracksDataException {
        this.memoryManager.allocateMemory(this.resourceName);
    }
}

