/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree.dataflow;

import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.btree.util.BTreeUtils;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexSearchOperatorNodePushable;
import org.apache.hyracks.storage.am.common.tuples.PermutingFrameTupleReference;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;

public class BTreeSearchOperatorNodePushable
extends IndexSearchOperatorNodePushable {
    protected final boolean lowKeyInclusive;
    protected final boolean highKeyInclusive;
    protected PermutingFrameTupleReference lowKey;
    protected PermutingFrameTupleReference highKey;
    protected MultiComparator lowKeySearchCmp;
    protected MultiComparator highKeySearchCmp;

    public BTreeSearchOperatorNodePushable(IHyracksTaskContext ctx, int partition, RecordDescriptor inputRecDesc, int[] lowKeyFields, int[] highKeyFields, boolean lowKeyInclusive, boolean highKeyInclusive, int[] minFilterFieldIndexes, int[] maxFilterFieldIndexes, IIndexDataflowHelperFactory indexHelperFactory, boolean retainInput, boolean retainMissing, IMissingWriterFactory missingWriterFactory, ISearchOperationCallbackFactory searchCallbackFactory, boolean appendIndexFilter) throws HyracksDataException {
        this(ctx, partition, inputRecDesc, lowKeyFields, highKeyFields, lowKeyInclusive, highKeyInclusive, minFilterFieldIndexes, maxFilterFieldIndexes, indexHelperFactory, retainInput, retainMissing, missingWriterFactory, searchCallbackFactory, appendIndexFilter, false, null, null);
    }

    public BTreeSearchOperatorNodePushable(IHyracksTaskContext ctx, int partition, RecordDescriptor inputRecDesc, int[] lowKeyFields, int[] highKeyFields, boolean lowKeyInclusive, boolean highKeyInclusive, int[] minFilterFieldIndexes, int[] maxFilterFieldIndexes, IIndexDataflowHelperFactory indexHelperFactory, boolean retainInput, boolean retainMissing, IMissingWriterFactory missingWriterFactory, ISearchOperationCallbackFactory searchCallbackFactory, boolean appendIndexFilter, boolean appendOpCallbackProceedResult, byte[] searchCallbackProceedResultFalseValue, byte[] searchCallbackProceedResultTrueValue) throws HyracksDataException {
        super(ctx, inputRecDesc, partition, minFilterFieldIndexes, maxFilterFieldIndexes, indexHelperFactory, retainInput, retainMissing, missingWriterFactory, searchCallbackFactory, appendIndexFilter, appendOpCallbackProceedResult, searchCallbackProceedResultFalseValue, searchCallbackProceedResultTrueValue);
        this.lowKeyInclusive = lowKeyInclusive;
        this.highKeyInclusive = highKeyInclusive;
        if (lowKeyFields != null && lowKeyFields.length > 0) {
            this.lowKey = new PermutingFrameTupleReference();
            this.lowKey.setFieldPermutation(lowKeyFields);
        }
        if (highKeyFields != null && highKeyFields.length > 0) {
            this.highKey = new PermutingFrameTupleReference();
            this.highKey.setFieldPermutation(highKeyFields);
        }
    }

    protected void resetSearchPredicate(int tupleIndex) {
        if (this.lowKey != null) {
            this.lowKey.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
        }
        if (this.highKey != null) {
            this.highKey.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
        }
        if (this.minFilterKey != null) {
            this.minFilterKey.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
        }
        if (this.maxFilterKey != null) {
            this.maxFilterKey.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
        }
    }

    protected ISearchPredicate createSearchPredicate() {
        ITreeIndex treeIndex = (ITreeIndex)this.index;
        this.lowKeySearchCmp = BTreeUtils.getSearchMultiComparator(treeIndex.getComparatorFactories(), (ITupleReference)this.lowKey);
        this.highKeySearchCmp = BTreeUtils.getSearchMultiComparator(treeIndex.getComparatorFactories(), (ITupleReference)this.highKey);
        return new RangePredicate((ITupleReference)this.lowKey, (ITupleReference)this.highKey, this.lowKeyInclusive, this.highKeyInclusive, this.lowKeySearchCmp, this.highKeySearchCmp, (ITupleReference)this.minFilterKey, (ITupleReference)this.maxFilterKey);
    }

    protected int getFieldCount() {
        return ((ITreeIndex)this.index).getFieldCount();
    }

    protected void addAdditionalIndexAccessorParams(IIndexAccessParameters iap) throws HyracksDataException {
    }
}

