/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.aql.visitor;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.aql.clause.DistinctClause;
import org.apache.asterix.lang.aql.clause.ForClause;
import org.apache.asterix.lang.aql.expression.FLWOGRExpression;
import org.apache.asterix.lang.aql.expression.UnionExpr;
import org.apache.asterix.lang.aql.util.AQLVariableSubstitutionUtil;
import org.apache.asterix.lang.aql.visitor.ClauseComparator;
import org.apache.asterix.lang.aql.visitor.base.IAQLVisitor;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.statement.DataverseDecl;
import org.apache.asterix.lang.common.statement.DeleteStatement;
import org.apache.asterix.lang.common.statement.InsertStatement;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.OperatorType;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.visitor.FormatPrintVisitor;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class AQLToSQLPPPrintVisitor
extends FormatPrintVisitor
implements IAQLVisitor<Void, Integer> {
    private final PrintWriter out;
    private final Set<String> reservedKeywords = new HashSet<String>();
    private int generatedId = 0;

    public AQLToSQLPPPrintVisitor() {
        this(new PrintWriter(System.out));
    }

    public AQLToSQLPPPrintVisitor(PrintWriter out) {
        super(out);
        this.out = out;
        this.initialize();
    }

    private void initialize() {
        this.dataverseSymbol = " database ";
        this.datasetSymbol = " table ";
        this.assignSymbol = "=";
        this.reservedKeywords.addAll(Arrays.asList("order", "value", "nest", "keyword", "all"));
    }

    @Override
    public Void visit(FLWOGRExpression flwor, Integer step) throws CompilationException {
        int size;
        if (step != 0) {
            this.out.println("(");
        }
        ArrayList<Clause> clauseList = new ArrayList<Clause>();
        clauseList.addAll(flwor.getClauseList());
        if (this.hasFor(clauseList)) {
            this.processLeadingLetClauses(step, clauseList);
        }
        this.distillRedundantOrderby(clauseList);
        Pair<GroupbyClause, List<Clause>> extraction = this.extractUnnestAfterGroupby(clauseList);
        GroupbyClause cuttingGbyClause = (GroupbyClause)extraction.first;
        ArrayList<Clause> unnestClauseList = (ArrayList<Clause>)extraction.second;
        Expression returnExpr = flwor.getReturnExpr();
        if (unnestClauseList.size() == 0) {
            if (this.hasFor(clauseList)) {
                this.out.print(this.skip(step) + "select element ");
                returnExpr.accept((ILangVisitor)this, (Object)(step + 2));
                this.out.println();
            } else {
                Map<VariableExpr, Expression> varExprMap = this.extractLetBindingVariables(clauseList, cuttingGbyClause);
                returnExpr = (Expression)AQLVariableSubstitutionUtil.substituteVariable((ILangExpression)returnExpr, varExprMap);
                returnExpr.accept((ILangVisitor)this, (Object)step);
                return null;
            }
        }
        String generated = this.generateVariableSymbol();
        if (unnestClauseList.size() > 0) {
            Map<VariableExpr, Expression> varExprMap = this.extractDefinedCollectionVariables(clauseList, cuttingGbyClause, generated);
            returnExpr = (Expression)AQLVariableSubstitutionUtil.substituteVariable((ILangExpression)returnExpr, varExprMap);
            ArrayList<Clause> newUnnestClauses = new ArrayList<Clause>();
            for (Clause nestedCl : unnestClauseList) {
                newUnnestClauses.add((Clause)AQLVariableSubstitutionUtil.substituteVariable((ILangExpression)nestedCl, varExprMap));
            }
            unnestClauseList = newUnnestClauses;
            this.out.print(this.skip(step) + "select element " + (this.hasDistinct(unnestClauseList) ? "distinct " : ""));
            returnExpr.accept((ILangVisitor)this, (Object)(step + 2));
            this.out.println();
            this.out.println(this.skip(step) + "from");
            this.out.print(this.skip(step + 2) + "( select element " + (this.hasDistinct(clauseList) ? "distinct " : "") + "{");
            int index = 0;
            size = varExprMap.size();
            for (VariableExpr var : varExprMap.keySet()) {
                this.out.print("'" + var.getVar().getValue().substring(1) + "':" + var.getVar().getValue().substring(1));
                if (++index >= size) continue;
                this.out.print(",");
            }
            this.out.println("}");
        }
        this.reorder(clauseList);
        this.reorder((List<Clause>)unnestClauseList);
        this.mergeConsecutiveWhereClauses(clauseList);
        this.mergeConsecutiveWhereClauses((List<Clause>)unnestClauseList);
        boolean firstFor = true;
        boolean firstLet = true;
        int forStep = unnestClauseList.size() == 0 ? step : step + 3;
        size = clauseList.size();
        for (int i = 0; i < size; ++i) {
            Clause nextCl;
            Clause cl = (Clause)clauseList.get(i);
            if (cl.getClauseType() == Clause.ClauseType.FOR_CLAUSE) {
                boolean hasConsequentFor = false;
                if (i < size - 1) {
                    nextCl = (Clause)clauseList.get(i + 1);
                    hasConsequentFor = nextCl.getClauseType() == Clause.ClauseType.FOR_CLAUSE;
                }
                this.visitForClause((ForClause)cl, forStep, firstFor, hasConsequentFor);
                firstFor = false;
            } else if (cl.getClauseType() == Clause.ClauseType.LET_CLAUSE) {
                boolean hasConsequentLet = false;
                if (i < size - 1) {
                    nextCl = (Clause)clauseList.get(i + 1);
                    hasConsequentLet = nextCl.getClauseType() == Clause.ClauseType.LET_CLAUSE;
                }
                this.visitLetClause((LetClause)cl, forStep, firstLet, hasConsequentLet);
                firstLet = false;
            } else {
                cl.accept((ILangVisitor)this, (Object)forStep);
            }
            if (cl.getClauseType() != Clause.ClauseType.FROM_CLAUSE && cl.getClauseType() != Clause.ClauseType.GROUP_BY_CLAUSE) continue;
            firstLet = true;
        }
        if (unnestClauseList.size() > 0) {
            this.out.println(this.skip(forStep - 1) + ") as " + generated.substring(1) + ",");
            for (Clause nestedCl : unnestClauseList) {
                if (nestedCl.getClauseType() == Clause.ClauseType.FOR_CLAUSE) {
                    this.visitForClause((ForClause)nestedCl, step - 1, firstFor, false);
                    continue;
                }
                nestedCl.accept((ILangVisitor)this, (Object)step);
            }
        }
        if (step > 0) {
            this.out.print(this.skip(step - 2) + ")");
        }
        return null;
    }

    @Override
    public Void visit(ForClause fc, Integer step) throws CompilationException {
        return null;
    }

    private void visitForClause(ForClause fc, Integer step, boolean startFor, boolean hasConsequentFor) throws CompilationException {
        if (startFor) {
            this.out.print(this.skip(step) + "from  ");
        } else {
            this.out.print(this.skip(step + 3));
        }
        fc.getInExpr().accept((ILangVisitor)this, (Object)(step + 2));
        this.out.print(" as ");
        fc.getVarExpr().accept((ILangVisitor)this, (Object)(step + 2));
        if (fc.hasPosVar()) {
            this.out.print(" at ");
            fc.getPosVarExpr().accept((ILangVisitor)this, (Object)(step + 2));
        }
        if (hasConsequentFor) {
            this.out.print(",");
        }
        this.out.println();
    }

    private void visitLetClause(LetClause lc, Integer step, boolean startLet, boolean hasConsequentLet) throws CompilationException {
        if (startLet) {
            this.out.print(this.skip(step) + "with  ");
        } else {
            this.out.print(this.skip(step + 3));
        }
        lc.getVarExpr().accept((ILangVisitor)this, (Object)(step + 3));
        this.out.print(" as ");
        lc.getBindingExpr().accept((ILangVisitor)this, (Object)(step + 3));
        if (hasConsequentLet) {
            this.out.print(",");
        }
        this.out.println();
    }

    public Void visit(Query q, Integer step) throws CompilationException {
        Expression expr = q.getBody();
        if (expr != null) {
            if (expr.getKind() != Expression.Kind.FLWOGR_EXPRESSION) {
                this.out.print("select element ");
                expr.accept((ILangVisitor)this, (Object)(step + 2));
            } else {
                expr.accept((ILangVisitor)this, (Object)step);
            }
        }
        if (q.isTopLevel()) {
            this.out.println(";");
        }
        return null;
    }

    public Void visit(DataverseDecl dv, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + "use " + this.normalize(dv.getDataverseName().getValue()) + ";\n\n");
        return null;
    }

    @Override
    public Void visit(UnionExpr u, Integer step) throws CompilationException {
        this.printDelimitedExpressions(u.getExprs(), "\n" + this.skip(step) + "union\n" + this.skip(step), step);
        return null;
    }

    @Override
    public Void visit(DistinctClause dc, Integer step) throws CompilationException {
        return null;
    }

    public Void visit(VariableExpr v, Integer step) {
        String varStr = v.getVar().getValue().substring(1);
        if (this.reservedKeywords.contains(varStr)) {
            varStr = varStr + "s";
        }
        this.out.print(varStr);
        return null;
    }

    public Void visit(LetClause lc, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "with ");
        lc.getVarExpr().accept((ILangVisitor)this, (Object)(step + 2));
        this.out.print(" as ");
        Expression bindingExpr = lc.getBindingExpr();
        bindingExpr.accept((ILangVisitor)this, (Object)(step + 2));
        this.out.println();
        return null;
    }

    public Void visit(CallExpr callExpr, Integer step) throws CompilationException {
        FunctionSignature signature = callExpr.getFunctionSignature();
        if (signature.getNamespace() != null && signature.getNamespace().equals("Metadata") && signature.getName().equals("dataset") && signature.getArity() == 1) {
            LiteralExpr expr = (LiteralExpr)callExpr.getExprList().get(0);
            this.out.print(this.normalize(expr.getValue().getStringValue()));
        } else {
            this.printHints(callExpr.getHints(), step);
            this.out.print(this.generateFullName(callExpr.getFunctionSignature().getNamespace(), callExpr.getFunctionSignature().getName()) + "(");
            this.printDelimitedExpressions(callExpr.getExprList(), ",", step);
            this.out.print(")");
        }
        return null;
    }

    public Void visit(GroupbyClause gc, Integer step) throws CompilationException {
        if (gc.hasHashGroupByHint()) {
            this.out.println(this.skip(step) + "/* +hash */");
        }
        this.out.print(this.skip(step) + "group by ");
        this.printDelimitedGbyExpressions(gc.getGbyPairList(), step + 2);
        this.out.println();
        return null;
    }

    public Void visit(InsertStatement insert, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "insert into " + this.generateFullName(insert.getDataverseName(), insert.getDatasetName()) + "\n");
        insert.getQuery().accept((ILangVisitor)this, (Object)step);
        this.out.println(";");
        return null;
    }

    public Void visit(DeleteStatement del, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "delete ");
        del.getVariableExpr().accept((ILangVisitor)this, (Object)(step + 2));
        this.out.println(this.skip(step) + " from " + this.generateFullName(del.getDataverseName(), del.getDatasetName()));
        if (del.getCondition() != null) {
            this.out.print(this.skip(step) + " where ");
            del.getCondition().accept((ILangVisitor)this, (Object)(step + 2));
        }
        this.out.println(";");
        return null;
    }

    protected String normalize(String str) {
        if (this.needQuotes(str) || this.containsReservedKeyWord(str.toLowerCase())) {
            return this.revertStringToQuoted(str);
        }
        return str;
    }

    protected boolean containsReservedKeyWord(String str) {
        return this.reservedKeywords.contains(str);
    }

    protected void printDelimitedGbyExpressions(List<GbyVariableExpressionPair> gbyList, int step) throws CompilationException {
        int gbySize = gbyList.size();
        int gbyIndex = 0;
        for (GbyVariableExpressionPair pair : gbyList) {
            pair.getExpr().accept((ILangVisitor)this, (Object)step);
            if (pair.getVar() != null) {
                this.out.print(" as ");
                pair.getVar().accept((ILangVisitor)this, (Object)step);
            }
            if (++gbyIndex >= gbySize) continue;
            this.out.print(",");
        }
    }

    protected void printDelimitedIdentifiers(List<Identifier> ids, String delimiter) {
        int index = 0;
        int size = ids.size();
        for (Identifier id : ids) {
            String idStr = id.getValue();
            if (idStr.startsWith("$")) {
                id = new Identifier(idStr.substring(1));
            }
            this.out.print(id);
            if (++index >= size) continue;
            this.out.print(delimiter);
        }
    }

    private List<VariableExpr> collectProducedVariablesFromGroupby(GroupbyClause gbyClause) {
        ArrayList<VariableExpr> producedVars = new ArrayList<VariableExpr>();
        for (GbyVariableExpressionPair keyPair : gbyClause.getGbyPairList()) {
            producedVars.add(keyPair.getVar());
        }
        for (GbyVariableExpressionPair keyPair : gbyClause.getDecorPairList()) {
            producedVars.add(keyPair.getVar());
        }
        producedVars.addAll(gbyClause.getWithVarMap().values());
        return producedVars;
    }

    private String generateVariableSymbol() {
        return "$gen" + this.generatedId++;
    }

    private void distillRedundantOrderby(List<Clause> clauseList) {
        ArrayList<Clause> redundantOrderbys = new ArrayList<Clause>();
        boolean gbyAfterOrderby = false;
        for (Clause cl : clauseList) {
            if (cl.getClauseType() == Clause.ClauseType.ORDER_BY_CLAUSE) {
                redundantOrderbys.add(cl);
            }
            if (cl.getClauseType() != Clause.ClauseType.GROUP_BY_CLAUSE) continue;
            gbyAfterOrderby = true;
            break;
        }
        if (gbyAfterOrderby) {
            clauseList.removeAll(redundantOrderbys);
        }
        redundantOrderbys.clear();
        for (Clause cl : clauseList) {
            if (cl.getClauseType() != Clause.ClauseType.ORDER_BY_CLAUSE) continue;
            redundantOrderbys.add(cl);
        }
        if (redundantOrderbys.size() > 0) {
            redundantOrderbys.remove(redundantOrderbys.size() - 1);
        }
        clauseList.removeAll(redundantOrderbys);
    }

    private void processLeadingLetClauses(Integer step, List<Clause> clauseList) throws CompilationException {
        Clause cl;
        ArrayList<Clause> processedLetList = new ArrayList<Clause>();
        boolean firstLet = true;
        int size = clauseList.size();
        for (int i = 0; i < size && (cl = clauseList.get(i)).getClauseType() == Clause.ClauseType.LET_CLAUSE; ++i) {
            boolean hasConsequentLet = false;
            if (i < size - 1) {
                Clause nextCl = clauseList.get(i + 1);
                hasConsequentLet = nextCl.getClauseType() == Clause.ClauseType.LET_CLAUSE;
            }
            this.visitLetClause((LetClause)cl, step, firstLet, hasConsequentLet);
            firstLet = false;
            processedLetList.add(cl);
        }
        clauseList.removeAll(processedLetList);
    }

    private Pair<GroupbyClause, List<Clause>> extractUnnestAfterGroupby(List<Clause> clauseList) throws CompilationException {
        ArrayList<Clause> nestedClauses = new ArrayList<Clause>();
        GroupbyClause cuttingGbyClause = null;
        boolean meetGroupBy = false;
        boolean nestedClauseStarted = false;
        for (Clause cl : clauseList) {
            if (cl.getClauseType() == Clause.ClauseType.GROUP_BY_CLAUSE) {
                meetGroupBy = true;
                cuttingGbyClause = (GroupbyClause)cl;
                continue;
            }
            if (meetGroupBy && cl.getClauseType() == Clause.ClauseType.FOR_CLAUSE) {
                nestedClauseStarted = true;
            }
            if (!nestedClauseStarted) continue;
            nestedClauses.add(cl);
        }
        clauseList.removeAll(nestedClauses);
        return new Pair(cuttingGbyClause, nestedClauses);
    }

    private Map<VariableExpr, Expression> extractDefinedCollectionVariables(List<Clause> clauses, GroupbyClause cuttingGbyClause, String generatedAlias) {
        HashMap<VariableExpr, Expression> varExprMap = new HashMap<VariableExpr, Expression>();
        List<VariableExpr> varToSubstitute = this.collectProducedVariablesFromGroupby(cuttingGbyClause);
        int gbyIndex = clauses.indexOf(cuttingGbyClause);
        for (int i = gbyIndex + 1; i < clauses.size(); ++i) {
            Clause cl = clauses.get(i);
            if (cl.getClauseType() != Clause.ClauseType.LET_CLAUSE) continue;
            varToSubstitute.add(((LetClause)cl).getVarExpr());
        }
        for (VariableExpr var : varToSubstitute) {
            varExprMap.put(var, (Expression)new FieldAccessor((Expression)new VariableExpr(new VarIdentifier(generatedAlias)), (Identifier)new VarIdentifier(var.getVar().getValue().substring(1))));
        }
        return varExprMap;
    }

    private Map<VariableExpr, Expression> extractLetBindingVariables(List<Clause> clauses, GroupbyClause cuttingGbyClause) throws CompilationException {
        HashMap<VariableExpr, Expression> varExprMap = new HashMap<VariableExpr, Expression>();
        int gbyIndex = clauses.indexOf(cuttingGbyClause);
        for (int i = gbyIndex + 1; i < clauses.size(); ++i) {
            Clause cl = clauses.get(i);
            if (cl.getClauseType() != Clause.ClauseType.LET_CLAUSE) continue;
            LetClause letClause = (LetClause)cl;
            letClause.setBindingExpr((Expression)AQLVariableSubstitutionUtil.substituteVariable((ILangExpression)letClause.getBindingExpr(), varExprMap));
            varExprMap.put(letClause.getVarExpr(), letClause.getBindingExpr());
        }
        return varExprMap;
    }

    private List<Clause> reorder(List<Clause> clauses) {
        ClauseComparator comparator = new ClauseComparator();
        ArrayList<Clause> results = new ArrayList<Clause>();
        int size = clauses.size();
        int start = 0;
        for (int index = 0; index < size; ++index) {
            Clause clause = clauses.get(index);
            if (clause.getClauseType() != Clause.ClauseType.GROUP_BY_CLAUSE) continue;
            List<Clause> subList = clauses.subList(start, index);
            Collections.sort(subList, comparator);
            results.addAll(subList);
            results.add(clause);
            start = index + 1;
        }
        if (start < clauses.size()) {
            List<Clause> subList = clauses.subList(start, size);
            Collections.sort(subList, comparator);
            results.addAll(subList);
        }
        return results;
    }

    private void mergeConsecutiveWhereClauses(List<Clause> clauses) throws CompilationException {
        ArrayList<Object> results = new ArrayList<Object>();
        int size = clauses.size();
        int index = 0;
        while (index < size) {
            Clause clause = clauses.get(index);
            if (clause.getClauseType() != Clause.ClauseType.WHERE_CLAUSE) {
                results.add(clause);
                ++index;
                continue;
            }
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            Clause firstWhereClause = clause;
            do {
                WhereClause whereClause = (WhereClause)clause;
                expressions.add(whereClause.getWhereExpr());
            } while (++index < size && (clause = clauses.get(index)).getClauseType() == Clause.ClauseType.WHERE_CLAUSE);
            if (expressions.size() > 1) {
                OperatorExpr newWhereExpr = new OperatorExpr();
                newWhereExpr.setExprList(expressions);
                newWhereExpr.setCurrentop(true);
                for (int operatorIndex = 0; operatorIndex < expressions.size(); ++operatorIndex) {
                    newWhereExpr.addOperator(OperatorType.AND);
                }
                results.add(new WhereClause((Expression)newWhereExpr));
                continue;
            }
            results.add(firstWhereClause);
        }
        clauses.clear();
        clauses.addAll(results);
    }

    protected boolean hasDistinct(List<Clause> clauses) {
        for (Clause clause : clauses) {
            if (clause.getClauseType() != Clause.ClauseType.DISTINCT_BY_CLAUSE) continue;
            return true;
        }
        return false;
    }

    private boolean hasFor(List<Clause> clauses) {
        for (Clause cl : clauses) {
            if (cl.getClauseType() != Clause.ClauseType.FOR_CLAUSE) continue;
            return true;
        }
        return false;
    }
}

