/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.utils;

import java.util.List;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.commons.lang3.StringUtils;

public class RecordUtil {
    public static final ARecordType FULLY_OPEN_RECORD_TYPE = new ARecordType("AnyObject", new String[0], new IAType[0], true);

    private RecordUtil() {
    }

    public static ARecordType createOpenRecordType(String name) {
        return new ARecordType(name, new String[0], new IAType[0], true);
    }

    public static String toFullyQualifiedName(List<String> field) {
        return StringUtils.join(field, (String)".");
    }

    public static String toFullyQualifiedName(String ... names) {
        return StringUtils.join((Object[])names, (String)".");
    }

    public static int computeNullBitmapSize(ARecordType recordType) {
        return NonTaggedFormatUtil.hasOptionalField(recordType) ? (int)Math.ceil((double)recordType.getFieldNames().length / 4.0) : 0;
    }
}

