/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.object.base;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.object.base.AdmNullNode;
import org.apache.asterix.object.base.IAdmNode;
import org.apache.asterix.om.types.ATypeTag;

public class AdmObjectNode
implements IAdmNode {
    private final Map<String, IAdmNode> children = new HashMap<String, IAdmNode>();

    @Override
    public ATypeTag getType() {
        return ATypeTag.OBJECT;
    }

    public int size() {
        return this.children.size();
    }

    public IAdmNode get(String fieldName) {
        return this.children.get(fieldName);
    }

    public Set<String> getFieldNames() {
        return this.children.keySet();
    }

    public Set<Map.Entry<String, IAdmNode>> getFields() {
        return this.children.entrySet();
    }

    public AdmObjectNode set(String fieldName, IAdmNode value) {
        if (value == null) {
            value = AdmNullNode.INSTANCE;
        }
        this.children.put(fieldName, value);
        return this;
    }

    public IAdmNode remove(String fieldName) {
        return this.children.remove(fieldName);
    }

    @Override
    public void reset() {
        this.children.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int count = 0;
        for (Map.Entry<String, IAdmNode> en : this.children.entrySet()) {
            if (count > 0) {
                sb.append(",");
            }
            ++count;
            sb.append('\"');
            sb.append(en.getKey());
            sb.append('\"');
            sb.append(':');
            sb.append(en.getValue().toString());
        }
        sb.append("}");
        return sb.toString();
    }
}

