/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.object.base;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.object.base.AdmBooleanNode;
import org.apache.asterix.object.base.AdmNullNode;
import org.apache.asterix.object.base.IAdmNode;
import org.apache.asterix.om.types.ATypeTag;

public class AdmArrayNode
implements IAdmNode {
    private final List<IAdmNode> children;

    public AdmArrayNode() {
        this.children = new ArrayList<IAdmNode>();
    }

    public AdmArrayNode(int initialCapacity) {
        this.children = new ArrayList<IAdmNode>(initialCapacity);
    }

    public IAdmNode set(int index, boolean value) {
        return this.set(index, AdmBooleanNode.get(value));
    }

    public void add(boolean value) {
        this.add(AdmBooleanNode.get(value));
    }

    public void add(IAdmNode value) {
        if (value == null) {
            value = AdmNullNode.INSTANCE;
        }
        this.children.add(value);
    }

    public IAdmNode set(int index, IAdmNode value) {
        if (value == null) {
            value = AdmNullNode.INSTANCE;
        }
        return this.children.set(index, value);
    }

    public IAdmNode get(int index) {
        return this.children.get(index);
    }

    @Override
    public ATypeTag getType() {
        return ATypeTag.ARRAY;
    }

    @Override
    public void reset() {
        this.children.clear();
    }

    public String toString() {
        return this.children.toString();
    }
}

