/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.formats.nontagged;

import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.hyracks.algebricks.data.IBinaryBooleanInspector;
import org.apache.hyracks.algebricks.data.IBinaryBooleanInspectorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;

public class BinaryBooleanInspector
implements IBinaryBooleanInspector {
    private static final BinaryBooleanInspector INSTANCE = new BinaryBooleanInspector();
    public static final IBinaryBooleanInspectorFactory FACTORY = new IBinaryBooleanInspectorFactory(){
        private static final long serialVersionUID = 1L;

        public IBinaryBooleanInspector createBinaryBooleanInspector(IHyracksTaskContext ctx) {
            return INSTANCE;
        }
    };

    private BinaryBooleanInspector() {
    }

    public boolean getBooleanValue(byte[] bytes, int offset, int length) {
        byte serializedTypeTag = bytes[offset];
        if (serializedTypeTag == ATypeTag.SERIALIZED_MISSING_TYPE_TAG || serializedTypeTag == ATypeTag.SERIALIZED_NULL_TYPE_TAG) {
            return false;
        }
        ATypeTag typeTag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(serializedTypeTag);
        if (typeTag != ATypeTag.BOOLEAN) {
            throw new IllegalStateException("Runtime error: the select condition should be of the boolean type!");
        }
        return bytes[offset + 1] == 1;
    }
}

