/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.hash;

import java.io.IOException;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunctionFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.accessors.MurmurHash3BinaryHashFunctionFamily;
import org.apache.hyracks.data.std.accessors.PointableBinaryHashFunctionFactory;
import org.apache.hyracks.data.std.primitive.UTF8StringLowercasePointable;
import org.apache.hyracks.data.std.util.GrowableArray;

public class ListItemBinaryHashFunctionFactory
implements IBinaryHashFunctionFactory {
    private static final long serialVersionUID = 1L;
    public static final ListItemBinaryHashFunctionFactory INSTANCE = new ListItemBinaryHashFunctionFactory();

    private ListItemBinaryHashFunctionFactory() {
    }

    public IBinaryHashFunction createBinaryHashFunction() {
        return this.createBinaryHashFunction(ATypeTag.ANY, false);
    }

    public IBinaryHashFunction createBinaryHashFunction(final ATypeTag itemTypeTag, final boolean ignoreCase) {
        return new IBinaryHashFunction(){
            private IBinaryHashFunction lowerCaseStringHash = new PointableBinaryHashFunctionFactory(UTF8StringLowercasePointable.FACTORY).createBinaryHashFunction();
            private IBinaryHashFunction genericBinaryHash = MurmurHash3BinaryHashFunctionFamily.INSTANCE.createBinaryHashFunction(0);
            private GrowableArray taggedBytes = new GrowableArray();

            public int hash(byte[] bytes, int offset, int length) throws HyracksDataException {
                ATypeTag tag = itemTypeTag;
                int skip = 0;
                if (itemTypeTag == ATypeTag.ANY) {
                    tag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[offset]);
                    skip = 1;
                }
                switch (tag) {
                    case STRING: {
                        if (!ignoreCase) break;
                        return this.lowerCaseStringHash.hash(bytes, offset + skip, length - skip);
                    }
                }
                if (itemTypeTag != ATypeTag.ANY) {
                    try {
                        this.resetTaggedBytes(bytes, offset, length);
                        return this.genericBinaryHash.hash(this.taggedBytes.getByteArray(), 0, length + 1);
                    }
                    catch (IOException e) {
                        throw HyracksDataException.create((Throwable)e);
                    }
                }
                return this.genericBinaryHash.hash(bytes, offset, length);
            }

            private void resetTaggedBytes(byte[] data, int offset, int length) throws IOException {
                this.taggedBytes.reset();
                this.taggedBytes.getDataOutput().writeByte(itemTypeTag.serialize());
                this.taggedBytes.getDataOutput().write(data, offset, length);
            }
        };
    }
}

