/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.common;

import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IPartialAggregationTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;

public class PartialAggregationTypeComputer
implements IPartialAggregationTypeComputer {
    public Object getType(ILogicalExpression expr, IVariableTypeEnvironment env, IMetadataProvider<?, ?> metadataProvider) throws AlgebricksException {
        AggregateFunctionCallExpression agg = (AggregateFunctionCallExpression)expr;
        FunctionIdentifier partialFid = agg.getFunctionIdentifier();
        if (partialFid.equals((Object)BuiltinFunctions.SERIAL_GLOBAL_AVG)) {
            partialFid = BuiltinFunctions.SERIAL_LOCAL_AVG;
        }
        AggregateFunctionCallExpression partialAgg = BuiltinFunctions.makeAggregateFunctionExpression(partialFid, agg.getArguments());
        return this.getTypeForFunction((AbstractFunctionCallExpression)partialAgg, env, metadataProvider);
    }

    private Object getTypeForFunction(AbstractFunctionCallExpression expr, IVariableTypeEnvironment env, IMetadataProvider<?, ?> metadataProvider) throws AlgebricksException {
        return BuiltinFunctions.getResultTypeComputer(expr.getFunctionIdentifier()).computeType((ILogicalExpression)expr, env, metadataProvider);
    }
}

