/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import org.apache.hyracks.api.dataflow.IDestroyable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.BooleanPointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeCursorInitialState;
import org.apache.hyracks.storage.am.lsm.btree.tuples.LSMBTreeTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexSearchCursor;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.util.IndexCursorUtils;

public class LSMBTreeDiskComponentScanCursor
extends LSMIndexSearchCursor {
    private static final IValueReference MATTER_TUPLE_FLAG = BooleanPointable.FACTORY.createPointable(false);
    private static final IValueReference ANTIMATTER_TUPLE_FLAG = BooleanPointable.FACTORY.createPointable(true);
    private BTree.BTreeAccessor[] btreeAccessors;
    private ArrayTupleBuilder tupleBuilder;
    private ArrayTupleBuilder antiMatterTupleBuilder;
    private final ArrayTupleReference outputTuple = new ArrayTupleReference();
    private PermutingTupleReference originalTuple;
    private boolean foundNext;
    private IntegerPointable cursorIndexPointable;

    public LSMBTreeDiskComponentScanCursor(ILSMIndexOperationContext opCtx) {
        super(opCtx, true);
    }

    public void doOpen(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        LSMBTreeCursorInitialState lsmInitialState = (LSMBTreeCursorInitialState)initialState;
        this.cmp = lsmInitialState.getOriginalKeyComparator();
        this.operationalComponents = lsmInitialState.getOperationalComponents();
        this.lsmHarness = lsmInitialState.getLSMHarness();
        this.includeMutableComponent = false;
        int numBTrees = this.operationalComponents.size();
        this.rangeCursors = new IIndexCursor[numBTrees];
        this.btreeAccessors = new BTree.BTreeAccessor[numBTrees];
        for (int i = 0; i < numBTrees; ++i) {
            ILSMComponent component = (ILSMComponent)this.operationalComponents.get(i);
            BTree btree = (BTree)component.getIndex();
            this.btreeAccessors[i] = btree.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
            this.rangeCursors[i] = this.btreeAccessors[i].createSearchCursor(false);
        }
        IndexCursorUtils.open((IIndexAccessor[])this.btreeAccessors, (IIndexCursor[])this.rangeCursors, (ISearchPredicate)searchPred);
        try {
            this.cursorIndexPointable = new IntegerPointable();
            int length = IntegerPointable.TYPE_TRAITS.getFixedLength();
            this.cursorIndexPointable.set(new byte[length], 0, length);
            this.setPriorityQueueComparator();
            this.initPriorityQueue();
        }
        catch (Throwable th) {
            for (int i = 0; i < numBTrees; ++i) {
                IndexCursorUtils.close((IIndexCursor)this.rangeCursors[i], (Throwable)th);
            }
            throw HyracksDataException.create((Throwable)th);
        }
    }

    public void doNext() throws HyracksDataException {
        this.foundNext = false;
    }

    public boolean doHasNext() throws HyracksDataException {
        if (this.foundNext) {
            return true;
        }
        while (super.doHasNext()) {
            super.doNext();
            LSMBTreeTupleReference diskTuple = (LSMBTreeTupleReference)super.doGetTuple();
            if (diskTuple.isAntimatter()) {
                if (!this.setAntiMatterTuple((ITupleReference)diskTuple, this.outputElement.getCursorIndex())) continue;
                this.foundNext = true;
                return true;
            }
            this.setMatterTuple((ITupleReference)diskTuple, this.outputElement.getCursorIndex());
            this.foundNext = true;
            return true;
        }
        return false;
    }

    protected int compare(MultiComparator cmp, ITupleReference tupleA, ITupleReference tupleB) throws HyracksDataException {
        return -1;
    }

    private void setMatterTuple(ITupleReference diskTuple, int cursorIndex) throws HyracksDataException {
        if (this.tupleBuilder == null) {
            this.tupleBuilder = new ArrayTupleBuilder(diskTuple.getFieldCount() + 2);
            this.antiMatterTupleBuilder = new ArrayTupleBuilder(diskTuple.getFieldCount() + 2);
            int[] permutation = new int[diskTuple.getFieldCount()];
            for (int i = 0; i < permutation.length; ++i) {
                permutation[i] = i + 2;
            }
            this.originalTuple = new PermutingTupleReference(permutation);
        }
        this.buildTuple(this.tupleBuilder, diskTuple, cursorIndex, MATTER_TUPLE_FLAG);
        this.outputTuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        this.originalTuple.reset((ITupleReference)this.outputTuple);
    }

    private boolean setAntiMatterTuple(ITupleReference diskTuple, int cursorIndex) throws HyracksDataException {
        if (this.originalTuple == null || this.cmp.compare(diskTuple, (ITupleReference)this.originalTuple) != 0) {
            return false;
        }
        this.buildTuple(this.antiMatterTupleBuilder, (ITupleReference)this.originalTuple, cursorIndex, ANTIMATTER_TUPLE_FLAG);
        this.outputTuple.reset(this.antiMatterTupleBuilder.getFieldEndOffsets(), this.antiMatterTupleBuilder.getByteArray());
        return true;
    }

    private void buildTuple(ArrayTupleBuilder builder, ITupleReference diskTuple, int cursorIndex, IValueReference tupleFlag) throws HyracksDataException {
        builder.reset();
        this.cursorIndexPointable.setInteger(cursorIndex);
        builder.addField((IValueReference)this.cursorIndexPointable);
        builder.addField(tupleFlag);
        for (int i = 0; i < diskTuple.getFieldCount(); ++i) {
            builder.addField(diskTuple.getFieldData(i), diskTuple.getFieldStart(i), diskTuple.getFieldLength(i));
        }
    }

    public ITupleReference doGetTuple() {
        return this.outputTuple;
    }

    public void doDestroy() throws HyracksDataException {
        Throwable failure = null;
        if (this.lsmHarness != null) {
            if (this.rangeCursors != null) {
                failure = CleanupUtils.destroy(failure, (IDestroyable[])this.rangeCursors);
                this.rangeCursors = null;
            }
            try {
                this.lsmHarness.endScanDiskComponents(this.opCtx);
            }
            catch (Throwable th) {
                failure = ExceptionUtils.suppress((Throwable)failure, (Throwable)th);
            }
        }
        this.foundNext = false;
        if (failure != null) {
            throw HyracksDataException.create(failure);
        }
    }

    protected void setPriorityQueueComparator() {
        if (this.pqCmp == null || this.cmp != this.pqCmp.getMultiComparator()) {
            this.pqCmp = new PriorityQueueScanComparator(this.cmp);
        }
    }

    private class PriorityQueueScanComparator
    extends LSMIndexSearchCursor.PriorityQueueComparator {
        public PriorityQueueScanComparator(MultiComparator cmp) {
            super((LSMIndexSearchCursor)LSMBTreeDiskComponentScanCursor.this, cmp);
        }

        public int compare(LSMIndexSearchCursor.PriorityQueueElement elementA, LSMIndexSearchCursor.PriorityQueueElement elementB) {
            try {
                int result = this.cmp.compare(elementA.getTuple(), elementB.getTuple());
                if (result != 0) {
                    return result;
                }
            }
            catch (HyracksDataException e) {
                throw new IllegalArgumentException(e);
            }
            return elementA.getCursorIndex() > elementB.getCursorIndex() ? -1 : 1;
        }
    }
}

