/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.api.ITwoPCIndexBulkLoader;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.btree.impls.ExternalBTreeWithBuddyOpContext;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyDiskComponent;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyMergeOperation;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddySearchCursor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddySortedCursor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBuddyBTreeMergeCursor;
import org.apache.hyracks.storage.am.lsm.common.api.AbstractLSMWithBloomFilterDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.ITwoPCIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.ChainedLSMDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.impls.ExternalIndexHarness;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMTreeIndexAccessor;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.util.trace.ITracer;

public class ExternalBTreeWithBuddy
extends AbstractLSMIndex
implements ITreeIndex,
ITwoPCIndex {
    private final IBinaryComparatorFactory[] btreeCmpFactories;
    private final IBinaryComparatorFactory[] buddyBtreeCmpFactories;
    private final int[] buddyBTreeFields;
    private final ITreeIndexFrameFactory btreeInteriorFrameFactory;
    private final ITreeIndexFrameFactory btreeLeafFrameFactory;
    private final ITreeIndexFrameFactory buddyBtreeLeafFrameFactory;
    private final List<ILSMDiskComponent> secondDiskComponents;
    private int version = 0;

    public ExternalBTreeWithBuddy(IIOManager ioManager, ITreeIndexFrameFactory btreeInteriorFrameFactory, ITreeIndexFrameFactory btreeLeafFrameFactory, ITreeIndexFrameFactory buddyBtreeLeafFrameFactory, IBufferCache diskBufferCache, ILSMIndexFileManager fileManager, ILSMDiskComponentFactory componentFactory, ILSMDiskComponentFactory bulkLoadComponentFactory, double bloomFilterFalsePositiveRate, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallbackFactory ioOpCallbackFactory, IBinaryComparatorFactory[] btreeCmpFactories, IBinaryComparatorFactory[] buddyBtreeCmpFactories, int[] buddyBTreeFields, boolean durable, ITracer tracer) throws HyracksDataException {
        super(ioManager, diskBufferCache, fileManager, bloomFilterFalsePositiveRate, mergePolicy, opTracker, ioScheduler, ioOpCallbackFactory, componentFactory, bulkLoadComponentFactory, durable, tracer);
        this.btreeCmpFactories = btreeCmpFactories;
        this.buddyBtreeCmpFactories = buddyBtreeCmpFactories;
        this.buddyBTreeFields = buddyBTreeFields;
        this.btreeInteriorFrameFactory = btreeInteriorFrameFactory;
        this.btreeLeafFrameFactory = btreeLeafFrameFactory;
        this.buddyBtreeLeafFrameFactory = buddyBtreeLeafFrameFactory;
        this.secondDiskComponents = new LinkedList<ILSMDiskComponent>();
    }

    public void create() throws HyracksDataException {
        super.create();
        this.secondDiskComponents.clear();
    }

    public void activate() throws HyracksDataException {
        if (this.isActive) {
            throw new HyracksDataException("Failed to activate the index since it is already activated.");
        }
        if (this.diskComponents.size() == 0 && this.secondDiskComponents.size() == 0) {
            List validFileReferences = this.fileManager.cleanupAndGetValidFiles();
            for (LSMComponentFileReferences lsmComonentFileReference : validFileReferences) {
                ILSMDiskComponent component = this.createDiskComponent(this.componentFactory, lsmComonentFileReference.getInsertIndexFileReference(), lsmComonentFileReference.getDeleteIndexFileReference(), lsmComonentFileReference.getBloomFilterFileReference(), false);
                this.diskComponents.add(component);
                this.secondDiskComponents.add(component);
            }
            ((ExternalIndexHarness)this.getHarness()).indexFirstTimeActivated();
        } else {
            for (ILSMDiskComponent c : this.diskComponents) {
                c.activate(false);
            }
            for (ILSMDiskComponent c : this.secondDiskComponents) {
                if (this.diskComponents.contains(c)) continue;
                c.activate(false);
            }
        }
        this.isActive = true;
    }

    public void clear() throws HyracksDataException {
        if (!this.isActive) {
            throw new HyracksDataException("Failed to clear the index since it is not activated.");
        }
        ((ExternalIndexHarness)this.getHarness()).indexClear();
        for (ILSMDiskComponent c : this.diskComponents) {
            c.deactivateAndDestroy();
            this.secondDiskComponents.remove(c);
        }
        for (ILSMDiskComponent c : this.secondDiskComponents) {
            c.deactivateAndDestroy();
        }
        this.diskComponents.clear();
        this.secondDiskComponents.clear();
        this.version = 0;
    }

    public void destroy() throws HyracksDataException {
        if (this.isActive) {
            throw new HyracksDataException("Failed to destroy the index since it is activated.");
        }
        for (ILSMDiskComponent c : this.diskComponents) {
            c.destroy();
            this.secondDiskComponents.remove(c);
        }
        for (ILSMDiskComponent c : this.secondDiskComponents) {
            c.destroy();
        }
        this.diskComponents.clear();
        this.secondDiskComponents.clear();
        this.fileManager.deleteDirs();
        this.version = 0;
    }

    public ILSMIndexAccessor createAccessor(IIndexAccessParameters iap) throws HyracksDataException {
        return new LSMTreeIndexAccessor(this.getHarness(), (ILSMIndexOperationContext)this.createOpContext(iap.getSearchOperationCallback(), this.version), ctx -> new LSMBTreeWithBuddySearchCursor(ctx, this.buddyBTreeFields));
    }

    public void subsumeMergedComponents(ILSMDiskComponent newComponent, List<ILSMComponent> mergedComponents) throws HyracksDataException {
        int swapIndex;
        List olderList;
        List<ILSMDiskComponent> newerList;
        if (this.version == 0) {
            newerList = this.diskComponents;
            olderList = this.secondDiskComponents;
        } else {
            newerList = this.secondDiskComponents;
            olderList = this.diskComponents;
        }
        if (olderList.containsAll(mergedComponents)) {
            swapIndex = olderList.indexOf(mergedComponents.get(0));
            olderList.removeAll(mergedComponents);
            olderList.add(swapIndex, newComponent);
        }
        swapIndex = newerList.indexOf(mergedComponents.get(0));
        newerList.removeAll(mergedComponents);
        newerList.add(swapIndex, newComponent);
    }

    public IIndexBulkLoader createBulkLoader(float fillLevel, boolean verifyInput, long numElementsHint) throws HyracksDataException {
        return new LSMTwoPCBTreeWithBuddyBulkLoader(fillLevel, verifyInput, 0L, false);
    }

    public IIndexBulkLoader createTransactionBulkLoader(float fillLevel, boolean verifyInput, long numElementsHint) throws HyracksDataException {
        return new LSMTwoPCBTreeWithBuddyBulkLoader(fillLevel, verifyInput, numElementsHint, true);
    }

    public void modify(IIndexOperationContext ictx, ITupleReference tuple) throws HyracksDataException {
        throw new UnsupportedOperationException("tuple modify not supported in LSM-Disk-Only-BTree");
    }

    public void search(ILSMIndexOperationContext ictx, IIndexCursor cursor, ISearchPredicate pred) throws HyracksDataException {
        ExternalBTreeWithBuddyOpContext ctx = (ExternalBTreeWithBuddyOpContext)ictx;
        List operationalComponents = ictx.getComponentHolder();
        ctx.getSearchInitialState().setOperationalComponents(operationalComponents);
        cursor.open((ICursorInitialState)ctx.getSearchInitialState(), pred);
    }

    public void scheduleFlush(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException {
        throw HyracksDataException.create((int)36, (Serializable[])new Serializable[0]);
    }

    public ILSMDiskComponent doFlush(ILSMIOOperation operation) throws HyracksDataException {
        throw HyracksDataException.create((int)36, (Serializable[])new Serializable[0]);
    }

    protected LSMComponentFileReferences getMergeTargetFileName(List<ILSMComponent> mergingDiskComponents) throws HyracksDataException {
        BTree firstTree = ((LSMBTreeWithBuddyDiskComponent)mergingDiskComponents.get(0)).getIndex();
        BTree lastTree = ((LSMBTreeWithBuddyDiskComponent)mergingDiskComponents.get(mergingDiskComponents.size() - 1)).getIndex();
        FileReference firstFile = firstTree.getFileReference();
        FileReference lastFile = lastTree.getFileReference();
        LSMComponentFileReferences fileRefs = this.fileManager.getRelMergeFileReference(firstFile.getFile().getName(), lastFile.getFile().getName());
        return fileRefs;
    }

    public void scheduleMerge(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException {
        ExternalBTreeWithBuddyOpContext bctx = this.createOpContext((ISearchOperationCallback)NoOpOperationCallback.INSTANCE, 0);
        bctx.setOperation(IndexOperation.MERGE);
        List mergingComponents = ctx.getComponentHolder();
        LSMBTreeWithBuddySortedCursor cursor = new LSMBTreeWithBuddySortedCursor((ILSMIndexOperationContext)bctx, this.buddyBTreeFields);
        LSMComponentFileReferences relMergeFileRefs = this.getMergeTargetFileName(mergingComponents);
        LSMTreeIndexAccessor accessor = new LSMTreeIndexAccessor(this.getHarness(), (ILSMIndexOperationContext)bctx, opCtx -> new LSMBTreeWithBuddySearchCursor(opCtx, this.buddyBTreeFields));
        boolean keepDeleteTuples = false;
        keepDeleteTuples = this.version == 0 ? mergingComponents.get(mergingComponents.size() - 1) != this.diskComponents.get(this.diskComponents.size() - 1) : mergingComponents.get(mergingComponents.size() - 1) != this.secondDiskComponents.get(this.secondDiskComponents.size() - 1);
        this.ioScheduler.scheduleOperation((ILSMIOOperation)new LSMBTreeWithBuddyMergeOperation((ILSMIndexAccessor)accessor, (IIndexCursor)cursor, relMergeFileRefs.getInsertIndexFileReference(), relMergeFileRefs.getDeleteIndexFileReference(), relMergeFileRefs.getBloomFilterFileReference(), callback, this.fileManager.getBaseDir().getAbsolutePath(), keepDeleteTuples));
    }

    public ExternalBTreeWithBuddyOpContext createOpContext(ISearchOperationCallback searchCallback, int targetVersion) {
        return new ExternalBTreeWithBuddyOpContext((ILSMIndex)this, this.btreeCmpFactories, this.buddyBtreeCmpFactories, searchCallback, targetVersion, this.getHarness(), this.btreeInteriorFrameFactory, this.btreeLeafFrameFactory, this.buddyBtreeLeafFrameFactory, this.tracer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILSMDiskComponent doMerge(ILSMIOOperation operation) throws HyracksDataException {
        ChainedLSMDiskComponentBulkLoader componentBulkLoader;
        LSMBTreeWithBuddyMergeOperation mergeOp = (LSMBTreeWithBuddyMergeOperation)operation;
        IIndexCursor cursor = mergeOp.getCursor();
        RangePredicate btreeSearchPred = new RangePredicate(null, null, true, true, null, null);
        ILSMIndexOperationContext opCtx = ((LSMBTreeWithBuddySortedCursor)cursor).getOpCtx();
        this.search(opCtx, cursor, (ISearchPredicate)btreeSearchPred);
        ILSMDiskComponent mergedComponent = this.createDiskComponent(this.componentFactory, mergeOp.getTarget(), mergeOp.getBuddyBTreeTarget(), mergeOp.getBloomFilterTarget(), true);
        if (mergeOp.isKeepDeletedTuples()) {
            LSMBuddyBTreeMergeCursor buddyBtreeCursor = new LSMBuddyBTreeMergeCursor(opCtx);
            this.search(opCtx, (IIndexCursor)buddyBtreeCursor, (ISearchPredicate)btreeSearchPred);
            long numElements = 0L;
            for (int i = 0; i < mergeOp.getMergingComponents().size(); ++i) {
                numElements += ((AbstractLSMWithBloomFilterDiskComponent)mergeOp.getMergingComponents().get(i)).getBloomFilter().getNumElements();
            }
            componentBulkLoader = mergedComponent.createBulkLoader(1.0f, false, numElements, false, false, false);
            try {
                while (buddyBtreeCursor.hasNext()) {
                    buddyBtreeCursor.next();
                    ITupleReference tuple = buddyBtreeCursor.getTuple();
                    componentBulkLoader.delete(tuple);
                }
            }
            finally {
                buddyBtreeCursor.close();
            }
        } else {
            componentBulkLoader = mergedComponent.createBulkLoader(1.0f, false, 0L, false, false, false);
        }
        try {
            while (cursor.hasNext()) {
                cursor.next();
                ITupleReference frameTuple = cursor.getTuple();
                componentBulkLoader.add(frameTuple);
            }
        }
        finally {
            cursor.close();
        }
        componentBulkLoader.end();
        return mergedComponent;
    }

    public void getOperationalComponents(ILSMIndexOperationContext ctx) {
        List operationalComponents = ctx.getComponentHolder();
        List<ILSMDiskComponent> immutableComponents = this.version == 0 ? this.diskComponents : this.secondDiskComponents;
        ExternalBTreeWithBuddyOpContext opCtx = (ExternalBTreeWithBuddyOpContext)ctx;
        operationalComponents.clear();
        switch (ctx.getOperation()) {
            case SEARCH: {
                if (opCtx.getTargetIndexVersion() == 0) {
                    operationalComponents.addAll(this.diskComponents);
                    break;
                }
                operationalComponents.addAll(this.secondDiskComponents);
                break;
            }
            case MERGE: {
                operationalComponents.addAll(ctx.getComponentsToBeMerged());
                break;
            }
            case FULL_MERGE: {
                operationalComponents.addAll(immutableComponents);
            }
            case REPLICATE: {
                operationalComponents.addAll(ctx.getComponentsToBeReplicated());
                break;
            }
            case FLUSH: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operation " + ctx.getOperation() + " not supported.");
            }
        }
    }

    public void commitTransactionDiskComponent(ILSMDiskComponent newComponent) throws HyracksDataException {
        List olderList;
        List<ILSMDiskComponent> newerList;
        if (this.version == 0) {
            newerList = this.diskComponents;
            olderList = this.secondDiskComponents;
            this.version = 1;
        } else {
            newerList = this.secondDiskComponents;
            olderList = this.diskComponents;
            this.version = 0;
        }
        olderList.clear();
        olderList.addAll(newerList);
        if (newComponent != null) {
            olderList.add(0, newComponent);
        }
    }

    public void deactivate(boolean flushOnExit) throws HyracksDataException {
        if (!this.isActive) {
            throw new HyracksDataException("Failed to deactivate the index since it is already deactivated.");
        }
        if (flushOnExit) {
            AbstractLSMIndexOperationContext opCtx = this.createOpContext((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
            opCtx.setIoOperationType(ILSMIOOperation.LSMIOOperationType.FLUSH);
            this.ioOpCallback.afterFinalize((ILSMIndexOperationContext)opCtx);
        }
        for (ILSMDiskComponent c : this.diskComponents) {
            c.deactivateAndPurge();
        }
        for (ILSMDiskComponent c : this.secondDiskComponents) {
            if (this.diskComponents.contains(c)) continue;
            c.deactivateAndPurge();
        }
        this.isActive = false;
    }

    public ITreeIndexFrameFactory getLeafFrameFactory() {
        return this.btreeLeafFrameFactory;
    }

    public ITreeIndexFrameFactory getInteriorFrameFactory() {
        return this.btreeInteriorFrameFactory;
    }

    public IMetadataPageManager getPageManager() {
        return null;
    }

    public int getFieldCount() {
        return this.btreeCmpFactories.length;
    }

    public int getRootPageId() {
        return 0;
    }

    public int getFileId() {
        return 0;
    }

    public IBinaryComparatorFactory[] getComparatorFactories() {
        return this.btreeCmpFactories;
    }

    public ILSMIndexAccessor createAccessor(ISearchOperationCallback searchCallback, int targetIndexVersion) throws HyracksDataException {
        return new LSMTreeIndexAccessor(this.getHarness(), (ILSMIndexOperationContext)this.createOpContext(searchCallback, targetIndexVersion), ctx -> new LSMBTreeWithBuddySearchCursor(ctx, this.buddyBTreeFields));
    }

    public void addDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        if (this.version == 0) {
            this.diskComponents.add(0, c);
        } else if (this.version == 1) {
            this.secondDiskComponents.add(0, c);
        }
    }

    public int getCurrentVersion() {
        return this.version;
    }

    public void setCurrentVersion(int version) {
        this.version = version;
    }

    public List<ILSMDiskComponent> getFirstComponentList() {
        return this.diskComponents;
    }

    public List<ILSMDiskComponent> getSecondComponentList() {
        return this.secondDiskComponents;
    }

    public void commitTransaction() throws HyracksDataException {
        LSMComponentFileReferences componentFileRefrences = this.fileManager.getTransactionFileReferenceForCommit();
        ILSMDiskComponent component = null;
        if (componentFileRefrences != null) {
            component = this.createDiskComponent(this.componentFactory, componentFileRefrences.getInsertIndexFileReference(), componentFileRefrences.getDeleteIndexFileReference(), componentFileRefrences.getBloomFilterFileReference(), false);
        }
        ((ExternalIndexHarness)this.getHarness()).addTransactionComponents(component);
    }

    public void abortTransaction() throws HyracksDataException {
        this.fileManager.deleteTransactionFiles();
    }

    public void recoverTransaction() throws HyracksDataException {
        this.fileManager.recoverTransaction();
    }

    public boolean isPrimaryIndex() {
        return false;
    }

    protected LSMComponentFileReferences getMergeFileReferences(ILSMDiskComponent firstComponent, ILSMDiskComponent lastComponent) throws HyracksDataException {
        return null;
    }

    protected AbstractLSMIndexOperationContext createOpContext(IIndexAccessParameters iap) {
        return null;
    }

    protected ILSMIOOperation createFlushOperation(AbstractLSMIndexOperationContext opCtx, LSMComponentFileReferences componentFileRefs, ILSMIOOperationCallback callback) throws HyracksDataException {
        return null;
    }

    protected ILSMIOOperation createMergeOperation(AbstractLSMIndexOperationContext opCtx, LSMComponentFileReferences mergeFileRefs, ILSMIOOperationCallback callback) throws HyracksDataException {
        return null;
    }

    public class LSMTwoPCBTreeWithBuddyBulkLoader
    implements IIndexBulkLoader,
    ITwoPCIndexBulkLoader {
        private final ILSMDiskComponent component;
        private final ILSMDiskComponentBulkLoader componentBulkLoader;
        private final boolean isTransaction;

        public LSMTwoPCBTreeWithBuddyBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean isTransaction) throws HyracksDataException {
            this.isTransaction = isTransaction;
            this.component = isTransaction ? this.createTransactionTarget() : ExternalBTreeWithBuddy.this.createBulkLoadTarget();
            this.componentBulkLoader = this.component.createBulkLoader(fillFactor, verifyInput, numElementsHint, false, true, false);
        }

        public void add(ITupleReference tuple) throws HyracksDataException {
            this.componentBulkLoader.add(tuple);
        }

        public void end() throws HyracksDataException {
            this.componentBulkLoader.end();
            if (this.component.getComponentSize() > 0L) {
                if (this.isTransaction) {
                    this.component.markAsValid(ExternalBTreeWithBuddy.this.durable);
                    this.component.deactivate();
                } else {
                    ExternalBTreeWithBuddy.this.getHarness().addBulkLoadedComponent(this.component);
                }
            }
        }

        public void delete(ITupleReference tuple) throws HyracksDataException {
            this.componentBulkLoader.delete(tuple);
        }

        public void abort() {
            try {
                this.componentBulkLoader.abort();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private ILSMDiskComponent createTransactionTarget() throws HyracksDataException {
            LSMComponentFileReferences componentFileRefs;
            try {
                componentFileRefs = ExternalBTreeWithBuddy.this.fileManager.getNewTransactionFileReference();
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            return ExternalBTreeWithBuddy.this.createDiskComponent(ExternalBTreeWithBuddy.this.bulkLoadComponentFactory, componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getDeleteIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), true);
        }
    }
}

