/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.search;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.ShortPointable;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.tuples.ConcatenatingTupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInPlaceInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexSearchModifier;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IPartitionedInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.InvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.AbstractTOccurrenceSearcher;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedIndexSearchPredicate;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedListPartitions;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchPredicate;

public class PartitionedTOccurrenceSearcher
extends AbstractTOccurrenceSearcher {
    protected final ArrayTupleBuilder lowerBoundTupleBuilder = new ArrayTupleBuilder(1);
    protected final ArrayTupleReference lowerBoundTuple = new ArrayTupleReference();
    protected final ArrayTupleBuilder upperBoundTupleBuilder = new ArrayTupleBuilder(1);
    protected final ArrayTupleReference upperBoundTuple = new ArrayTupleReference();
    protected final ConcatenatingTupleReference fullLowSearchKey = new ConcatenatingTupleReference(2);
    protected final ConcatenatingTupleReference fullHighSearchKey = new ConcatenatingTupleReference(2);
    protected final InvertedListPartitions partitions = new InvertedListPartitions();
    protected int curPartIdx;
    protected int endPartIdx;
    protected int numPrefixLists;
    protected boolean isFinalPartIdx;
    protected boolean needToReadNewPart;
    List<InvertedListCursor>[] partitionCursors;
    IInvertedIndexSearchModifier searchModifier;

    public PartitionedTOccurrenceSearcher(IInPlaceInvertedIndex invIndex, IHyracksTaskContext ctx) throws HyracksDataException {
        super(invIndex, ctx);
        this.initHelperTuples();
        this.curPartIdx = 0;
        this.endPartIdx = 0;
        this.isFinalPartIdx = false;
        this.isFinishedSearch = false;
        this.needToReadNewPart = true;
    }

    private void initHelperTuples() {
        try {
            this.lowerBoundTupleBuilder.reset();
            this.lowerBoundTupleBuilder.getDataOutput().writeShort(Short.MIN_VALUE);
            this.lowerBoundTupleBuilder.addFieldEndOffset();
            this.lowerBoundTuple.reset(this.lowerBoundTupleBuilder.getFieldEndOffsets(), this.lowerBoundTupleBuilder.getByteArray());
            this.searchKey.reset((IFrameTupleAccessor)this.queryTokenAppender, 0);
            this.fullLowSearchKey.reset();
            this.fullLowSearchKey.addTuple((ITupleReference)this.searchKey);
            this.fullLowSearchKey.addTuple((ITupleReference)this.lowerBoundTuple);
            this.upperBoundTupleBuilder.reset();
            this.upperBoundTupleBuilder.getDataOutput().writeShort(Short.MAX_VALUE);
            this.upperBoundTupleBuilder.addFieldEndOffset();
            this.upperBoundTuple.reset(this.upperBoundTupleBuilder.getFieldEndOffsets(), this.upperBoundTupleBuilder.getByteArray());
            this.searchKey.reset((IFrameTupleAccessor)this.queryTokenAppender, 0);
            this.fullHighSearchKey.reset();
            this.fullHighSearchKey.addTuple((ITupleReference)this.searchKey);
            this.fullHighSearchKey.addTuple((ITupleReference)this.upperBoundTuple);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void search(IIndexCursor resultCursor, InvertedIndexSearchPredicate searchPred, IIndexOperationContext ictx) throws HyracksDataException {
        this.prepareSearch();
        IPartitionedInvertedIndex partInvIndex = (IPartitionedInvertedIndex)((Object)this.invIndex);
        this.finalSearchResult.reset();
        if (partInvIndex.isEmpty()) {
            this.isFinishedSearch = true;
            resultCursor.open(null, (ISearchPredicate)searchPred);
            return;
        }
        this.tokenizeQuery(searchPred);
        int numQueryTokens = this.queryTokenAppender.getTupleCount();
        this.searchModifier = searchPred.getSearchModifier();
        short numTokensLowerBound = this.searchModifier.getNumTokensLowerBound((short)numQueryTokens);
        short numTokensUpperBound = this.searchModifier.getNumTokensUpperBound((short)numQueryTokens);
        this.occurrenceThreshold = this.searchModifier.getOccurrenceThreshold(numQueryTokens);
        if (this.occurrenceThreshold <= 0) {
            throw HyracksDataException.create((int)39, (Serializable[])new Serializable[0]);
        }
        int maxCountPossible = numQueryTokens;
        this.invListCursorCache.reset();
        this.partitions.reset(numTokensLowerBound, numTokensUpperBound);
        for (int i = 0; i < numQueryTokens; ++i) {
            this.searchKey.reset((IFrameTupleAccessor)this.queryTokenAppender, i);
            if (partInvIndex.openInvertedListPartitionCursors(this, ictx, numTokensLowerBound, numTokensUpperBound, this.partitions) || (maxCountPossible = (int)((short)(maxCountPossible - 1))) >= this.occurrenceThreshold) continue;
            this.closeCursorsInPartitions(this.partitions);
            this.isFinishedSearch = true;
            resultCursor.open(null, (ISearchPredicate)searchPred);
            return;
        }
        this.partitionCursors = this.partitions.getPartitions();
        int start = this.partitions.getMinValidPartitionIndex();
        short end = this.partitions.getMaxValidPartitionIndex();
        this.endPartIdx = end;
        for (int i = start; i <= end; ++i) {
            if (this.partitionCursors[i] == null) continue;
            if (this.partitionCursors[i].size() < this.occurrenceThreshold) {
                for (InvertedListCursor cursor : this.partitionCursors[i]) {
                    cursor.close();
                }
                continue;
            }
            this.numPrefixLists = this.searchModifier.getNumPrefixLists(this.occurrenceThreshold, this.partitionCursors[i].size());
            this.invListMerger.reset();
            this.curPartIdx = i;
            boolean bl = this.isFinalPartIdx = i == end;
            if (this.partitionCursors[i].size() == 1) {
                this.singleInvListCursor = this.partitionCursors[i].get(0);
                this.singleInvListCursor.prepareLoadPages();
                this.singleInvListCursor.loadPages();
                this.isSingleInvertedList = true;
                this.needToReadNewPart = true;
            } else {
                this.singleInvListCursor = null;
                this.isSingleInvertedList = false;
                this.needToReadNewPart = this.invListMerger.merge(this.partitionCursors[i], this.occurrenceThreshold, this.numPrefixLists, this.finalSearchResult);
                this.searchResultBuffer = this.finalSearchResult.getNextFrame();
                this.searchResultTupleIndex = 0;
                this.searchResultFta.reset(this.searchResultBuffer);
            }
            if (this.needToReadNewPart && this.isFinalPartIdx) {
                this.invListMerger.close();
                this.finalSearchResult.finalizeWrite();
                this.isFinishedSearch = true;
            }
            resultCursor.open(null, (ISearchPredicate)searchPred);
            return;
        }
        this.isFinishedSearch = true;
        this.needToReadNewPart = true;
        resultCursor.open(null, (ISearchPredicate)searchPred);
    }

    @Override
    public boolean continueSearch() throws HyracksDataException {
        if (this.isFinishedSearch) {
            return true;
        }
        if (!this.needToReadNewPart) {
            this.needToReadNewPart = this.invListMerger.continueMerge();
            this.searchResultBuffer = this.finalSearchResult.getNextFrame();
            this.searchResultTupleIndex = 0;
            this.searchResultFta.reset(this.searchResultBuffer);
            if (this.needToReadNewPart && this.isFinalPartIdx) {
                this.isFinishedSearch = true;
                this.invListMerger.close();
                this.finalSearchResult.finalizeWrite();
                return true;
            }
            return false;
        }
        ++this.curPartIdx;
        if (this.curPartIdx <= this.endPartIdx) {
            boolean suitablePartFound = false;
            for (int i = this.curPartIdx; i <= this.endPartIdx; ++i) {
                if (this.partitionCursors[i] == null) continue;
                if (this.partitionCursors[i].size() < this.occurrenceThreshold) {
                    for (InvertedListCursor cursor : this.partitionCursors[i]) {
                        cursor.close();
                    }
                    continue;
                }
                suitablePartFound = true;
                this.curPartIdx = i;
                break;
            }
            if (!suitablePartFound) {
                this.isFinishedSearch = true;
                this.invListMerger.close();
                this.finalSearchResult.finalizeWrite();
                return true;
            }
            this.numPrefixLists = this.searchModifier.getNumPrefixLists(this.occurrenceThreshold, this.partitionCursors[this.curPartIdx].size());
            this.invListMerger.reset();
            this.finalSearchResult.resetBuffer();
            boolean bl = this.isFinalPartIdx = this.curPartIdx == this.endPartIdx;
            if (this.partitionCursors[this.curPartIdx].size() == 1) {
                this.singleInvListCursor = this.partitionCursors[this.curPartIdx].get(0);
                this.singleInvListCursor.prepareLoadPages();
                this.singleInvListCursor.loadPages();
                this.isSingleInvertedList = true;
                this.needToReadNewPart = true;
            } else {
                this.singleInvListCursor = null;
                this.isSingleInvertedList = false;
                this.needToReadNewPart = this.invListMerger.merge(this.partitionCursors[this.curPartIdx], this.occurrenceThreshold, this.numPrefixLists, this.finalSearchResult);
                this.searchResultBuffer = this.finalSearchResult.getNextFrame();
                this.searchResultTupleIndex = 0;
                this.searchResultFta.reset(this.searchResultBuffer);
            }
            if (this.needToReadNewPart && this.isFinalPartIdx) {
                this.invListMerger.close();
                this.finalSearchResult.finalizeWrite();
                this.isFinishedSearch = true;
                return true;
            }
        } else {
            this.isFinishedSearch = true;
        }
        return false;
    }

    private void closeCursorsInPartitions(InvertedListPartitions parts) throws HyracksDataException {
        ArrayList<InvertedListCursor>[] partCursors = parts.getPartitions();
        int start = parts.getMinValidPartitionIndex();
        short end = parts.getMaxValidPartitionIndex();
        for (int i = start; i <= end; ++i) {
            if (partCursors[i] == null) continue;
            for (InvertedListCursor cursor : partCursors[i]) {
                cursor.close();
            }
        }
    }

    public void setNumTokensBoundsInSearchKeys(short numTokensLowerBound, short numTokensUpperBound) {
        ShortPointable.setShort((byte[])this.lowerBoundTuple.getFieldData(0), (int)this.lowerBoundTuple.getFieldStart(0), (short)numTokensLowerBound);
        ShortPointable.setShort((byte[])this.upperBoundTuple.getFieldData(0), (int)this.upperBoundTuple.getFieldStart(0), (short)numTokensUpperBound);
    }

    public ITupleReference getPrefixSearchKey() {
        return this.searchKey;
    }

    public ITupleReference getFullLowSearchKey() {
        return this.fullLowSearchKey;
    }

    public ITupleReference getFullHighSearchKey() {
        return this.fullHighSearchKey;
    }

    public InvertedListCursor getCachedInvertedListCursor() throws HyracksDataException {
        return (InvertedListCursor)this.invListCursorCache.getNext();
    }
}

