/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.ondisk;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.common.tuples.ConcatenatingTupleReference;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInPlaceInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.InvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.OnDiskInvertedIndex;
import org.apache.hyracks.storage.common.EnforcedIndexCursor;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchPredicate;

public class OnDiskInvertedIndexRangeSearchCursor
extends EnforcedIndexCursor {
    private final BTree btree;
    private final IIndexAccessor btreeAccessor;
    private final IInPlaceInvertedIndex invIndex;
    private final IIndexOperationContext opCtx;
    private final InvertedListCursor invListRangeSearchCursor;
    private boolean isInvListCursorOpen;
    private final IIndexCursor btreeCursor;
    private RangePredicate btreePred;
    private final PermutingTupleReference tokenTuple;
    private ConcatenatingTupleReference concatTuple;

    public OnDiskInvertedIndexRangeSearchCursor(IInPlaceInvertedIndex invIndex, IIndexOperationContext opCtx) throws HyracksDataException {
        this.btree = ((OnDiskInvertedIndex)invIndex).getBTree();
        this.btreeAccessor = this.btree.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
        this.invIndex = invIndex;
        this.opCtx = opCtx;
        int[] fieldPermutation = new int[invIndex.getTokenTypeTraits().length];
        for (int i = 0; i < invIndex.getTokenTypeTraits().length; ++i) {
            fieldPermutation[i] = i;
        }
        this.tokenTuple = new PermutingTupleReference(fieldPermutation);
        this.btreeCursor = this.btreeAccessor.createSearchCursor(false);
        this.concatTuple = new ConcatenatingTupleReference(2);
        this.invListRangeSearchCursor = invIndex.createInvertedListRangeSearchCursor();
        this.isInvListCursorOpen = false;
    }

    public void doOpen(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        this.btreePred = (RangePredicate)searchPred;
        this.btreeAccessor.search(this.btreeCursor, (ISearchPredicate)this.btreePred);
        this.openInvListRangeSearchCursor();
    }

    public boolean doHasNext() throws HyracksDataException {
        if (!this.isInvListCursorOpen) {
            return false;
        }
        if (this.invListRangeSearchCursor.hasNext()) {
            return true;
        }
        try {
            this.invListRangeSearchCursor.unloadPages();
        }
        finally {
            this.invListRangeSearchCursor.close();
        }
        this.isInvListCursorOpen = false;
        this.openInvListRangeSearchCursor();
        return this.isInvListCursorOpen;
    }

    public void doNext() throws HyracksDataException {
        this.invListRangeSearchCursor.next();
        if (this.concatTuple.hasMaxTuples()) {
            this.concatTuple.removeLastTuple();
        }
        this.concatTuple.addTuple(this.invListRangeSearchCursor.getTuple());
    }

    public void doDestroy() throws HyracksDataException {
        block6: {
            try {
                if (!this.isInvListCursorOpen) break block6;
                try {
                    this.invListRangeSearchCursor.unloadPages();
                }
                finally {
                    this.isInvListCursorOpen = false;
                    this.invListRangeSearchCursor.destroy();
                }
            }
            finally {
                this.btreeCursor.destroy();
            }
        }
    }

    public void doClose() throws HyracksDataException {
        block6: {
            try {
                if (!this.isInvListCursorOpen) break block6;
                try {
                    this.invListRangeSearchCursor.unloadPages();
                }
                finally {
                    this.invListRangeSearchCursor.close();
                }
                this.isInvListCursorOpen = false;
            }
            finally {
                this.btreeCursor.close();
            }
        }
    }

    public ITupleReference doGetTuple() {
        return this.concatTuple;
    }

    private void openInvListRangeSearchCursor() throws HyracksDataException {
        if (this.btreeCursor.hasNext()) {
            this.btreeCursor.next();
            this.tokenTuple.reset(this.btreeCursor.getTuple());
            this.invIndex.openInvertedListCursor(this.invListRangeSearchCursor, (ITupleReference)this.tokenTuple, this.opCtx);
            this.invListRangeSearchCursor.prepareLoadPages();
            this.invListRangeSearchCursor.loadPages();
            this.concatTuple.reset();
            this.concatTuple.addTuple((ITupleReference)this.tokenTuple);
            this.isInvListCursorOpen = true;
        } else {
            this.isInvListCursorOpen = false;
        }
    }
}

