/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.translator;

import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import org.apache.asterix.active.ActivityState;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.active.IActiveEntityEventsListener;
import org.apache.asterix.active.IRetryPolicyFactory;
import org.apache.asterix.active.NoRetryPolicyFactory;
import org.apache.asterix.algebra.extension.ExtensionStatement;
import org.apache.asterix.api.common.APIFramework;
import org.apache.asterix.api.http.server.AbstractQueryApiServlet;
import org.apache.asterix.api.http.server.ResultUtil;
import org.apache.asterix.app.active.ActiveEntityEventsListener;
import org.apache.asterix.app.active.ActiveNotificationHandler;
import org.apache.asterix.app.active.FeedEventsListener;
import org.apache.asterix.app.result.ResultHandle;
import org.apache.asterix.app.result.ResultReader;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.api.IMetadataLockManager;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.config.GlobalConfig;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.MetadataException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.IDataset;
import org.apache.asterix.common.metadata.LockList;
import org.apache.asterix.common.utils.JobUtils;
import org.apache.asterix.compiler.provider.ILangCompilationProvider;
import org.apache.asterix.external.feed.api.IFeed;
import org.apache.asterix.external.feed.management.FeedConnectionId;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.external.indexing.IndexingConstants;
import org.apache.asterix.external.operators.FeedIntakeOperatorNodePushable;
import org.apache.asterix.formats.nontagged.TypeTraitProvider;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.IQueryRewriter;
import org.apache.asterix.lang.common.base.IReturningStatement;
import org.apache.asterix.lang.common.base.IRewriterFactory;
import org.apache.asterix.lang.common.base.IStatementRewriter;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.expression.IndexedTypeExpression;
import org.apache.asterix.lang.common.expression.TypeExpression;
import org.apache.asterix.lang.common.statement.CompactStatement;
import org.apache.asterix.lang.common.statement.ConnectFeedStatement;
import org.apache.asterix.lang.common.statement.CreateDataverseStatement;
import org.apache.asterix.lang.common.statement.CreateFeedPolicyStatement;
import org.apache.asterix.lang.common.statement.CreateFeedStatement;
import org.apache.asterix.lang.common.statement.CreateFunctionStatement;
import org.apache.asterix.lang.common.statement.CreateIndexStatement;
import org.apache.asterix.lang.common.statement.DatasetDecl;
import org.apache.asterix.lang.common.statement.DataverseDecl;
import org.apache.asterix.lang.common.statement.DataverseDropStatement;
import org.apache.asterix.lang.common.statement.DeleteStatement;
import org.apache.asterix.lang.common.statement.DisconnectFeedStatement;
import org.apache.asterix.lang.common.statement.DropDatasetStatement;
import org.apache.asterix.lang.common.statement.ExternalDetailsDecl;
import org.apache.asterix.lang.common.statement.FeedDropStatement;
import org.apache.asterix.lang.common.statement.FeedPolicyDropStatement;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.FunctionDropStatement;
import org.apache.asterix.lang.common.statement.IndexDropStatement;
import org.apache.asterix.lang.common.statement.InsertStatement;
import org.apache.asterix.lang.common.statement.InternalDetailsDecl;
import org.apache.asterix.lang.common.statement.LoadStatement;
import org.apache.asterix.lang.common.statement.NodeGroupDropStatement;
import org.apache.asterix.lang.common.statement.NodegroupDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.statement.RefreshExternalDatasetStatement;
import org.apache.asterix.lang.common.statement.SetStatement;
import org.apache.asterix.lang.common.statement.StartFeedStatement;
import org.apache.asterix.lang.common.statement.StopFeedStatement;
import org.apache.asterix.lang.common.statement.TypeDecl;
import org.apache.asterix.lang.common.statement.TypeDropStatement;
import org.apache.asterix.lang.common.statement.WriteStatement;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.lang.sqlpp.rewrites.SqlppRewriterFactory;
import org.apache.asterix.metadata.IDatasetDetails;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.bootstrap.MetadataBuiltinEntities;
import org.apache.asterix.metadata.dataset.hints.DatasetHints;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.BuiltinTypeMap;
import org.apache.asterix.metadata.entities.CompactionPolicy;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.ExternalDatasetDetails;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.entities.NodeGroup;
import org.apache.asterix.metadata.feeds.FeedMetadataUtil;
import org.apache.asterix.metadata.lock.ExternalDatasetsRegistry;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.ExternalIndexingOperations;
import org.apache.asterix.metadata.utils.IndexUtil;
import org.apache.asterix.metadata.utils.KeyFieldTypeUtil;
import org.apache.asterix.metadata.utils.MetadataLockUtil;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeSignature;
import org.apache.asterix.transaction.management.service.transaction.DatasetIdFactory;
import org.apache.asterix.translator.AbstractLangTranslator;
import org.apache.asterix.translator.CompiledStatements;
import org.apache.asterix.translator.ExecutionPlans;
import org.apache.asterix.translator.ExecutionPlansHtmlPrintUtil;
import org.apache.asterix.translator.IRequestParameters;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.IStatementExecutorContext;
import org.apache.asterix.translator.NoOpStatementExecutorContext;
import org.apache.asterix.translator.SessionConfig;
import org.apache.asterix.translator.SessionOutput;
import org.apache.asterix.translator.TypeTranslator;
import org.apache.asterix.translator.util.ValidateUtil;
import org.apache.asterix.utils.DataverseUtil;
import org.apache.asterix.utils.FeedOperations;
import org.apache.asterix.utils.FlushDatasetUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.data.IAWriterFactory;
import org.apache.hyracks.algebricks.data.IResultSerializerFactoryProvider;
import org.apache.hyracks.algebricks.runtime.serializer.ResultSerializerFactoryProvider;
import org.apache.hyracks.algebricks.runtime.writers.PrinterBasedWriterFactory;
import org.apache.hyracks.api.client.IClusterInfoCollector;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.dataset.IHyracksDataset;
import org.apache.hyracks.api.dataset.ResultSetId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.io.UnmanagedFileSplit;
import org.apache.hyracks.api.job.JobFlag;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.job.IJobManager;
import org.apache.hyracks.control.cc.job.JobRun;
import org.apache.hyracks.control.common.controllers.CCConfig;
import org.apache.hyracks.control.common.job.profiling.om.JobProfile;
import org.apache.hyracks.control.common.job.profiling.om.JobletProfile;
import org.apache.hyracks.control.common.job.profiling.om.TaskProfile;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueryTranslator
extends AbstractLangTranslator
implements IStatementExecutor {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final boolean IS_DEBUG_MODE = false;
    protected final List<Statement> statements;
    protected final ICcApplicationContext appCtx;
    protected final SessionOutput sessionOutput;
    protected final SessionConfig sessionConfig;
    protected Dataverse activeDataverse;
    protected final List<FunctionDecl> declaredFunctions;
    protected final APIFramework apiFramework;
    protected final IRewriterFactory rewriterFactory;
    protected final ExecutorService executorService;
    protected final EnumSet<JobFlag> jobFlags = EnumSet.noneOf(JobFlag.class);
    protected final IMetadataLockManager lockManager;

    public QueryTranslator(ICcApplicationContext appCtx, List<Statement> statements, SessionOutput output, ILangCompilationProvider compliationProvider, ExecutorService executorService) {
        this.appCtx = appCtx;
        this.lockManager = appCtx.getMetadataLockManager();
        this.statements = statements;
        this.sessionOutput = output;
        this.sessionConfig = output.config();
        this.declaredFunctions = this.getDeclaredFunctions(statements);
        this.apiFramework = new APIFramework(compliationProvider);
        this.rewriterFactory = compliationProvider.getRewriterFactory();
        this.activeDataverse = MetadataBuiltinEntities.DEFAULT_DATAVERSE;
        this.executorService = executorService;
        if (appCtx.getServiceContext().getAppConfig().getBoolean((IOption)CCConfig.Option.ENFORCE_FRAME_WRITER_PROTOCOL)) {
            this.jobFlags.add(JobFlag.ENFORCE_CONTRACT);
        }
    }

    public SessionOutput getSessionOutput() {
        return this.sessionOutput;
    }

    protected List<FunctionDecl> getDeclaredFunctions(List<Statement> statements) {
        ArrayList<FunctionDecl> functionDecls = new ArrayList<FunctionDecl>();
        for (Statement st : statements) {
            if (st.getKind() != Statement.Kind.FUNCTION_DECL) continue;
            functionDecls.add((FunctionDecl)st);
        }
        return functionDecls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileAndExecute(IHyracksClientConnection hcc, IStatementExecutorContext ctx, IRequestParameters requestParameters) throws Exception {
        int resultSetIdCounter = 0;
        FileSplit outputFile = null;
        PrinterBasedWriterFactory writerFactory = PrinterBasedWriterFactory.INSTANCE;
        ResultSerializerFactoryProvider resultSerializerFactoryProvider = ResultSerializerFactoryProvider.INSTANCE;
        String threadName = Thread.currentThread().getName();
        Thread.currentThread().setName(QueryTranslator.class.getSimpleName());
        HashMap<String, String> config = new HashMap<String, String>();
        IHyracksDataset hdc = requestParameters.getHyracksDataset();
        IStatementExecutor.ResultDelivery resultDelivery = requestParameters.getResultProperties().getDelivery();
        long maxResultReads = requestParameters.getResultProperties().getMaxReads();
        IStatementExecutor.Stats stats = requestParameters.getStats();
        IStatementExecutor.ResultMetadata outMetadata = requestParameters.getOutMetadata();
        String clientContextId = requestParameters.getClientContextId();
        try {
            block36: for (Statement stmt : this.statements) {
                if (this.sessionConfig.is("format-html")) {
                    this.sessionOutput.out().println("<!-- BEGIN -->");
                }
                this.validateOperation(this.appCtx, this.activeDataverse, stmt);
                this.rewriteStatement(stmt);
                MetadataProvider metadataProvider = new MetadataProvider(this.appCtx, this.activeDataverse);
                metadataProvider.getConfig().putAll(config);
                metadataProvider.setWriterFactory((IAWriterFactory)writerFactory);
                metadataProvider.setResultSerializerFactoryProvider((IResultSerializerFactoryProvider)resultSerializerFactoryProvider);
                metadataProvider.setOutputFile(outputFile);
                switch (stmt.getKind()) {
                    case SET: {
                        this.handleSetStatement(stmt, config);
                        continue block36;
                    }
                    case DATAVERSE_DECL: {
                        this.activeDataverse = this.handleUseDataverseStatement(metadataProvider, stmt);
                        continue block36;
                    }
                    case CREATE_DATAVERSE: {
                        this.handleCreateDataverseStatement(metadataProvider, stmt);
                        continue block36;
                    }
                    case DATASET_DECL: {
                        this.handleCreateDatasetStatement(metadataProvider, stmt, hcc, requestParameters);
                        continue block36;
                    }
                    case CREATE_INDEX: {
                        this.handleCreateIndexStatement(metadataProvider, stmt, hcc, requestParameters);
                        continue block36;
                    }
                    case TYPE_DECL: {
                        this.handleCreateTypeStatement(metadataProvider, stmt);
                        continue block36;
                    }
                    case NODEGROUP_DECL: {
                        this.handleCreateNodeGroupStatement(metadataProvider, stmt);
                        continue block36;
                    }
                    case DATAVERSE_DROP: {
                        this.handleDataverseDropStatement(metadataProvider, stmt, hcc);
                        continue block36;
                    }
                    case DATASET_DROP: {
                        this.handleDatasetDropStatement(metadataProvider, stmt, hcc, requestParameters);
                        continue block36;
                    }
                    case INDEX_DROP: {
                        this.handleIndexDropStatement(metadataProvider, stmt, hcc, requestParameters);
                        continue block36;
                    }
                    case TYPE_DROP: {
                        this.handleTypeDropStatement(metadataProvider, stmt);
                        continue block36;
                    }
                    case NODEGROUP_DROP: {
                        this.handleNodegroupDropStatement(metadataProvider, stmt);
                        continue block36;
                    }
                    case CREATE_FUNCTION: {
                        this.handleCreateFunctionStatement(metadataProvider, stmt);
                        continue block36;
                    }
                    case FUNCTION_DROP: {
                        this.handleFunctionDropStatement(metadataProvider, stmt);
                        continue block36;
                    }
                    case LOAD: {
                        this.handleLoadStatement(metadataProvider, stmt, hcc);
                        continue block36;
                    }
                    case INSERT: 
                    case UPSERT: {
                        if (((InsertStatement)stmt).getReturnExpression() != null) {
                            metadataProvider.setResultSetId(new ResultSetId((long)resultSetIdCounter++));
                            metadataProvider.setResultAsyncMode(resultDelivery == IStatementExecutor.ResultDelivery.ASYNC || resultDelivery == IStatementExecutor.ResultDelivery.DEFERRED);
                            metadataProvider.setMaxResultReads(maxResultReads);
                        }
                        this.handleInsertUpsertStatement(metadataProvider, stmt, hcc, hdc, resultDelivery, outMetadata, stats, false, clientContextId);
                        continue block36;
                    }
                    case DELETE: {
                        this.handleDeleteStatement(metadataProvider, stmt, hcc, false);
                        continue block36;
                    }
                    case CREATE_FEED: {
                        this.handleCreateFeedStatement(metadataProvider, stmt);
                        continue block36;
                    }
                    case DROP_FEED: {
                        this.handleDropFeedStatement(metadataProvider, stmt, hcc);
                        continue block36;
                    }
                    case DROP_FEED_POLICY: {
                        this.handleDropFeedPolicyStatement(metadataProvider, stmt);
                        continue block36;
                    }
                    case CONNECT_FEED: {
                        this.handleConnectFeedStatement(metadataProvider, stmt);
                        continue block36;
                    }
                    case DISCONNECT_FEED: {
                        this.handleDisconnectFeedStatement(metadataProvider, stmt);
                        continue block36;
                    }
                    case START_FEED: {
                        this.handleStartFeedStatement(metadataProvider, stmt, hcc);
                        continue block36;
                    }
                    case STOP_FEED: {
                        this.handleStopFeedStatement(metadataProvider, stmt);
                        continue block36;
                    }
                    case CREATE_FEED_POLICY: {
                        this.handleCreateFeedPolicyStatement(metadataProvider, stmt);
                        continue block36;
                    }
                    case QUERY: {
                        metadataProvider.setResultSetId(new ResultSetId((long)resultSetIdCounter++));
                        metadataProvider.setResultAsyncMode(resultDelivery == IStatementExecutor.ResultDelivery.ASYNC || resultDelivery == IStatementExecutor.ResultDelivery.DEFERRED);
                        metadataProvider.setMaxResultReads(maxResultReads);
                        this.handleQuery(metadataProvider, (Query)stmt, hcc, hdc, resultDelivery, outMetadata, stats, clientContextId, ctx);
                        continue block36;
                    }
                    case COMPACT: {
                        this.handleCompactStatement(metadataProvider, stmt, hcc);
                        continue block36;
                    }
                    case EXTERNAL_DATASET_REFRESH: {
                        this.handleExternalDatasetRefreshStatement(metadataProvider, stmt, hcc);
                        continue block36;
                    }
                    case WRITE: {
                        Pair<IAWriterFactory, FileSplit> result = this.handleWriteStatement(stmt);
                        writerFactory = result.first != null ? (IAWriterFactory)result.first : writerFactory;
                        outputFile = (FileSplit)result.second;
                        continue block36;
                    }
                    case FUNCTION_DECL: {
                        continue block36;
                    }
                    case EXTENSION: {
                        ((ExtensionStatement)stmt).handle(hcc, (IStatementExecutor)this, requestParameters, metadataProvider, resultSetIdCounter);
                        continue block36;
                    }
                }
                throw new CompilationException("Unknown function");
            }
        }
        finally {
            Thread.currentThread().setName(threadName);
        }
    }

    protected void handleSetStatement(Statement stmt, Map<String, String> config) {
        SetStatement ss = (SetStatement)stmt;
        String pname = ss.getPropName();
        String pvalue = ss.getPropValue();
        config.put(pname, pvalue);
    }

    protected Pair<IAWriterFactory, FileSplit> handleWriteStatement(Statement stmt) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        WriteStatement ws = (WriteStatement)stmt;
        File f = new File(ws.getFileName());
        UnmanagedFileSplit outputFile = new UnmanagedFileSplit(ws.getNcName().getValue(), f.getPath());
        IAWriterFactory writerFactory = null;
        if (ws.getWriterClassName() != null) {
            writerFactory = (IAWriterFactory)Class.forName(ws.getWriterClassName()).newInstance();
        }
        return new Pair(writerFactory, (Object)outputFile);
    }

    protected Dataverse handleUseDataverseStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        DataverseDecl dvd = (DataverseDecl)stmt;
        String dvName = dvd.getDataverseName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        this.lockManager.acquireDataverseReadLock(metadataProvider.getLocks(), dvName);
        try {
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(metadataProvider.getMetadataTxnContext(), dvName);
            if (dv == null) {
                throw new MetadataException("Unknown dataverse " + dvName);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            Dataverse dataverse = dv;
            return dataverse;
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw new MetadataException((Throwable)e);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleCreateDataverseStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        CreateDataverseStatement stmtCreateDataverse = (CreateDataverseStatement)stmt;
        String dvName = stmtCreateDataverse.getDataverseName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        this.lockManager.acquireDataverseReadLock(metadataProvider.getLocks(), dvName);
        try {
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(metadataProvider.getMetadataTxnContext(), dvName);
            if (dv != null) {
                if (stmtCreateDataverse.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new AlgebricksException("A dataverse with this name " + dvName + " already exists.");
            }
            MetadataManager.INSTANCE.addDataverse(metadataProvider.getMetadataTxnContext(), new Dataverse(dvName, stmtCreateDataverse.getFormat(), 0));
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected static void validateCompactionPolicy(String compactionPolicy, Map<String, String> compactionPolicyProperties, MetadataTransactionContext mdTxnCtx, boolean isExternalDataset) throws CompilationException, Exception {
        CompactionPolicy compactionPolicyEntity = MetadataManager.INSTANCE.getCompactionPolicy(mdTxnCtx, "Metadata", compactionPolicy);
        if (compactionPolicyEntity == null) {
            throw new CompilationException("Unknown compaction policy: " + compactionPolicy);
        }
        String compactionPolicyFactoryClassName = compactionPolicyEntity.getClassName();
        ILSMMergePolicyFactory mergePolicyFactory = (ILSMMergePolicyFactory)Class.forName(compactionPolicyFactoryClassName).newInstance();
        if (isExternalDataset && mergePolicyFactory.getName().compareTo("correlated-prefix") == 0) {
            throw new CompilationException("The correlated-prefix merge policy cannot be used with external dataset.");
        }
        if (compactionPolicyProperties == null) {
            if (mergePolicyFactory.getName().compareTo("no-merge") != 0) {
                throw new CompilationException("Compaction policy properties are missing.");
            }
        } else {
            for (Map.Entry<String, String> entry : compactionPolicyProperties.entrySet()) {
                if (mergePolicyFactory.getPropertiesNames().contains(entry.getKey())) continue;
                throw new CompilationException("Invalid compaction policy property: " + entry.getKey());
            }
            for (String p : mergePolicyFactory.getPropertiesNames()) {
                if (compactionPolicyProperties.containsKey(p)) continue;
                throw new CompilationException("Missing compaction policy property: " + p);
            }
        }
    }

    public void handleCreateDatasetStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws CompilationException, Exception {
        MutableObject progress = new MutableObject((Object)JobUtils.ProgressState.NO_PROGRESS);
        DatasetDecl dd = (DatasetDecl)stmt;
        String dataverseName = this.getActiveDataverse(dd.getDataverse());
        String datasetName = dd.getName().getValue();
        DatasetConfig.DatasetType dsType = dd.getDatasetType();
        String itemTypeDataverseName = this.getActiveDataverse(dd.getItemTypeDataverse());
        String itemTypeName = dd.getItemTypeName().getValue();
        String metaItemTypeDataverseName = this.getActiveDataverse(dd.getMetaItemTypeDataverse());
        String metaItemTypeName = dd.getMetaItemTypeName().getValue();
        Identifier ngNameId = dd.getNodegroupName();
        String nodegroupName = ngNameId == null ? null : ngNameId.getValue();
        String compactionPolicy = dd.getCompactionPolicy();
        Map compactionPolicyProperties = dd.getCompactionPolicyProperties();
        boolean defaultCompactionPolicy = compactionPolicy == null;
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        MetadataLockUtil.createDatasetBegin((IMetadataLockManager)this.lockManager, (LockList)metadataProvider.getLocks(), (String)dataverseName, (String)itemTypeDataverseName, (String)(itemTypeDataverseName + "." + itemTypeName), (String)metaItemTypeDataverseName, (String)(metaItemTypeDataverseName + "." + metaItemTypeName), (String)nodegroupName, (String)compactionPolicy, (String)(dataverseName + "." + datasetName), (boolean)defaultCompactionPolicy);
        Dataset dataset = null;
        try {
            String ngName;
            ExternalDatasetDetails datasetDetails = null;
            Dataset ds = metadataProvider.findDataset(dataverseName, datasetName);
            if (ds != null) {
                if (dd.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new AlgebricksException("A dataset with this name " + datasetName + " already exists.");
            }
            Datatype dt = MetadataManager.INSTANCE.getDatatype(metadataProvider.getMetadataTxnContext(), itemTypeDataverseName, itemTypeName);
            if (dt == null) {
                throw new AlgebricksException(": type " + itemTypeName + " could not be found.");
            }
            String string = ngName = ngNameId != null ? ngNameId.getValue() : QueryTranslator.configureNodegroupForDataset(this.appCtx, dd.getHints(), dataverseName, datasetName, metadataProvider);
            if (compactionPolicy == null) {
                compactionPolicy = "prefix";
                compactionPolicyProperties = GlobalConfig.DEFAULT_COMPACTION_POLICY_PROPERTIES;
            } else {
                QueryTranslator.validateCompactionPolicy(compactionPolicy, compactionPolicyProperties, mdTxnCtx, false);
            }
            switch (dd.getDatasetType()) {
                case INTERNAL: {
                    IAType itemType = dt.getDatatype();
                    if (itemType.getTypeTag() != ATypeTag.OBJECT) {
                        throw new AlgebricksException("Dataset type has to be a record type.");
                    }
                    IAType metaItemType = null;
                    if (metaItemTypeDataverseName != null && metaItemTypeName != null) {
                        metaItemType = metadataProvider.findType(metaItemTypeDataverseName, metaItemTypeName);
                    }
                    if (metaItemType != null && metaItemType.getTypeTag() != ATypeTag.OBJECT) {
                        throw new AlgebricksException("Dataset meta type has to be a record type.");
                    }
                    ARecordType metaRecType = (ARecordType)metaItemType;
                    List partitioningExprs = ((InternalDetailsDecl)dd.getDatasetDetailsDecl()).getPartitioningExprs();
                    List keySourceIndicators = ((InternalDetailsDecl)dd.getDatasetDetailsDecl()).getKeySourceIndicators();
                    boolean autogenerated = ((InternalDetailsDecl)dd.getDatasetDetailsDecl()).isAutogenerated();
                    ARecordType aRecordType = (ARecordType)itemType;
                    List partitioningTypes = ValidateUtil.validatePartitioningExpressions((ARecordType)aRecordType, (ARecordType)metaRecType, (List)partitioningExprs, (List)keySourceIndicators, (boolean)autogenerated);
                    List filterField = ((InternalDetailsDecl)dd.getDatasetDetailsDecl()).getFilterField();
                    if (filterField != null) {
                        ValidateUtil.validateFilterField((ARecordType)aRecordType, (List)filterField);
                    }
                    if (compactionPolicy == null && filterField != null) {
                        compactionPolicy = "correlated-prefix";
                        compactionPolicyProperties = GlobalConfig.DEFAULT_COMPACTION_POLICY_PROPERTIES;
                    }
                    datasetDetails = new InternalDatasetDetails(InternalDatasetDetails.FileStructure.BTREE, InternalDatasetDetails.PartitioningStrategy.HASH, partitioningExprs, partitioningExprs, keySourceIndicators, partitioningTypes, autogenerated, filterField);
                    break;
                }
                case EXTERNAL: {
                    String adapter = ((ExternalDetailsDecl)dd.getDatasetDetailsDecl()).getAdapter();
                    Map properties = ((ExternalDetailsDecl)dd.getDatasetDetailsDecl()).getProperties();
                    datasetDetails = new ExternalDatasetDetails(adapter, properties, new Date(), DatasetConfig.TransactionState.COMMIT);
                    break;
                }
                default: {
                    throw new CompilationException("Unknown datatype " + dd.getDatasetType());
                }
            }
            if (!DatasetIdFactory.isInitialized()) {
                DatasetIdFactory.initialize((int)MetadataManager.INSTANCE.getMostRecentDatasetId());
            }
            dataset = new Dataset(dataverseName, datasetName, itemTypeDataverseName, itemTypeName, metaItemTypeDataverseName, metaItemTypeName, ngName, compactionPolicy, compactionPolicyProperties, (IDatasetDetails)datasetDetails, dd.getHints(), dsType, DatasetIdFactory.generateDatasetId(), 1);
            MetadataManager.INSTANCE.addDataset(metadataProvider.getMetadataTxnContext(), dataset);
            if (dd.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                JobSpecification jobSpec = DatasetUtil.createDatasetJobSpec((Dataset)dataset, (MetadataProvider)metadataProvider);
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                progress.setValue((Object)JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA);
                this.runJob(hcc, jobSpec);
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                bActiveTxn = true;
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
            }
            MetadataManager.INSTANCE.dropDataset(metadataProvider.getMetadataTxnContext(), dataverseName, datasetName);
            dataset.setPendingOp(0);
            MetadataManager.INSTANCE.addDataset(metadataProvider.getMetadataTxnContext(), dataset);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            if (progress.getValue() == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                block29: {
                    mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                    bActiveTxn = true;
                    metadataProvider.setMetadataTxnContext(mdTxnCtx);
                    try {
                        JobSpecification jobSpec = DatasetUtil.dropDatasetJobSpec(dataset, (MetadataProvider)metadataProvider);
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                        bActiveTxn = false;
                        this.runJob(hcc, jobSpec);
                    }
                    catch (Exception e2) {
                        e.addSuppressed(e2);
                        if (!bActiveTxn) break block29;
                        QueryTranslator.abort(e, e2, mdTxnCtx);
                    }
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                try {
                    MetadataManager.INSTANCE.dropDataset(metadataProvider.getMetadataTxnContext(), dataverseName, datasetName);
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    throw new IllegalStateException("System is inconsistent state: pending dataset(" + dataverseName + "." + datasetName + ") couldn't be removed from the metadata", e);
                }
            }
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected static void validateIfResourceIsActiveInFeed(ICcApplicationContext appCtx, Dataset dataset) throws CompilationException {
        IActiveEntityEventsListener[] listeners;
        StringBuilder builder = null;
        ActiveNotificationHandler activeEventHandler = (ActiveNotificationHandler)appCtx.getActiveNotificationHandler();
        for (IActiveEntityEventsListener listener : listeners = activeEventHandler.getEventListeners()) {
            if (!listener.isEntityUsingDataset((IDataset)dataset) || !listener.isActive()) continue;
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(listener.getEntityId() + "\n");
        }
        if (builder != null) {
            throw new CompilationException("Dataset " + dataset.getDataverseName() + "." + dataset.getDatasetName() + " is currently being fed into by the following active entities.\n" + builder.toString());
        }
    }

    protected static String configureNodegroupForDataset(ICcApplicationContext appCtx, Map<String, String> hints, String dataverseName, String datasetName, MetadataProvider metadataProvider) throws Exception {
        IClusterStateManager csm = appCtx.getClusterStateManager();
        Set allNodes = csm.getParticipantNodes(true);
        LinkedHashSet selectedNodes = new LinkedHashSet();
        String hintValue = hints.get("NODEGROUP_CARDINALITY");
        if (hintValue == null) {
            selectedNodes.addAll(allNodes);
        } else {
            Pair validation = DatasetHints.validate((ICcApplicationContext)appCtx, (String)"NODEGROUP_CARDINALITY", (String)hints.get("NODEGROUP_CARDINALITY"));
            boolean valid = (Boolean)validation.first;
            if (!valid) {
                throw new CompilationException("Incorrect use of hint 'NODEGROUP_CARDINALITY': " + (String)validation.second);
            }
            int nodegroupCardinality = Integer.parseInt(hints.get("NODEGROUP_CARDINALITY"));
            ArrayList allNodeList = new ArrayList(allNodes);
            Collections.shuffle(allNodeList);
            selectedNodes.addAll(allNodeList.subList(0, nodegroupCardinality));
        }
        return DatasetUtil.createNodeGroupForNewDataset((String)dataverseName, (String)datasetName, selectedNodes, (MetadataProvider)metadataProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCreateIndexStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        CreateIndexStatement stmtCreateIndex = (CreateIndexStatement)stmt;
        String dataverseName = this.getActiveDataverse(stmtCreateIndex.getDataverseName());
        String datasetName = stmtCreateIndex.getDatasetName().getValue();
        String indexName = stmtCreateIndex.getIndexName().getValue();
        List keySourceIndicators = stmtCreateIndex.getFieldSourceIndicators();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        String datasetFullyQualifiedName = dataverseName + "." + datasetName;
        Dataset ds = null;
        Index index = null;
        MetadataLockUtil.createIndexBegin((IMetadataLockManager)this.lockManager, (LockList)metadataProvider.getLocks(), (String)dataverseName, (String)datasetFullyQualifiedName);
        try {
            ds = metadataProvider.findDataset(dataverseName, datasetName);
            if (ds == null) {
                throw new AlgebricksException("There is no dataset with this name " + datasetName + " in dataverse " + dataverseName);
            }
            index = MetadataManager.INSTANCE.getIndex(metadataProvider.getMetadataTxnContext(), dataverseName, datasetName, indexName);
            if (index != null) {
                if (stmtCreateIndex.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new AlgebricksException("An index with this name " + indexName + " already exists.");
            }
            if (ds.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL && stmtCreateIndex.getFieldExprs().isEmpty()) {
                throw new AsterixException(1053, new Serializable[0]);
            }
            Datatype dt = MetadataManager.INSTANCE.getDatatype(metadataProvider.getMetadataTxnContext(), ds.getItemTypeDataverseName(), ds.getItemTypeName());
            ARecordType aRecordType = (ARecordType)dt.getDatatype();
            ARecordType metaRecordType = null;
            if (ds.hasMetaPart()) {
                Datatype metaDt = MetadataManager.INSTANCE.getDatatype(metadataProvider.getMetadataTxnContext(), ds.getMetaItemTypeDataverseName(), ds.getMetaItemTypeName());
                metaRecordType = (ARecordType)metaDt.getDatatype();
            }
            ArrayList<List<String>> indexFields = new ArrayList<List<String>>();
            ArrayList<IAType> indexFieldTypes = new ArrayList<IAType>();
            int keyIndex = 0;
            boolean overridesFieldTypes = false;
            HashSet<Pair> indexKeysSet = new HashSet<Pair>();
            for (Pair fieldExpr : stmtCreateIndex.getFieldExprs()) {
                int i;
                IAType fieldType = null;
                ARecordType subType = KeyFieldTypeUtil.chooseSource((List)keySourceIndicators, (int)keyIndex, (ARecordType)aRecordType, (ARecordType)metaRecordType);
                boolean isOpen = subType.isOpen();
                if (((List)fieldExpr.first).size() > 1 && !isOpen) {
                    for (i = 0; i < ((List)fieldExpr.first).size() - 1 && !isOpen; ++i) {
                        subType = (ARecordType)subType.getFieldType((String)((List)fieldExpr.first).get(i));
                        isOpen = subType.isOpen();
                    }
                }
                if (fieldExpr.second == null) {
                    fieldType = subType.getSubFieldType(((List)fieldExpr.first).subList(i, ((List)fieldExpr.first).size()));
                } else {
                    if (!stmtCreateIndex.isEnforced() && stmtCreateIndex.getIndexType() != DatasetConfig.IndexType.BTREE) {
                        throw new AsterixException(1042, new Serializable[]{stmtCreateIndex.getIndexType()});
                    }
                    if (stmtCreateIndex.isEnforced() && !((IndexedTypeExpression)fieldExpr.second).isUnknownable()) {
                        throw new AsterixException(1041, new Serializable[]{String.valueOf(fieldExpr.first)});
                    }
                    if (stmtCreateIndex.isEnforced() && subType.getSubFieldType(((List)fieldExpr.first).subList(i, ((List)fieldExpr.first).size())) != null) {
                        throw new AsterixException(1051, new Serializable[]{String.valueOf(fieldExpr.first)});
                    }
                    if (!isOpen) {
                        throw new AlgebricksException("Typed index on \"" + fieldExpr.first + "\" field could be created only for open datatype");
                    }
                    if (stmtCreateIndex.hasMetaField()) {
                        throw new AlgebricksException("Typed open index can only be created on the record part");
                    }
                    Map typeMap = TypeTranslator.computeTypes((MetadataTransactionContext)mdTxnCtx, (TypeExpression)((IndexedTypeExpression)fieldExpr.second).getType(), (String)indexName, (String)dataverseName);
                    TypeSignature typeSignature = new TypeSignature(dataverseName, indexName);
                    fieldType = (IAType)typeMap.get(typeSignature);
                    overridesFieldTypes = true;
                }
                if (fieldType == null) {
                    throw new AlgebricksException("Unknown type " + (fieldExpr.second == null ? fieldExpr.first : fieldExpr.second));
                }
                if (!indexKeysSet.add(new Pair(fieldExpr.first, stmtCreateIndex.getFieldSourceIndicators().get(keyIndex)))) {
                    throw new AsterixException(1052, new Serializable[]{String.valueOf(fieldExpr.first)});
                }
                indexFields.add((List<String>)fieldExpr.first);
                indexFieldTypes.add(fieldType);
                ++keyIndex;
            }
            this.validateIndexKeyFields(stmtCreateIndex, keySourceIndicators, aRecordType, metaRecordType, indexFields, indexFieldTypes);
            if (stmtCreateIndex.getIndexType() == DatasetConfig.IndexType.SINGLE_PARTITION_WORD_INVIX || stmtCreateIndex.getIndexType() == DatasetConfig.IndexType.SINGLE_PARTITION_NGRAM_INVIX || stmtCreateIndex.getIndexType() == DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX || stmtCreateIndex.getIndexType() == DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX) {
                List partitioningKeys = ds.getPrimaryKeys();
                for (List partitioningKey : partitioningKeys) {
                    IAType keyType = aRecordType.getSubFieldType(partitioningKey);
                    ITypeTraits typeTrait = TypeTraitProvider.INSTANCE.getTypeTrait((Object)keyType);
                    if (typeTrait.getFixedLength() >= 0) continue;
                    throw new AlgebricksException("The keyword or ngram index -" + indexName + " cannot be created on the dataset -" + datasetName + " due to its variable-length primary key field - " + partitioningKey);
                }
            }
            Index newIndex = new Index(dataverseName, datasetName, indexName, stmtCreateIndex.getIndexType(), indexFields, keySourceIndicators, indexFieldTypes, stmtCreateIndex.getGramLength(), overridesFieldTypes, stmtCreateIndex.isEnforced(), false, 1);
            QueryTranslator.doCreateIndex(hcc, metadataProvider, ds, newIndex, this.jobFlags);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    public static void doCreateIndex(IHyracksClientConnection hcc, MetadataProvider metadataProvider, Dataset ds, Index index, EnumSet<JobFlag> jobFlags) throws Exception {
        JobUtils.ProgressState progress = JobUtils.ProgressState.NO_PROGRESS;
        boolean bActiveTxn = true;
        Index filesIndex = null;
        boolean firstExternalDatasetIndex = false;
        boolean datasetLocked = false;
        MetadataTransactionContext mdTxnCtx = metadataProvider.getMetadataTxnContext();
        boolean filesIndexReplicated = false;
        try {
            JobSpecification spec;
            index.setPendingOp(1);
            if (ds.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                QueryTranslator.validateIfResourceIsActiveInFeed(metadataProvider.getApplicationContext(), ds);
            } else {
                if (!ExternalIndexingOperations.isIndexible((ExternalDatasetDetails)((ExternalDatasetDetails)ds.getDatasetDetails()))) {
                    throw new AlgebricksException("dataset using " + ((ExternalDatasetDetails)ds.getDatasetDetails()).getAdapter() + " Adapter can't be indexed");
                }
                if (!ExternalIndexingOperations.isValidIndexName((String)index.getDatasetName(), (String)index.getIndexName())) {
                    throw new AlgebricksException("external dataset index name is invalid");
                }
                filesIndex = MetadataManager.INSTANCE.getIndex(metadataProvider.getMetadataTxnContext(), index.getDataverseName(), index.getDatasetName(), IndexingConstants.getFilesIndexName((String)index.getDatasetName()));
                firstExternalDatasetIndex = filesIndex == null;
                ExternalDatasetsRegistry.INSTANCE.buildIndexBegin(ds, firstExternalDatasetIndex);
                datasetLocked = true;
                if (firstExternalDatasetIndex && (filesIndex = MetadataManager.INSTANCE.getIndex(metadataProvider.getMetadataTxnContext(), index.getDataverseName(), index.getDatasetName(), IndexingConstants.getFilesIndexName((String)index.getDatasetName()))) != null) {
                    ExternalDatasetsRegistry.INSTANCE.buildIndexEnd(ds, firstExternalDatasetIndex);
                    firstExternalDatasetIndex = false;
                    ExternalDatasetsRegistry.INSTANCE.buildIndexBegin(ds, firstExternalDatasetIndex);
                }
                if (firstExternalDatasetIndex) {
                    List externalFilesSnapshot = ExternalIndexingOperations.getSnapshotFromExternalFileSystem((Dataset)ds);
                    filesIndex = new Index(index.getDataverseName(), index.getDatasetName(), IndexingConstants.getFilesIndexName((String)index.getDatasetName()), DatasetConfig.IndexType.BTREE, ExternalIndexingOperations.FILE_INDEX_FIELD_NAMES, null, ExternalIndexingOperations.FILE_INDEX_FIELD_TYPES, false, false, false, 1);
                    MetadataManager.INSTANCE.addIndex(metadataProvider.getMetadataTxnContext(), filesIndex);
                    for (ExternalFile file : externalFilesSnapshot) {
                        MetadataManager.INSTANCE.addExternalFile(mdTxnCtx, file);
                    }
                    spec = ExternalIndexingOperations.buildFilesIndexCreateJobSpec((Dataset)ds, (List)externalFilesSnapshot, (MetadataProvider)metadataProvider);
                    if (spec == null) {
                        throw new CompilationException("Failed to create job spec for replicating Files Index For external dataset");
                    }
                    filesIndexReplicated = true;
                    QueryTranslator.runJob(hcc, spec, jobFlags);
                }
            }
            if (index.isEnforced()) {
                List indexes = MetadataManager.INSTANCE.getDatasetIndexes(metadataProvider.getMetadataTxnContext(), index.getDataverseName(), index.getDatasetName());
                for (Index existingIndex : indexes) {
                    if (!existingIndex.getKeyFieldNames().equals(index.getKeyFieldNames()) || existingIndex.getKeyFieldTypes().equals(index.getKeyFieldTypes()) || !existingIndex.isEnforced()) continue;
                    throw new CompilationException("Cannot create index " + index.getIndexName() + " , enforced index " + existingIndex.getIndexName() + " on field \"" + StringUtils.join((Iterable)index.getKeyFieldNames(), (char)',') + "\" is already defined with type \"" + existingIndex.getKeyFieldTypes() + "\"");
                }
            }
            MetadataManager.INSTANCE.addIndex(metadataProvider.getMetadataTxnContext(), index);
            spec = IndexUtil.buildSecondaryIndexCreationJobSpec((Dataset)ds, (Index)index, (MetadataProvider)metadataProvider);
            if (spec == null) {
                throw new CompilationException("Failed to create job spec for creating index '" + ds.getDatasetName() + "." + index.getIndexName() + "'");
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            progress = JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA;
            QueryTranslator.runJob(hcc, spec, jobFlags);
            if (ds.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                FlushDatasetUtil.flushDataset(hcc, metadataProvider, index.getDataverseName(), index.getDatasetName());
            }
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            spec = IndexUtil.buildSecondaryIndexLoadingJobSpec((Dataset)ds, (Index)index, (MetadataProvider)metadataProvider);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            QueryTranslator.runJob(hcc, spec, jobFlags);
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), index.getDataverseName(), index.getDatasetName(), index.getIndexName());
            index.setPendingOp(0);
            MetadataManager.INSTANCE.addIndex(metadataProvider.getMetadataTxnContext(), index);
            if (firstExternalDatasetIndex) {
                MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), index.getDataverseName(), index.getDatasetName(), filesIndex.getIndexName());
                filesIndex.setPendingOp(0);
                MetadataManager.INSTANCE.addIndex(metadataProvider.getMetadataTxnContext(), filesIndex);
                ((ExternalDatasetDetails)ds.getDatasetDetails()).setRefreshTimestamp(new Date());
                MetadataManager.INSTANCE.updateDataset(mdTxnCtx, ds);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            JobSpecification jobSpec;
            block34: {
                if (bActiveTxn) {
                    QueryTranslator.abort(e, e, mdTxnCtx);
                }
                if (filesIndexReplicated) {
                    mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                    bActiveTxn = true;
                    try {
                        jobSpec = ExternalIndexingOperations.buildDropFilesIndexJobSpec((MetadataProvider)metadataProvider, (Dataset)ds);
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                        bActiveTxn = false;
                        QueryTranslator.runJob(hcc, jobSpec, jobFlags);
                    }
                    catch (Exception e2) {
                        e.addSuppressed(e2);
                        if (!bActiveTxn) break block34;
                        QueryTranslator.abort(e, e2, mdTxnCtx);
                    }
                }
            }
            if (progress == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                block35: {
                    mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                    bActiveTxn = true;
                    metadataProvider.setMetadataTxnContext(mdTxnCtx);
                    try {
                        jobSpec = IndexUtil.buildDropIndexJobSpec((Index)index, (MetadataProvider)metadataProvider, (Dataset)ds);
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                        bActiveTxn = false;
                        QueryTranslator.runJob(hcc, jobSpec, jobFlags);
                    }
                    catch (Exception e2) {
                        e.addSuppressed(e2);
                        if (!bActiveTxn) break block35;
                        QueryTranslator.abort(e, e2, mdTxnCtx);
                    }
                }
                if (firstExternalDatasetIndex) {
                    mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                    metadataProvider.setMetadataTxnContext(mdTxnCtx);
                    try {
                        MetadataManager.INSTANCE.dropDatasetExternalFiles(mdTxnCtx, ds);
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    }
                    catch (Exception e2) {
                        e.addSuppressed(e2);
                        QueryTranslator.abort(e, e2, mdTxnCtx);
                        throw new IllegalStateException("System is inconsistent state: pending files for(" + index.getDataverseName() + "." + index.getDatasetName() + ") couldn't be removed from the metadata", e);
                    }
                    mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                    metadataProvider.setMetadataTxnContext(mdTxnCtx);
                    try {
                        MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), index.getDataverseName(), index.getDatasetName(), IndexingConstants.getFilesIndexName((String)index.getDatasetName()));
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    }
                    catch (Exception e2) {
                        e.addSuppressed(e2);
                        QueryTranslator.abort(e, e2, mdTxnCtx);
                        throw new IllegalStateException("System is inconsistent state: pending index(" + index.getDataverseName() + "." + index.getDatasetName() + "." + IndexingConstants.getFilesIndexName((String)index.getDatasetName()) + ") couldn't be removed from the metadata", e);
                    }
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                try {
                    MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), index.getDataverseName(), index.getDatasetName(), index.getIndexName());
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    throw new IllegalStateException("System is in inconsistent state: pending index(" + index.getDataverseName() + "." + index.getDatasetName() + "." + index.getIndexName() + ") couldn't be removed from the metadata", e);
                }
            }
            throw e;
        }
        finally {
            if (datasetLocked) {
                ExternalDatasetsRegistry.INSTANCE.buildIndexEnd(ds, firstExternalDatasetIndex);
            }
        }
    }

    protected void validateIndexKeyFields(CreateIndexStatement stmtCreateIndex, List<Integer> keySourceIndicators, ARecordType aRecordType, ARecordType metaRecordType, List<List<String>> indexFields, List<IAType> indexFieldTypes) throws AlgebricksException {
        ValidateUtil.validateKeyFields((ARecordType)aRecordType, (ARecordType)metaRecordType, indexFields, keySourceIndicators, indexFieldTypes, (DatasetConfig.IndexType)stmtCreateIndex.getIndexType());
    }

    protected void handleCreateTypeStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        TypeDecl stmtCreateType = (TypeDecl)stmt;
        String dataverseName = this.getActiveDataverse(stmtCreateType.getDataverseName());
        String typeName = stmtCreateType.getIdent().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        MetadataLockUtil.createTypeBegin((IMetadataLockManager)this.lockManager, (LockList)metadataProvider.getLocks(), (String)dataverseName, (String)(dataverseName + "." + typeName));
        try {
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, dataverseName);
            if (dv == null) {
                throw new AlgebricksException("Unknown dataverse " + dataverseName);
            }
            Datatype dt = MetadataManager.INSTANCE.getDatatype(mdTxnCtx, dataverseName, typeName);
            if (dt != null) {
                if (!stmtCreateType.getIfNotExists()) {
                    throw new AlgebricksException("A datatype with this name " + typeName + " already exists.");
                }
            } else {
                if (BuiltinTypeMap.getBuiltinType((String)typeName) != null) {
                    throw new AlgebricksException("Cannot redefine builtin type " + typeName + ".");
                }
                Map typeMap = TypeTranslator.computeTypes((MetadataTransactionContext)mdTxnCtx, (TypeExpression)stmtCreateType.getTypeDef(), (String)stmtCreateType.getIdent().getValue(), (String)dataverseName);
                TypeSignature typeSignature = new TypeSignature(dataverseName, typeName);
                IAType type = (IAType)typeMap.get(typeSignature);
                MetadataManager.INSTANCE.addDatatype(mdTxnCtx, new Datatype(dataverseName, typeName, type, false));
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleDataverseDropStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        DataverseDropStatement stmtDelete = (DataverseDropStatement)stmt;
        String dataverseName = stmtDelete.getDataverseName().getValue();
        if (dataverseName.equals("Default")) {
            throw new HyracksDataException("Default dataverse can't be dropped");
        }
        JobUtils.ProgressState progress = JobUtils.ProgressState.NO_PROGRESS;
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        ArrayList<JobSpecification> jobsToExecute = new ArrayList<JobSpecification>();
        this.lockManager.acquireDataverseWriteLock(metadataProvider.getLocks(), dataverseName);
        try {
            IActiveEntityEventsListener[] activeListeners;
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, dataverseName);
            if (dv == null) {
                if (stmtDelete.getIfExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new AlgebricksException("There is no dataverse with this name " + dataverseName + ".");
            }
            List functionsInDataverse = MetadataManager.INSTANCE.getDataverseFunctions(mdTxnCtx, dataverseName);
            for (Function function : functionsInDataverse) {
                if (!this.isFunctionUsed(mdTxnCtx, function.getSignature(), dataverseName)) continue;
                throw new MetadataException(3109, new Serializable[]{function.getDataverseName() + "." + function.getName() + "@" + function.getArity()});
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            ActiveNotificationHandler activeEventHandler = (ActiveNotificationHandler)this.appCtx.getActiveNotificationHandler();
            for (IActiveEntityEventsListener listener : activeListeners = activeEventHandler.getEventListeners()) {
                EntityId activeEntityId = listener.getEntityId();
                if (!activeEntityId.getExtensionName().equals("Feed") || !activeEntityId.getDataverse().equals(dataverseName)) continue;
                if (listener.getState() != ActivityState.STOPPED) {
                    ((ActiveEntityEventsListener)listener).stop(metadataProvider);
                }
                FeedEventsListener feedListener = (FeedEventsListener)listener;
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                bActiveTxn = true;
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                this.doDropFeed(hcc, metadataProvider, feedListener.getFeed());
                MetadataManager.INSTANCE.commitTransaction(metadataProvider.getMetadataTxnContext());
                bActiveTxn = false;
            }
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            List datasets = MetadataManager.INSTANCE.getDataverseDatasets(mdTxnCtx, dataverseName);
            for (Dataset dataset : datasets) {
                List indexes;
                String datasetName = dataset.getDatasetName();
                DatasetConfig.DatasetType dsType = dataset.getDatasetType();
                if (dsType == DatasetConfig.DatasetType.INTERNAL) {
                    indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataverseName, datasetName);
                    for (Index index : indexes) {
                        jobsToExecute.add(IndexUtil.buildDropIndexJobSpec((Index)index, (MetadataProvider)metadataProvider, (Dataset)dataset));
                    }
                    continue;
                }
                indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataverseName, datasetName);
                for (int k = 0; k < indexes.size(); ++k) {
                    if (ExternalIndexingOperations.isFileIndex((Index)((Index)indexes.get(k)))) {
                        jobsToExecute.add(ExternalIndexingOperations.buildDropFilesIndexJobSpec((MetadataProvider)metadataProvider, (Dataset)dataset));
                        continue;
                    }
                    jobsToExecute.add(IndexUtil.buildDropIndexJobSpec((Index)((Index)indexes.get(k)), (MetadataProvider)metadataProvider, (Dataset)dataset));
                }
                ExternalDatasetsRegistry.INSTANCE.removeDatasetInfo(dataset);
            }
            jobsToExecute.add(DataverseUtil.dropDataverseJobSpec(dv, metadataProvider));
            MetadataManager.INSTANCE.dropDataverse(mdTxnCtx, dataverseName);
            MetadataManager.INSTANCE.addDataverse(mdTxnCtx, new Dataverse(dataverseName, dv.getDataFormat(), 2));
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            progress = JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA;
            for (JobSpecification jobSpec : jobsToExecute) {
                this.runJob(hcc, jobSpec);
            }
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            MetadataManager.INSTANCE.dropDataverse(mdTxnCtx, dataverseName);
            for (Dataset dataset : datasets) {
                String nodeGroup = dataset.getNodeGroupName();
                this.lockManager.acquireNodeGroupWriteLock(metadataProvider.getLocks(), nodeGroup);
                if (MetadataManager.INSTANCE.getNodegroup(mdTxnCtx, nodeGroup) == null) continue;
                MetadataManager.INSTANCE.dropNodegroup(mdTxnCtx, nodeGroup, true);
            }
            if (this.activeDataverse != null && this.activeDataverse.getDataverseName() == dataverseName) {
                this.activeDataverse = null;
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            if (progress == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                if (this.activeDataverse != null && this.activeDataverse.getDataverseName() == dataverseName) {
                    this.activeDataverse = null;
                }
                try {
                    for (JobSpecification jobSpec : jobsToExecute) {
                        this.runJob(hcc, jobSpec);
                    }
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                try {
                    MetadataManager.INSTANCE.dropDataverse(mdTxnCtx, dataverseName);
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    throw new IllegalStateException("System is inconsistent state: pending dataverse(" + dataverseName + ") couldn't be removed from the metadata", e);
                }
            }
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
            ExternalDatasetsRegistry.INSTANCE.releaseAcquiredLocks(metadataProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDatasetDropStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        DropDatasetStatement stmtDelete = (DropDatasetStatement)stmt;
        String dataverseName = this.getActiveDataverse(stmtDelete.getDataverseName());
        String datasetName = stmtDelete.getDatasetName().getValue();
        MetadataLockUtil.dropDatasetBegin((IMetadataLockManager)this.lockManager, (LockList)metadataProvider.getLocks(), (String)dataverseName, (String)(dataverseName + "." + datasetName));
        try {
            QueryTranslator.doDropDataset(dataverseName, datasetName, metadataProvider, stmtDelete.getIfExists(), hcc, true);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    public static void doDropDataset(String dataverseName, String datasetName, MetadataProvider metadataProvider, boolean ifExists, IHyracksClientConnection hcc, boolean dropCorrespondingNodeGroup) throws Exception {
        MutableObject progress = new MutableObject((Object)JobUtils.ProgressState.NO_PROGRESS);
        MutableObject mdTxnCtx = new MutableObject((Object)MetadataManager.INSTANCE.beginTransaction());
        MutableBoolean bActiveTxn = new MutableBoolean(true);
        metadataProvider.setMetadataTxnContext((MetadataTransactionContext)mdTxnCtx.getValue());
        ArrayList jobsToExecute = new ArrayList();
        try {
            Dataset ds = metadataProvider.findDataset(dataverseName, datasetName);
            if (ds == null) {
                if (ifExists) {
                    MetadataManager.INSTANCE.commitTransaction((MetadataTransactionContext)mdTxnCtx.getValue());
                    return;
                }
                throw new AsterixException(1050, new Serializable[]{dataverseName, datasetName});
            }
            ds.drop(metadataProvider, mdTxnCtx, jobsToExecute, bActiveTxn, progress, hcc, dropCorrespondingNodeGroup);
            MetadataManager.INSTANCE.commitTransaction((MetadataTransactionContext)mdTxnCtx.getValue());
        }
        catch (Exception e) {
            if (bActiveTxn.booleanValue()) {
                QueryTranslator.abort(e, e, (MetadataTransactionContext)mdTxnCtx.getValue());
            }
            if (progress.getValue() == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                try {
                    for (JobSpecification jobSpec : jobsToExecute) {
                        JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, (boolean)true);
                    }
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
                mdTxnCtx.setValue((Object)MetadataManager.INSTANCE.beginTransaction());
                metadataProvider.setMetadataTxnContext((MetadataTransactionContext)mdTxnCtx.getValue());
                try {
                    MetadataManager.INSTANCE.dropDataset(metadataProvider.getMetadataTxnContext(), dataverseName, datasetName);
                    MetadataManager.INSTANCE.commitTransaction((MetadataTransactionContext)mdTxnCtx.getValue());
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, (MetadataTransactionContext)mdTxnCtx.getValue());
                    throw new IllegalStateException("System is inconsistent state: pending dataset(" + dataverseName + "." + datasetName + ") couldn't be removed from the metadata", e);
                }
            }
            throw e;
        }
        finally {
            ExternalDatasetsRegistry.INSTANCE.releaseAcquiredLocks(metadataProvider);
        }
    }

    protected void handleIndexDropStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IRequestParameters requestParameters) throws Exception {
        IndexDropStatement stmtIndexDrop = (IndexDropStatement)stmt;
        String datasetName = stmtIndexDrop.getDatasetName().getValue();
        String dataverseName = this.getActiveDataverse(stmtIndexDrop.getDataverseName());
        String indexName = stmtIndexDrop.getIndexName().getValue();
        JobUtils.ProgressState progress = JobUtils.ProgressState.NO_PROGRESS;
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        ArrayList<JobSpecification> jobsToExecute = new ArrayList<JobSpecification>();
        String dsFullyQualifiedName = dataverseName + "." + datasetName;
        MetadataLockUtil.dropIndexBegin((IMetadataLockManager)this.lockManager, (LockList)metadataProvider.getLocks(), (String)dataverseName, (String)dsFullyQualifiedName);
        boolean dropFilesIndex = false;
        try {
            Index index;
            Dataset ds = metadataProvider.findDataset(dataverseName, datasetName);
            if (ds == null) {
                throw new AlgebricksException("There is no dataset with this name " + datasetName + " in dataverse " + dataverseName);
            }
            ActiveNotificationHandler activeEventHandler = (ActiveNotificationHandler)this.appCtx.getActiveNotificationHandler();
            IActiveEntityEventsListener[] listeners = activeEventHandler.getEventListeners();
            StringBuilder builder = null;
            for (IActiveEntityEventsListener listener : listeners) {
                if (!listener.isEntityUsingDataset((IDataset)ds)) continue;
                if (builder == null) {
                    builder = new StringBuilder();
                }
                builder.append(new FeedConnectionId(listener.getEntityId(), datasetName) + "\n");
            }
            if (builder != null) {
                throw new CompilationException("Dataset" + datasetName + " is currently being fed into by the following active entities: " + builder.toString());
            }
            if (ds.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                index = MetadataManager.INSTANCE.getIndex(mdTxnCtx, dataverseName, datasetName, indexName);
                if (index == null) {
                    if (stmtIndexDrop.getIfExists()) {
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                        return;
                    }
                    throw new AlgebricksException("There is no index with this name " + indexName + ".");
                }
                this.ensureNonPrimaryIndexDrop(index);
                jobsToExecute.add(IndexUtil.buildDropIndexJobSpec((Index)index, (MetadataProvider)metadataProvider, (Dataset)ds));
                MetadataManager.INSTANCE.dropIndex(mdTxnCtx, dataverseName, datasetName, indexName);
                MetadataManager.INSTANCE.addIndex(mdTxnCtx, new Index(dataverseName, datasetName, indexName, index.getIndexType(), index.getKeyFieldNames(), index.getKeyFieldSourceIndicators(), index.getKeyFieldTypes(), index.isOverridingKeyFieldTypes(), index.isEnforced(), index.isPrimaryIndex(), 2));
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                progress = JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA;
                for (JobSpecification jobSpec : jobsToExecute) {
                    this.runJob(hcc, jobSpec);
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                bActiveTxn = true;
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                MetadataManager.INSTANCE.dropIndex(mdTxnCtx, dataverseName, datasetName, indexName);
            } else {
                indexName = stmtIndexDrop.getIndexName().getValue();
                index = MetadataManager.INSTANCE.getIndex(mdTxnCtx, dataverseName, datasetName, indexName);
                if (index == null) {
                    if (stmtIndexDrop.getIfExists()) {
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                        return;
                    }
                    throw new AlgebricksException("There is no index with this name " + indexName + ".");
                }
                if (ExternalIndexingOperations.isFileIndex((Index)index)) {
                    throw new AlgebricksException("Dropping a dataset's files index is not allowed.");
                }
                this.ensureNonPrimaryIndexDrop(index);
                jobsToExecute.add(IndexUtil.buildDropIndexJobSpec((Index)index, (MetadataProvider)metadataProvider, (Dataset)ds));
                List datasetIndexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataverseName, datasetName);
                if (datasetIndexes.size() == 2) {
                    dropFilesIndex = true;
                    for (Index externalIndex : datasetIndexes) {
                        if (!ExternalIndexingOperations.isFileIndex((Index)externalIndex)) continue;
                        jobsToExecute.add(ExternalIndexingOperations.buildDropFilesIndexJobSpec((MetadataProvider)metadataProvider, (Dataset)ds));
                        MetadataManager.INSTANCE.dropIndex(mdTxnCtx, dataverseName, datasetName, externalIndex.getIndexName());
                        MetadataManager.INSTANCE.addIndex(mdTxnCtx, new Index(dataverseName, datasetName, externalIndex.getIndexName(), externalIndex.getIndexType(), externalIndex.getKeyFieldNames(), externalIndex.getKeyFieldSourceIndicators(), index.getKeyFieldTypes(), index.isOverridingKeyFieldTypes(), index.isEnforced(), externalIndex.isPrimaryIndex(), 2));
                    }
                }
                MetadataManager.INSTANCE.dropIndex(mdTxnCtx, dataverseName, datasetName, indexName);
                MetadataManager.INSTANCE.addIndex(mdTxnCtx, new Index(dataverseName, datasetName, indexName, index.getIndexType(), index.getKeyFieldNames(), index.getKeyFieldSourceIndicators(), index.getKeyFieldTypes(), index.isOverridingKeyFieldTypes(), index.isEnforced(), index.isPrimaryIndex(), 2));
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                progress = JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA;
                for (JobSpecification jobSpec : jobsToExecute) {
                    this.runJob(hcc, jobSpec);
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                bActiveTxn = true;
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                MetadataManager.INSTANCE.dropIndex(mdTxnCtx, dataverseName, datasetName, indexName);
                if (dropFilesIndex) {
                    MetadataManager.INSTANCE.dropIndex(mdTxnCtx, dataverseName, datasetName, IndexingConstants.getFilesIndexName((String)datasetName));
                    MetadataManager.INSTANCE.dropDatasetExternalFiles(mdTxnCtx, ds);
                    ExternalDatasetsRegistry.INSTANCE.removeDatasetInfo(ds);
                }
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            if (progress == JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA) {
                try {
                    for (JobSpecification jobSpec : jobsToExecute) {
                        this.runJob(hcc, jobSpec);
                    }
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                try {
                    MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), dataverseName, datasetName, indexName);
                    if (dropFilesIndex) {
                        MetadataManager.INSTANCE.dropIndex(metadataProvider.getMetadataTxnContext(), dataverseName, datasetName, IndexingConstants.getFilesIndexName((String)datasetName));
                    }
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    throw new IllegalStateException("System is inconsistent state: pending index(" + dataverseName + "." + datasetName + "." + indexName + ") couldn't be removed from the metadata", e);
                }
            }
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
            ExternalDatasetsRegistry.INSTANCE.releaseAcquiredLocks(metadataProvider);
        }
    }

    protected void handleTypeDropStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        TypeDropStatement stmtTypeDrop = (TypeDropStatement)stmt;
        String dataverseName = this.getActiveDataverse(stmtTypeDrop.getDataverseName());
        String typeName = stmtTypeDrop.getTypeName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        MetadataLockUtil.dropTypeBegin((IMetadataLockManager)this.lockManager, (LockList)metadataProvider.getLocks(), (String)dataverseName, (String)(dataverseName + "." + typeName));
        try {
            Datatype dt = MetadataManager.INSTANCE.getDatatype(mdTxnCtx, dataverseName, typeName);
            if (dt == null) {
                if (!stmtTypeDrop.getIfExists()) {
                    throw new AlgebricksException("There is no datatype with this name " + typeName + ".");
                }
            } else {
                MetadataManager.INSTANCE.dropDatatype(mdTxnCtx, dataverseName, typeName);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleNodegroupDropStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        NodeGroupDropStatement stmtDelete = (NodeGroupDropStatement)stmt;
        String nodegroupName = stmtDelete.getNodeGroupName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        this.lockManager.acquireNodeGroupWriteLock(metadataProvider.getLocks(), nodegroupName);
        try {
            NodeGroup ng = MetadataManager.INSTANCE.getNodegroup(mdTxnCtx, nodegroupName);
            if (ng == null) {
                if (!stmtDelete.getIfExists()) {
                    throw new AlgebricksException("There is no nodegroup with this name " + nodegroupName + ".");
                }
            } else {
                MetadataManager.INSTANCE.dropNodegroup(mdTxnCtx, nodegroupName, false);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleCreateFunctionStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        CreateFunctionStatement cfs = (CreateFunctionStatement)stmt;
        FunctionSignature signature = cfs.getFunctionSignature();
        String dataverse = this.getActiveDataverseName(signature.getNamespace());
        signature.setNamespace(dataverse);
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        MetadataLockUtil.functionStatementBegin((IMetadataLockManager)this.lockManager, (LockList)metadataProvider.getLocks(), (String)dataverse, (String)(dataverse + "." + signature.getName()));
        try {
            Dataverse dv = MetadataManager.INSTANCE.getDataverse(mdTxnCtx, dataverse);
            if (dv == null) {
                throw new AlgebricksException("There is no dataverse with this name " + dataverse + ".");
            }
            metadataProvider.setDefaultDataverse(dv);
            Query wrappedQuery = new Query(false);
            wrappedQuery.setBody(cfs.getFunctionBodyExpression());
            wrappedQuery.setTopLevel(false);
            ArrayList<VarIdentifier> varIds = new ArrayList<VarIdentifier>();
            for (String v : cfs.getParamList()) {
                varIds.add(new VarIdentifier(v));
            }
            wrappedQuery.setExternalVars(varIds);
            this.apiFramework.reWriteQuery(this.declaredFunctions, metadataProvider, (IReturningStatement)wrappedQuery, this.sessionOutput, false);
            List dependencies = FunctionUtil.getFunctionDependencies((IQueryRewriter)this.rewriterFactory.createQueryRewriter(), (Expression)cfs.getFunctionBodyExpression(), (MetadataProvider)metadataProvider);
            String language = this.rewriterFactory instanceof SqlppRewriterFactory ? "SQLPP" : "AQL";
            Function function = new Function(signature, cfs.getParamList(), "VOID", cfs.getFunctionBody(), language, AbstractFunctionCallExpression.FunctionKind.SCALAR.toString(), dependencies);
            MetadataManager.INSTANCE.addFunction(mdTxnCtx, function);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
            metadataProvider.setDefaultDataverse(this.activeDataverse);
        }
    }

    protected boolean isFunctionUsed(MetadataTransactionContext ctx, FunctionSignature signature, String currentDataverse) throws AlgebricksException {
        List allDataverses = MetadataManager.INSTANCE.getDataverses(ctx);
        for (Dataverse dataverse : allDataverses) {
            if (currentDataverse != null && dataverse.getDataverseName().equals(currentDataverse)) continue;
            List feeds = MetadataManager.INSTANCE.getFeeds(ctx, dataverse.getDataverseName());
            for (Feed feed : feeds) {
                List feedConnections = MetadataManager.INSTANCE.getFeedConections(ctx, dataverse.getDataverseName(), feed.getFeedName());
                for (FeedConnection conn : feedConnections) {
                    if (!conn.containsFunction(signature)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected void handleFunctionDropStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        FunctionDropStatement stmtDropFunction = (FunctionDropStatement)stmt;
        FunctionSignature signature = stmtDropFunction.getFunctionSignature();
        signature.setNamespace(this.getActiveDataverseName(signature.getNamespace()));
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        MetadataLockUtil.functionStatementBegin((IMetadataLockManager)this.lockManager, (LockList)metadataProvider.getLocks(), (String)signature.getNamespace(), (String)(signature.getNamespace() + "." + signature.getName()));
        try {
            Function function = MetadataManager.INSTANCE.getFunction(mdTxnCtx, signature);
            if (function == null && !stmtDropFunction.getIfExists()) {
                throw new AlgebricksException("Unknonw function " + signature);
            }
            if (this.isFunctionUsed(mdTxnCtx, signature, null)) {
                throw new MetadataException(3109, new Serializable[]{signature});
            }
            MetadataManager.INSTANCE.dropFunction(mdTxnCtx, signature);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleLoadStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        LoadStatement loadStmt = (LoadStatement)stmt;
        String dataverseName = this.getActiveDataverse(loadStmt.getDataverseName());
        String datasetName = loadStmt.getDatasetName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        MetadataLockUtil.modifyDatasetBegin((IMetadataLockManager)this.lockManager, (LockList)metadataProvider.getLocks(), (String)dataverseName, (String)(dataverseName + "." + datasetName));
        try {
            CompiledStatements.CompiledLoadFromFileStatement cls = new CompiledStatements.CompiledLoadFromFileStatement(dataverseName, loadStmt.getDatasetName().getValue(), loadStmt.getAdapter(), loadStmt.getProperties(), loadStmt.dataIsAlreadySorted());
            JobSpecification spec = this.apiFramework.compileQuery((IClusterInfoCollector)hcc, metadataProvider, null, 0, null, this.sessionOutput, (CompiledStatements.ICompiledDmlStatement)cls);
            this.afterCompile();
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            if (spec != null) {
                this.runJob(hcc, spec);
            }
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobSpecification handleInsertUpsertStatement(final MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, IHyracksDataset hdc, IStatementExecutor.ResultDelivery resultDelivery, IStatementExecutor.ResultMetadata outMetadata, IStatementExecutor.Stats stats, boolean compileOnly, String clientContextId) throws Exception {
        final InsertStatement stmtInsertUpsert = (InsertStatement)stmt;
        final String dataverseName = this.getActiveDataverse(stmtInsertUpsert.getDataverseName());
        IMetadataLocker locker = new IMetadataLocker(){

            @Override
            public void lock() throws AlgebricksException {
                MetadataLockUtil.insertDeleteUpsertBegin((IMetadataLockManager)QueryTranslator.this.lockManager, (LockList)metadataProvider.getLocks(), (String)(dataverseName + "." + stmtInsertUpsert.getDatasetName()));
            }

            @Override
            public void unlock() {
                metadataProvider.getLocks().unlock();
            }
        };
        IStatementCompiler compiler = () -> {
            MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            boolean bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            try {
                metadataProvider.setWriteTransaction(true);
                JobSpecification jobSpec = this.rewriteCompileInsertUpsert((IClusterInfoCollector)hcc, metadataProvider, stmtInsertUpsert);
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                return jobSpec;
            }
            catch (Exception e) {
                if (bActiveTxn) {
                    QueryTranslator.abort(e, e, mdTxnCtx);
                }
                throw e;
            }
        };
        if (compileOnly) {
            locker.lock();
            try {
                JobSpecification jobSpecification = compiler.compile();
                return jobSpecification;
            }
            finally {
                locker.unlock();
            }
        }
        if (stmtInsertUpsert.getReturnExpression() != null) {
            this.deliverResult(hcc, hdc, compiler, metadataProvider, locker, resultDelivery, outMetadata, stats, clientContextId, (IStatementExecutorContext)NoOpStatementExecutorContext.INSTANCE);
        } else {
            locker.lock();
            try {
                JobSpecification jobSpec = compiler.compile();
                if (jobSpec == null) {
                    JobSpecification jobSpecification = jobSpec;
                    return jobSpecification;
                }
                this.runJob(hcc, jobSpec);
            }
            finally {
                locker.unlock();
            }
        }
        return null;
    }

    public JobSpecification handleDeleteStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc, boolean compileOnly) throws Exception {
        DeleteStatement stmtDelete = (DeleteStatement)stmt;
        String dataverseName = this.getActiveDataverse(stmtDelete.getDataverseName());
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        MetadataLockUtil.insertDeleteUpsertBegin((IMetadataLockManager)this.lockManager, (LockList)metadataProvider.getLocks(), (String)(dataverseName + "." + stmtDelete.getDatasetName()));
        try {
            metadataProvider.setWriteTransaction(true);
            CompiledStatements.CompiledDeleteStatement clfrqs = new CompiledStatements.CompiledDeleteStatement(stmtDelete.getVariableExpr(), dataverseName, stmtDelete.getDatasetName().getValue(), stmtDelete.getCondition(), stmtDelete.getVarCounter(), stmtDelete.getQuery());
            JobSpecification jobSpec = this.rewriteCompileQuery((IClusterInfoCollector)hcc, metadataProvider, clfrqs.getQuery(), (CompiledStatements.ICompiledDmlStatement)clfrqs);
            this.afterCompile();
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            if (jobSpec != null && !compileOnly) {
                this.runJob(hcc, jobSpec);
            }
            JobSpecification jobSpecification = jobSpec;
            return jobSpecification;
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    public JobSpecification rewriteCompileQuery(IClusterInfoCollector clusterInfoCollector, MetadataProvider metadataProvider, Query query, CompiledStatements.ICompiledDmlStatement stmt) throws RemoteException, AlgebricksException, ACIDException {
        Pair<IReturningStatement, Integer> rewrittenResult = this.apiFramework.reWriteQuery(this.declaredFunctions, metadataProvider, (IReturningStatement)query, this.sessionOutput, true);
        return this.apiFramework.compileQuery(clusterInfoCollector, metadataProvider, (Query)rewrittenResult.first, (Integer)rewrittenResult.second, stmt == null ? null : stmt.getDatasetName(), this.sessionOutput, stmt);
    }

    private JobSpecification rewriteCompileInsertUpsert(IClusterInfoCollector clusterInfoCollector, MetadataProvider metadataProvider, InsertStatement insertUpsert) throws RemoteException, AlgebricksException, ACIDException {
        CompiledStatements.CompiledInsertStatement clfrqs;
        Pair<IReturningStatement, Integer> rewrittenResult = this.apiFramework.reWriteQuery(this.declaredFunctions, metadataProvider, (IReturningStatement)insertUpsert, this.sessionOutput, true);
        InsertStatement rewrittenInsertUpsert = (InsertStatement)rewrittenResult.first;
        String dataverseName = this.getActiveDataverse(rewrittenInsertUpsert.getDataverseName());
        String datasetName = rewrittenInsertUpsert.getDatasetName().getValue();
        switch (insertUpsert.getKind()) {
            case INSERT: {
                clfrqs = new CompiledStatements.CompiledInsertStatement(dataverseName, datasetName, rewrittenInsertUpsert.getQuery(), rewrittenInsertUpsert.getVarCounter(), rewrittenInsertUpsert.getVar(), rewrittenInsertUpsert.getReturnExpression());
                break;
            }
            case UPSERT: {
                clfrqs = new CompiledStatements.CompiledUpsertStatement(dataverseName, datasetName, rewrittenInsertUpsert.getQuery(), rewrittenInsertUpsert.getVarCounter(), rewrittenInsertUpsert.getVar(), rewrittenInsertUpsert.getReturnExpression());
                break;
            }
            default: {
                throw new AlgebricksException("Unsupported statement type " + rewrittenInsertUpsert.getKind());
            }
        }
        return this.apiFramework.compileQuery(clusterInfoCollector, metadataProvider, rewrittenInsertUpsert.getQuery(), (Integer)rewrittenResult.second, datasetName, this.sessionOutput, (CompiledStatements.ICompiledDmlStatement)clfrqs);
    }

    protected void handleCreateFeedStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        CreateFeedStatement cfs = (CreateFeedStatement)stmt;
        String dataverseName = this.getActiveDataverse(cfs.getDataverseName());
        String feedName = cfs.getFeedName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        MetadataLockUtil.createFeedBegin((IMetadataLockManager)this.lockManager, (LockList)metadataProvider.getLocks(), (String)dataverseName, (String)(dataverseName + "." + feedName));
        try {
            Feed feed = MetadataManager.INSTANCE.getFeed(metadataProvider.getMetadataTxnContext(), dataverseName, feedName);
            if (feed != null) {
                if (cfs.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new AlgebricksException("A feed with this name " + feedName + " already exists.");
            }
            feed = new Feed(dataverseName, feedName, cfs.getConfiguration());
            FeedMetadataUtil.validateFeed((Feed)feed, (MetadataTransactionContext)mdTxnCtx, (ICcApplicationContext)this.appCtx);
            MetadataManager.INSTANCE.addFeed(metadataProvider.getMetadataTxnContext(), feed);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleCreateFeedPolicyStatement(MetadataProvider metadataProvider, Statement stmt) throws AlgebricksException, HyracksDataException {
        FeedPolicyEntity newPolicy = null;
        MetadataTransactionContext mdTxnCtx = null;
        CreateFeedPolicyStatement cfps = (CreateFeedPolicyStatement)stmt;
        String dataverse = this.getActiveDataverse(null);
        String policy = cfps.getPolicyName();
        MetadataLockUtil.createFeedPolicyBegin((IMetadataLockManager)this.lockManager, (LockList)metadataProvider.getLocks(), (String)dataverse, (String)(dataverse + "." + policy));
        try {
            String description;
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            FeedPolicyEntity feedPolicy = MetadataManager.INSTANCE.getFeedPolicy(metadataProvider.getMetadataTxnContext(), dataverse, policy);
            if (feedPolicy != null) {
                if (cfps.getIfNotExists()) {
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                throw new AlgebricksException("A policy with this name " + policy + " already exists.");
            }
            boolean extendingExisting = cfps.getSourcePolicyName() != null;
            String string = description = cfps.getDescription() == null ? "" : cfps.getDescription();
            if (extendingExisting) {
                FeedPolicyEntity sourceFeedPolicy = MetadataManager.INSTANCE.getFeedPolicy(metadataProvider.getMetadataTxnContext(), dataverse, cfps.getSourcePolicyName());
                if (sourceFeedPolicy == null && (sourceFeedPolicy = MetadataManager.INSTANCE.getFeedPolicy(metadataProvider.getMetadataTxnContext(), "Metadata", cfps.getSourcePolicyName())) == null) {
                    throw new AlgebricksException("Unknown policy " + cfps.getSourcePolicyName());
                }
                Map policyProperties = sourceFeedPolicy.getProperties();
                policyProperties.putAll(cfps.getProperties());
                newPolicy = new FeedPolicyEntity(dataverse, policy, description, policyProperties);
            } else {
                Properties prop = new Properties();
                try {
                    FileInputStream stream = new FileInputStream(cfps.getSourcePolicyFile());
                    prop.load(stream);
                }
                catch (Exception e) {
                    throw new AlgebricksException("Unable to read policy file" + cfps.getSourcePolicyFile(), (Throwable)e);
                }
                HashMap policyProperties = new HashMap();
                prop.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> policyProperties.put((String)key, (String)value)));
                newPolicy = new FeedPolicyEntity(dataverse, policy, description, policyProperties);
            }
            MetadataManager.INSTANCE.addFeedPolicy(mdTxnCtx, newPolicy);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (RemoteException | ACIDException e) {
            QueryTranslator.abort((Exception)e, (Exception)e, mdTxnCtx);
            throw HyracksDataException.create((Throwable)e);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleDropFeedStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        FeedDropStatement stmtFeedDrop = (FeedDropStatement)stmt;
        String dataverseName = this.getActiveDataverse(stmtFeedDrop.getDataverseName());
        String feedName = stmtFeedDrop.getFeedName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        MetadataLockUtil.dropFeedBegin((IMetadataLockManager)this.lockManager, (LockList)metadataProvider.getLocks(), (String)dataverseName, (String)(dataverseName + "." + feedName));
        try {
            Feed feed = MetadataManager.INSTANCE.getFeed(mdTxnCtx, dataverseName, feedName);
            if (feed == null) {
                if (!stmtFeedDrop.getIfExists()) {
                    throw new AlgebricksException("There is no feed with this name " + feedName + ".");
                }
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                return;
            }
            this.doDropFeed(hcc, metadataProvider, feed);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void doDropFeed(IHyracksClientConnection hcc, MetadataProvider metadataProvider, Feed feed) throws Exception {
        MetadataTransactionContext mdTxnCtx = metadataProvider.getMetadataTxnContext();
        EntityId feedId = feed.getFeedId();
        ActiveNotificationHandler activeNotificationHandler = (ActiveNotificationHandler)this.appCtx.getActiveNotificationHandler();
        ActiveEntityEventsListener listener = (ActiveEntityEventsListener)activeNotificationHandler.getListener(feedId);
        if (listener != null && listener.getState() != ActivityState.STOPPED) {
            throw new AlgebricksException("Feed " + feedId + " is currently active and connected to the following dataset(s) \n" + listener.toString());
        }
        if (listener != null) {
            listener.unregister();
        }
        JobSpecification spec = FeedOperations.buildRemoveFeedStorageJob(metadataProvider, MetadataManager.INSTANCE.getFeed(mdTxnCtx, feedId.getDataverse(), feedId.getEntityName()));
        this.runJob(hcc, spec);
        MetadataManager.INSTANCE.dropFeed(mdTxnCtx, feed.getDataverseName(), feed.getFeedName());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Removed feed " + feedId);
        }
    }

    protected void handleDropFeedPolicyStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        FeedPolicyDropStatement stmtFeedPolicyDrop = (FeedPolicyDropStatement)stmt;
        String dataverseName = this.getActiveDataverse(stmtFeedPolicyDrop.getDataverseName());
        String policyName = stmtFeedPolicyDrop.getPolicyName().getValue();
        MetadataLockUtil.dropFeedPolicyBegin((IMetadataLockManager)this.lockManager, (LockList)metadataProvider.getLocks(), (String)dataverseName, (String)(dataverseName + "." + policyName));
        try {
            FeedPolicyEntity feedPolicy = MetadataManager.INSTANCE.getFeedPolicy(mdTxnCtx, dataverseName, policyName);
            if (feedPolicy == null) {
                if (!stmtFeedPolicyDrop.getIfExists()) {
                    throw new AlgebricksException("Unknown policy " + policyName + " in dataverse " + dataverseName);
                }
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                return;
            }
            MetadataManager.INSTANCE.dropFeedPolicy(mdTxnCtx, dataverseName, policyName);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    private void handleStartFeedStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        StartFeedStatement sfs = (StartFeedStatement)stmt;
        String dataverseName = this.getActiveDataverse(sfs.getDataverseName());
        String feedName = sfs.getFeedName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean committed = false;
        MetadataLockUtil.startFeedBegin((IMetadataLockManager)this.lockManager, (LockList)metadataProvider.getLocks(), (String)dataverseName, (String)(dataverseName + "." + feedName));
        try {
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            EntityId entityId = new EntityId("Feed", dataverseName, feedName);
            Feed feed = FeedMetadataUtil.validateIfFeedExists((String)dataverseName, (String)feedName, (MetadataTransactionContext)metadataProvider.getMetadataTxnContext());
            List feedConnections = MetadataManager.INSTANCE.getFeedConections(metadataProvider.getMetadataTxnContext(), dataverseName, feedName);
            if (feedConnections.isEmpty()) {
                throw new CompilationException(3111, new Serializable[]{feedName});
            }
            for (FeedConnection feedConnection : feedConnections) {
                String fqName = feedConnection.getDataverseName() + "." + feedConnection.getDatasetName();
                this.lockManager.acquireDatasetReadLock(metadataProvider.getLocks(), fqName);
            }
            ActiveNotificationHandler activeEventHandler = (ActiveNotificationHandler)this.appCtx.getActiveNotificationHandler();
            ActiveEntityEventsListener listener = (ActiveEntityEventsListener)activeEventHandler.getListener(entityId);
            if (listener == null) {
                ArrayList<Dataset> datasets = new ArrayList<Dataset>();
                for (FeedConnection connection : feedConnections) {
                    Dataset ds = metadataProvider.findDataset(connection.getDataverseName(), connection.getDatasetName());
                    datasets.add(ds);
                }
                listener = new FeedEventsListener(this, metadataProvider.getApplicationContext(), hcc, entityId, datasets, null, FeedIntakeOperatorNodePushable.class.getSimpleName(), (IRetryPolicyFactory)NoRetryPolicyFactory.INSTANCE, feed, feedConnections);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            committed = true;
            listener.start(metadataProvider);
        }
        catch (Exception e) {
            if (!committed) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStopFeedStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        StopFeedStatement sfst = (StopFeedStatement)stmt;
        String dataverseName = this.getActiveDataverse(sfst.getDataverseName());
        String feedName = sfst.getFeedName().getValue();
        EntityId entityId = new EntityId("Feed", dataverseName, feedName);
        ActiveNotificationHandler activeEventHandler = (ActiveNotificationHandler)this.appCtx.getActiveNotificationHandler();
        ActiveEntityEventsListener listener = (ActiveEntityEventsListener)activeEventHandler.getListener(entityId);
        if (listener == null) {
            throw new AlgebricksException("Feed " + feedName + " is not started.");
        }
        MetadataLockUtil.stopFeedBegin((IMetadataLockManager)this.lockManager, (LockList)metadataProvider.getLocks(), (String)entityId.getDataverse(), (String)entityId.getEntityName());
        try {
            listener.stop(metadataProvider);
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    private void handleConnectFeedStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        ConnectFeedStatement cfs = (ConnectFeedStatement)stmt;
        String dataverseName = this.getActiveDataverse(cfs.getDataverseName());
        String feedName = cfs.getFeedName();
        String datasetName = cfs.getDatasetName().getValue();
        String policyName = cfs.getPolicy();
        String whereClauseBody = cfs.getWhereClauseBody();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        ActiveNotificationHandler activeEventHandler = (ActiveNotificationHandler)this.appCtx.getActiveNotificationHandler();
        MetadataLockUtil.connectFeedBegin((IMetadataLockManager)this.lockManager, (LockList)metadataProvider.getLocks(), (String)dataverseName, (String)(dataverseName + "." + datasetName), (String)(dataverseName + "." + feedName));
        try {
            Dataset dataset = FeedMetadataUtil.validateIfDatasetExists((MetadataProvider)metadataProvider, (String)dataverseName, (String)datasetName);
            Feed feed = FeedMetadataUtil.validateIfFeedExists((String)dataverseName, (String)feedName, (MetadataTransactionContext)metadataProvider.getMetadataTxnContext());
            FeedEventsListener listener = (FeedEventsListener)activeEventHandler.getListener(feed.getFeedId());
            if (listener != null && listener.isActive()) {
                throw new CompilationException(3020, new Serializable[]{feedName});
            }
            ARecordType outputType = FeedMetadataUtil.getOutputType((IFeed)feed, (String)((String)feed.getConfiguration().get("type-name")));
            List appliedFunctions = cfs.getAppliedFunctions();
            for (FunctionSignature func : appliedFunctions) {
                if (MetadataManager.INSTANCE.getFunction(mdTxnCtx, func) != null) continue;
                throw new CompilationException(3087, new Serializable[]{func.getName()});
            }
            FeedConnection fc = MetadataManager.INSTANCE.getFeedConnection(metadataProvider.getMetadataTxnContext(), dataverseName, feedName, datasetName);
            if (fc != null) {
                throw new AlgebricksException("Feed" + feedName + " is already connected dataset " + datasetName);
            }
            fc = new FeedConnection(dataverseName, feedName, datasetName, appliedFunctions, policyName, whereClauseBody, outputType.getTypeName());
            MetadataManager.INSTANCE.addFeedConnection(metadataProvider.getMetadataTxnContext(), fc);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            if (listener != null) {
                listener.add(dataset);
                listener.addFeedConnection(fc);
            }
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleDisconnectFeedStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        DisconnectFeedStatement cfs = (DisconnectFeedStatement)stmt;
        String dataverseName = this.getActiveDataverse(cfs.getDataverseName());
        String datasetName = cfs.getDatasetName().getValue();
        String feedName = cfs.getFeedName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        MetadataLockUtil.disconnectFeedBegin((IMetadataLockManager)this.lockManager, (LockList)metadataProvider.getLocks(), (String)dataverseName, (String)(dataverseName + "." + datasetName), (String)(dataverseName + "." + cfs.getFeedName()));
        try {
            ActiveNotificationHandler activeEventHandler = (ActiveNotificationHandler)this.appCtx.getActiveNotificationHandler();
            ActiveEntityEventsListener listener = (ActiveEntityEventsListener)activeEventHandler.getListener(new EntityId("Feed", dataverseName, feedName));
            if (listener != null && listener.isActive()) {
                throw new CompilationException(3020, new Serializable[]{feedName});
            }
            FeedMetadataUtil.validateIfDatasetExists((MetadataProvider)metadataProvider, (String)dataverseName, (String)cfs.getDatasetName().getValue());
            FeedMetadataUtil.validateIfFeedExists((String)dataverseName, (String)cfs.getFeedName().getValue(), (MetadataTransactionContext)mdTxnCtx);
            FeedConnection fc = MetadataManager.INSTANCE.getFeedConnection(metadataProvider.getMetadataTxnContext(), dataverseName, feedName, datasetName);
            Dataset ds = metadataProvider.findDataset(dataverseName, datasetName);
            if (ds == null) {
                throw new CompilationException("Dataset " + dataverseName + "." + datasetName + " doesn't exist");
            }
            if (fc == null) {
                throw new CompilationException("Feed " + feedName + " is currently not connected to " + cfs.getDatasetName().getValue() + ". Invalid operation!");
            }
            MetadataManager.INSTANCE.dropFeedConnection(mdTxnCtx, dataverseName, feedName, datasetName);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            if (listener != null) {
                listener.remove(ds);
            }
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    protected void handleCompactStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        CompactStatement compactStatement = (CompactStatement)stmt;
        String dataverseName = this.getActiveDataverse(compactStatement.getDataverseName());
        String datasetName = compactStatement.getDatasetName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        boolean bActiveTxn = true;
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        ArrayList<JobSpecification> jobsToExecute = new ArrayList<JobSpecification>();
        MetadataLockUtil.compactBegin((IMetadataLockManager)this.lockManager, (LockList)metadataProvider.getLocks(), (String)dataverseName, (String)(dataverseName + "." + datasetName));
        try {
            Dataset ds = metadataProvider.findDataset(dataverseName, datasetName);
            if (ds == null) {
                throw new AlgebricksException("There is no dataset with this name " + datasetName + " in dataverse " + dataverseName + ".");
            }
            List indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataverseName, datasetName);
            if (indexes.isEmpty()) {
                throw new AlgebricksException("Cannot compact the extrenal dataset " + datasetName + " because it has no indexes");
            }
            Dataverse dataverse = MetadataManager.INSTANCE.getDataverse(metadataProvider.getMetadataTxnContext(), dataverseName);
            jobsToExecute.add(DatasetUtil.compactDatasetJobSpec((Dataverse)dataverse, (String)datasetName, (MetadataProvider)metadataProvider));
            if (ds.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                for (Index index : indexes) {
                    if (!index.isSecondaryIndex()) continue;
                    jobsToExecute.add(IndexUtil.buildSecondaryIndexCompactJobSpec((Dataset)ds, (Index)index, (MetadataProvider)metadataProvider));
                }
            } else {
                this.prepareCompactJobsForExternalDataset(indexes, ds, jobsToExecute, metadataProvider);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            bActiveTxn = false;
            for (JobSpecification jobSpec : jobsToExecute) {
                this.runJob(hcc, jobSpec);
            }
        }
        catch (Exception e) {
            if (bActiveTxn) {
                QueryTranslator.abort(e, e, mdTxnCtx);
            }
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
            ExternalDatasetsRegistry.INSTANCE.releaseAcquiredLocks(metadataProvider);
        }
    }

    protected void prepareCompactJobsForExternalDataset(List<Index> indexes, Dataset ds, List<JobSpecification> jobsToExecute, MetadataProvider metadataProvider) throws AlgebricksException {
        for (int j = 0; j < indexes.size(); ++j) {
            jobsToExecute.add(IndexUtil.buildSecondaryIndexCompactJobSpec((Dataset)ds, (Index)indexes.get(j), (MetadataProvider)metadataProvider));
        }
    }

    protected void handleQuery(final MetadataProvider metadataProvider, Query query, IHyracksClientConnection hcc, IHyracksDataset hdc, IStatementExecutor.ResultDelivery resultDelivery, IStatementExecutor.ResultMetadata outMetadata, IStatementExecutor.Stats stats, String clientContextId, IStatementExecutorContext ctx) throws Exception {
        IMetadataLocker locker = new IMetadataLocker(){

            @Override
            public void lock() {
            }

            @Override
            public void unlock() {
                metadataProvider.getLocks().unlock();
                ExternalDatasetsRegistry.INSTANCE.releaseAcquiredLocks(metadataProvider);
            }
        };
        IStatementCompiler compiler = () -> {
            MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            boolean bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            try {
                JobSpecification jobSpec = this.rewriteCompileQuery((IClusterInfoCollector)hcc, metadataProvider, query, null);
                this.afterCompile();
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                return query.isExplain() || !this.sessionConfig.isExecuteQuery() ? null : jobSpec;
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, e.getMessage(), (Throwable)e);
                if (bActiveTxn) {
                    QueryTranslator.abort(e, e, mdTxnCtx);
                }
                throw e;
            }
        };
        this.deliverResult(hcc, hdc, compiler, metadataProvider, locker, resultDelivery, outMetadata, stats, clientContextId, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverResult(IHyracksClientConnection hcc, IHyracksDataset hdc, IStatementCompiler compiler, MetadataProvider metadataProvider, IMetadataLocker locker, IStatementExecutor.ResultDelivery resultDelivery, IStatementExecutor.ResultMetadata outMetadata, IStatementExecutor.Stats stats, String clientContextId, IStatementExecutorContext ctx) throws Exception {
        ResultSetId resultSetId = metadataProvider.getResultSetId();
        switch (resultDelivery) {
            case ASYNC: {
                MutableBoolean printed = new MutableBoolean(false);
                this.executorService.submit(() -> this.asyncCreateAndRunJob(hcc, compiler, locker, resultDelivery, clientContextId, ctx, resultSetId, printed));
                MutableBoolean mutableBoolean = printed;
                synchronized (mutableBoolean) {
                    while (!printed.booleanValue()) {
                        printed.wait();
                    }
                    break;
                }
            }
            case IMMEDIATE: {
                QueryTranslator.createAndRunJob(hcc, this.jobFlags, null, compiler, locker, resultDelivery, id -> {
                    ResultReader resultReader = new ResultReader(hdc, id, resultSetId);
                    this.updateJobStats(id, stats);
                    this.sessionOutput.release();
                    ResultUtil.printResults((IApplicationContext)this.appCtx, resultReader, this.sessionOutput, stats, metadataProvider.findOutputRecordType());
                }, clientContextId, ctx);
                break;
            }
            case DEFERRED: {
                QueryTranslator.createAndRunJob(hcc, this.jobFlags, null, compiler, locker, resultDelivery, id -> {
                    this.updateJobStats(id, stats);
                    ResultUtil.printResultHandle(this.sessionOutput, new ResultHandle(id, resultSetId));
                    if (outMetadata != null) {
                        outMetadata.getResultSets().add(Triple.of((Object)id, (Object)resultSetId, (Object)metadataProvider.findOutputRecordType()));
                    }
                }, clientContextId, ctx);
                break;
            }
        }
    }

    private void updateJobStats(JobId jobId, IStatementExecutor.Stats stats) {
        IJobManager jobManager = ((ClusterControllerService)this.appCtx.getServiceContext().getControllerService()).getJobManager();
        JobRun run = jobManager.get(jobId);
        if (run == null || run.getStatus() != JobStatus.TERMINATED) {
            return;
        }
        JobProfile jobProfile = run.getJobProfile();
        Collection jobletProfiles = jobProfile.getJobletProfiles().values();
        long processedObjects = 0L;
        for (JobletProfile jp : jobletProfiles) {
            Collection jobletTasksProfile = jp.getTaskProfiles().values();
            for (TaskProfile tp : jobletTasksProfile) {
                processedObjects += tp.getStatsCollector().getAggregatedStats().getTupleCounter().get();
            }
        }
        stats.setProcessedObjects(processedObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncCreateAndRunJob(IHyracksClientConnection hcc, IStatementCompiler compiler, IMetadataLocker locker, IStatementExecutor.ResultDelivery resultDelivery, String clientContextId, IStatementExecutorContext ctx, ResultSetId resultSetId, MutableBoolean printed) {
        MutableObject jobId = new MutableObject((Object)JobId.INVALID);
        try {
            QueryTranslator.createAndRunJob(hcc, this.jobFlags, (Mutable<JobId>)jobId, compiler, locker, resultDelivery, id -> {
                ResultHandle handle = new ResultHandle(id, resultSetId);
                ResultUtil.printStatus(this.sessionOutput, AbstractQueryApiServlet.ResultStatus.RUNNING);
                ResultUtil.printResultHandle(this.sessionOutput, handle);
                MutableBoolean mutableBoolean = printed;
                synchronized (mutableBoolean) {
                    printed.setTrue();
                    printed.notify();
                }
            }, clientContextId, ctx);
        }
        catch (Exception e) {
            if (Objects.equals(JobId.INVALID, jobId.getValue())) {
                ResultUtil.printStatus(this.sessionOutput, AbstractQueryApiServlet.ResultStatus.FAILED);
                ResultUtil.printError(this.sessionOutput.out(), e);
            } else {
                GlobalConfig.ASTERIX_LOGGER.log(Level.ERROR, resultDelivery.name() + " job with id " + jobId.getValue() + " failed", (Throwable)e);
            }
        }
        finally {
            MutableBoolean mutableBoolean = printed;
            synchronized (mutableBoolean) {
                if (printed.isFalse()) {
                    printed.setTrue();
                    printed.notify();
                }
            }
        }
    }

    private void runJob(IHyracksClientConnection hcc, JobSpecification jobSpec) throws Exception {
        QueryTranslator.runJob(hcc, jobSpec, this.jobFlags);
    }

    private static void runJob(IHyracksClientConnection hcc, JobSpecification jobSpec, EnumSet<JobFlag> jobFlags) throws Exception {
        JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, jobFlags, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createAndRunJob(IHyracksClientConnection hcc, EnumSet<JobFlag> jobFlags, Mutable<JobId> jId, IStatementCompiler compiler, IMetadataLocker locker, IStatementExecutor.ResultDelivery resultDelivery, IResultPrinter printer, String clientContextId, IStatementExecutorContext ctx) throws Exception {
        locker.lock();
        try {
            JobSpecification jobSpec = compiler.compile();
            if (jobSpec == null) {
                return;
            }
            JobId jobId = JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, jobFlags, (boolean)false);
            if (ctx != null && clientContextId != null) {
                ctx.put(clientContextId, jobId);
            }
            if (jId != null) {
                jId.setValue((Object)jobId);
            }
            if (IStatementExecutor.ResultDelivery.ASYNC == resultDelivery) {
                printer.print(jobId);
                hcc.waitForCompletion(jobId);
            } else {
                hcc.waitForCompletion(jobId);
                printer.print(jobId);
            }
        }
        finally {
            locker.unlock();
            if (ctx != null && clientContextId != null) {
                ctx.removeJobIdFromClientContextId(clientContextId);
            }
        }
    }

    protected void handleCreateNodeGroupStatement(MetadataProvider metadataProvider, Statement stmt) throws Exception {
        NodegroupDecl stmtCreateNodegroup = (NodegroupDecl)stmt;
        String ngName = stmtCreateNodegroup.getNodegroupName().getValue();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        metadataProvider.setMetadataTxnContext(mdTxnCtx);
        this.lockManager.acquireNodeGroupWriteLock(metadataProvider.getLocks(), ngName);
        try {
            NodeGroup ng = MetadataManager.INSTANCE.getNodegroup(mdTxnCtx, ngName);
            if (ng != null) {
                if (!stmtCreateNodegroup.getIfNotExists()) {
                    throw new AlgebricksException("A nodegroup with this name " + ngName + " already exists.");
                }
            } else {
                List ncIdentifiers = stmtCreateNodegroup.getNodeControllerNames();
                ArrayList<String> ncNames = new ArrayList<String>(ncIdentifiers.size());
                for (Identifier id : ncIdentifiers) {
                    ncNames.add(id.getValue());
                }
                MetadataManager.INSTANCE.addNodegroup(mdTxnCtx, new NodeGroup(ngName, ncNames));
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            QueryTranslator.abort(e, e, mdTxnCtx);
            throw e;
        }
        finally {
            metadataProvider.getLocks().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleExternalDatasetRefreshStatement(MetadataProvider metadataProvider, Statement stmt, IHyracksClientConnection hcc) throws Exception {
        block30: {
            RefreshExternalDatasetStatement stmtRefresh = (RefreshExternalDatasetStatement)stmt;
            String dataverseName = this.getActiveDataverse(stmtRefresh.getDataverseName());
            String datasetName = stmtRefresh.getDatasetName().getValue();
            DatasetConfig.TransactionState transactionState = DatasetConfig.TransactionState.COMMIT;
            MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            boolean bActiveTxn = true;
            metadataProvider.setMetadataTxnContext(mdTxnCtx);
            JobSpecification spec = null;
            Dataset ds = null;
            List metadataFiles = null;
            ArrayList deletedFiles = null;
            ArrayList addedFiles = null;
            ArrayList appendedFiles = null;
            List indexes = null;
            Dataset transactionDataset = null;
            boolean lockAquired = false;
            boolean success = false;
            MetadataLockUtil.refreshDatasetBegin((IMetadataLockManager)this.lockManager, (LockList)metadataProvider.getLocks(), (String)dataverseName, (String)(dataverseName + "." + datasetName));
            try {
                ds = metadataProvider.findDataset(dataverseName, datasetName);
                if (ds == null) {
                    throw new AlgebricksException("There is no dataset with this name " + datasetName + " in dataverse " + dataverseName);
                }
                if (ds.getDatasetType() != DatasetConfig.DatasetType.EXTERNAL) {
                    throw new AlgebricksException("dataset " + datasetName + " in dataverse " + dataverseName + " is not an external dataset");
                }
                indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataverseName, datasetName);
                if (indexes.isEmpty()) {
                    throw new AlgebricksException("External dataset " + datasetName + " in dataverse " + dataverseName + " doesn't have any index");
                }
                Date txnTime = new Date();
                ExternalDatasetsRegistry.INSTANCE.refreshBegin(ds);
                lockAquired = true;
                metadataFiles = MetadataManager.INSTANCE.getDatasetExternalFiles(mdTxnCtx, ds);
                deletedFiles = new ArrayList();
                addedFiles = new ArrayList();
                appendedFiles = new ArrayList();
                if (ExternalIndexingOperations.isDatasetUptodate((Dataset)ds, (List)metadataFiles, addedFiles, deletedFiles, appendedFiles)) {
                    ((ExternalDatasetDetails)ds.getDatasetDetails()).setRefreshTimestamp(txnTime);
                    MetadataManager.INSTANCE.updateDataset(mdTxnCtx, ds);
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                    return;
                }
                transactionDataset = ExternalIndexingOperations.createTransactionDataset((Dataset)ds);
                MetadataManager.INSTANCE.updateDataset(mdTxnCtx, transactionDataset);
                for (ExternalFile file : addedFiles) {
                    MetadataManager.INSTANCE.addExternalFile(mdTxnCtx, file);
                }
                for (ExternalFile file : appendedFiles) {
                    MetadataManager.INSTANCE.addExternalFile(mdTxnCtx, file);
                }
                for (ExternalFile file : deletedFiles) {
                    MetadataManager.INSTANCE.addExternalFile(mdTxnCtx, file);
                }
                spec = ExternalIndexingOperations.buildFilesIndexUpdateOp((Dataset)ds, (List)metadataFiles, addedFiles, appendedFiles, (MetadataProvider)metadataProvider);
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                transactionState = DatasetConfig.TransactionState.BEGIN;
                this.runJob(hcc, spec);
                for (Index index : indexes) {
                    if (ExternalIndexingOperations.isFileIndex((Index)index)) continue;
                    spec = ExternalIndexingOperations.buildIndexUpdateOp((Dataset)ds, (Index)index, (List)metadataFiles, addedFiles, appendedFiles, (MetadataProvider)metadataProvider);
                    this.runJob(hcc, spec);
                }
                spec = ExternalIndexingOperations.buildCommitJob((Dataset)ds, (List)indexes, (MetadataProvider)metadataProvider);
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                bActiveTxn = true;
                ((ExternalDatasetDetails)transactionDataset.getDatasetDetails()).setState(DatasetConfig.TransactionState.READY_TO_COMMIT);
                ((ExternalDatasetDetails)transactionDataset.getDatasetDetails()).setRefreshTimestamp(txnTime);
                MetadataManager.INSTANCE.updateDataset(mdTxnCtx, transactionDataset);
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                transactionState = DatasetConfig.TransactionState.READY_TO_COMMIT;
                this.runJob(hcc, spec);
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                bActiveTxn = true;
                for (ExternalFile file : metadataFiles) {
                    if (file.getPendingOp() == DatasetConfig.ExternalFilePendingOp.DROP_OP) {
                        MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                        continue;
                    }
                    if (file.getPendingOp() != DatasetConfig.ExternalFilePendingOp.NO_OP) continue;
                    Iterator iterator = appendedFiles.iterator();
                    while (iterator.hasNext()) {
                        ExternalFile appendedFile = (ExternalFile)iterator.next();
                        if (!file.getFileName().equals(appendedFile.getFileName())) continue;
                        MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                        MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, appendedFile);
                        appendedFile.setFileNumber(file.getFileNumber());
                        appendedFile.setPendingOp(DatasetConfig.ExternalFilePendingOp.NO_OP);
                        MetadataManager.INSTANCE.addExternalFile(mdTxnCtx, appendedFile);
                        iterator.remove();
                    }
                }
                for (ExternalFile file : deletedFiles) {
                    MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                }
                for (ExternalFile file : addedFiles) {
                    MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                    file.setPendingOp(DatasetConfig.ExternalFilePendingOp.NO_OP);
                    MetadataManager.INSTANCE.addExternalFile(mdTxnCtx, file);
                }
                ((ExternalDatasetDetails)transactionDataset.getDatasetDetails()).setState(DatasetConfig.TransactionState.COMMIT);
                MetadataManager.INSTANCE.updateDataset(mdTxnCtx, transactionDataset);
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                success = true;
            }
            catch (Exception e) {
                if (bActiveTxn) {
                    QueryTranslator.abort(e, e, mdTxnCtx);
                }
                if (transactionState == DatasetConfig.TransactionState.READY_TO_COMMIT) {
                    throw new IllegalStateException("System is inconsistent state: commit of (" + dataverseName + "." + datasetName + ") refresh couldn't carry out the commit phase", e);
                }
                if (transactionState == DatasetConfig.TransactionState.COMMIT) {
                    throw e;
                }
                if (transactionState != DatasetConfig.TransactionState.BEGIN) break block30;
                mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                bActiveTxn = true;
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                spec = ExternalIndexingOperations.buildAbortOp((Dataset)ds, (List)indexes, (MetadataProvider)metadataProvider);
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                bActiveTxn = false;
                try {
                    this.runJob(hcc, spec);
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                    throw new IllegalStateException("System is in inconsistent state. Failed to abort refresh", e);
                }
                try {
                    mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                    for (ExternalFile file : deletedFiles) {
                        MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                    }
                    for (ExternalFile file : addedFiles) {
                        MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                    }
                    for (ExternalFile file : appendedFiles) {
                        MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                    }
                    MetadataManager.INSTANCE.updateDataset(mdTxnCtx, ds);
                    MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                }
                catch (Exception e2) {
                    QueryTranslator.abort(e, e2, mdTxnCtx);
                    e.addSuppressed(e2);
                    throw new IllegalStateException("System is in inconsistent state. Failed to drop delta files", e);
                }
            }
            finally {
                if (lockAquired) {
                    ExternalDatasetsRegistry.INSTANCE.refreshEnd(ds, success);
                }
                metadataProvider.getLocks().unlock();
            }
        }
    }

    public String getActiveDataverseName(String dataverse) {
        return dataverse != null ? dataverse : this.activeDataverse.getDataverseName();
    }

    public ExecutionPlans getExecutionPlans() {
        return this.apiFramework.getExecutionPlans();
    }

    public String getActiveDataverse(Identifier dataverse) {
        return this.getActiveDataverseName(dataverse != null ? dataverse.getValue() : null);
    }

    public static void abort(Exception rootE, Exception parentE, MetadataTransactionContext mdTxnCtx) {
        boolean interrupted = Thread.interrupted();
        try {
            if (mdTxnCtx != null) {
                MetadataManager.INSTANCE.abortTransaction(mdTxnCtx);
            }
        }
        catch (Exception e2) {
            parentE.addSuppressed(e2);
            throw new IllegalStateException(rootE);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected void rewriteStatement(Statement stmt) throws CompilationException {
        IStatementRewriter rewriter = this.rewriterFactory.createStatementRewriter();
        rewriter.rewrite(stmt);
    }

    private void ensureNonPrimaryIndexDrop(Index index) throws AlgebricksException {
        if (index.isPrimaryIndex()) {
            throw new MetadataException(1069, new Serializable[]{index.getIndexName(), index.getDatasetName()});
        }
    }

    protected void afterCompile() {
        if (this.sessionOutput.config().is("format-html")) {
            ExecutionPlansHtmlPrintUtil.print((PrintWriter)this.sessionOutput.out(), (ExecutionPlans)this.getExecutionPlans());
        }
    }

    private static interface IStatementCompiler {
        public JobSpecification compile() throws AlgebricksException, RemoteException, ACIDException;
    }

    private static interface IResultPrinter {
        public void print(JobId var1) throws HyracksDataException, AlgebricksException;
    }

    private static interface IMetadataLocker {
        public void lock() throws AlgebricksException;

        public void unlock() throws AlgebricksException;
    }
}

