/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.result;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.asterix.api.http.server.ResultUtil;
import org.apache.asterix.app.result.ResultReader;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.SessionConfig;
import org.apache.asterix.translator.SessionOutput;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.AlgebricksAppendable;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.control.nc.resources.memory.FrameManager;
import org.apache.hyracks.util.JSONUtil;

public class ResultPrinter {
    private final FrameManager resultDisplayFrameMgr;
    private final SessionOutput output;
    private final SessionConfig conf;
    private final IStatementExecutor.Stats stats;
    private final ARecordType recordType;
    private boolean indentJSON;
    private boolean quoteRecord;
    private boolean wrapArray = false;
    private boolean notFirst = false;
    private ObjectMapper om;
    private ObjectWriter ow;

    public ResultPrinter(IApplicationContext appCtx, SessionOutput output, IStatementExecutor.Stats stats, ARecordType recordType) {
        this.output = output;
        this.conf = output.config();
        this.stats = stats;
        this.recordType = recordType;
        this.indentJSON = this.conf.is("indent-json");
        this.quoteRecord = this.conf.is("quote-record");
        this.resultDisplayFrameMgr = new FrameManager(appCtx.getCompilerProperties().getFrameSize());
        if (this.indentJSON) {
            this.om = new ObjectMapper();
            DefaultPrettyPrinter.Indenter i = new DefaultPrettyPrinter.Indenter(){

                public void writeIndentation(JsonGenerator jsonGenerator, int i) throws IOException {
                    jsonGenerator.writeRaw('\n');
                    for (int j = 0; j < i + 1; ++j) {
                        jsonGenerator.writeRaw('\t');
                    }
                }

                public boolean isInline() {
                    return false;
                }
            };
            DefaultPrettyPrinter pp = new DefaultPrettyPrinter().withObjectIndenter(i).withArrayIndenter(i);
            this.ow = this.om.writer((PrettyPrinter)pp);
        }
    }

    private static void appendCSVHeader(Appendable app, ARecordType recordType) throws HyracksDataException {
        try {
            String[] fieldNames = recordType.getFieldNames();
            boolean notfirst = false;
            for (String name : fieldNames) {
                if (notfirst) {
                    app.append(',');
                }
                notfirst = true;
                app.append('\"').append(name.replace("\"", "\"\"")).append('\"');
            }
            app.append("\r\n");
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private void printPrefix() throws HyracksDataException {
        if (this.conf.is("format-html")) {
            this.output.out().println("<h4>Results:</h4>");
            this.output.out().println("<pre class=\"result-content\">");
        }
        try {
            this.output.resultPrefix(new AlgebricksAppendable((Appendable)this.output.out()));
        }
        catch (AlgebricksException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        if (this.conf.is("format-wrapper-array")) {
            this.output.out().print("[ ");
            this.wrapArray = true;
        }
        if (this.conf.fmt() == SessionConfig.OutputFormat.CSV && this.conf.is("format-csv-header")) {
            if (this.recordType == null) {
                throw new HyracksDataException("Cannot print CSV with header without specifying output-record-type");
            }
            if (this.quoteRecord) {
                StringWriter sw = new StringWriter();
                ResultPrinter.appendCSVHeader(sw, this.recordType);
                this.output.out().print(JSONUtil.quoteAndEscape((String)sw.toString()));
                this.output.out().print("\n");
                this.notFirst = true;
            } else {
                ResultPrinter.appendCSVHeader(this.output.out(), this.recordType);
            }
        }
    }

    private void printPostfix() throws HyracksDataException {
        this.output.out().flush();
        if (this.wrapArray) {
            this.output.out().println(" ]");
        }
        try {
            this.output.resultPostfix(new AlgebricksAppendable((Appendable)this.output.out()));
        }
        catch (AlgebricksException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        if (this.conf.is("format-html")) {
            this.output.out().println("</pre>");
        }
        this.output.out().flush();
    }

    private void displayRecord(String result) throws HyracksDataException {
        String record = result;
        if (this.indentJSON) {
            try {
                record = this.ow.writeValueAsString(this.om.readValue(result, Object.class));
            }
            catch (IOException e) {
                record = result;
            }
        }
        if (this.conf.fmt() == SessionConfig.OutputFormat.CSV) {
            record = record + "\r\n";
        }
        if (this.quoteRecord) {
            record = JSONUtil.quoteAndEscape((String)record);
        }
        if (this.conf.is("format-html")) {
            record = ResultUtil.escapeHTML(record);
        }
        this.output.out().print(record);
        this.stats.setCount(this.stats.getCount() + 1L);
        this.stats.setSize(this.stats.getSize() + (long)record.length());
    }

    public void print(String record) throws HyracksDataException {
        this.printPrefix();
        this.quoteRecord = true;
        this.displayRecord(record);
        this.printPostfix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(ResultReader resultReader) throws HyracksDataException {
        this.printPrefix();
        try {
            IFrameTupleAccessor fta = resultReader.getFrameTupleAccessor();
            VSizeFrame frame = new VSizeFrame((IHyracksFrameMgrContext)this.resultDisplayFrameMgr);
            while (resultReader.read((IFrame)frame) > 0) {
                ByteBuffer frameBuffer = frame.getBuffer();
                byte[] frameBytes = frameBuffer.array();
                fta.reset(frameBuffer);
                int last = fta.getTupleCount();
                for (int tIndex = 0; tIndex < last; ++tIndex) {
                    int start = fta.getTupleStartOffset(tIndex);
                    int length = fta.getTupleEndOffset(tIndex) - start;
                    if (this.conf.fmt() == SessionConfig.OutputFormat.CSV && length > 0 && frameBytes[start + length - 1] == 10) {
                        --length;
                    }
                    String result = new String(frameBytes, start, length, StandardCharsets.UTF_8);
                    if (this.wrapArray && this.notFirst) {
                        this.output.out().print(", ");
                    }
                    this.notFirst = true;
                    this.displayRecord(result);
                }
                frameBuffer.clear();
            }
        }
        finally {
            this.printPostfix();
        }
    }
}

