/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.message;

import org.apache.asterix.app.message.CancelQueryResponse;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.common.utils.RequestStatus;
import org.apache.asterix.hyracks.bootstrap.CCApplication;
import org.apache.asterix.messaging.CCMessageBroker;
import org.apache.asterix.translator.IStatementExecutorContext;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CancelQueryRequest
implements ICcAddressedMessage {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1L;
    private final String nodeId;
    private final long reqId;
    private final String contextId;

    public CancelQueryRequest(String nodeId, long reqId, String contextId) {
        this.nodeId = nodeId;
        this.reqId = reqId;
        this.contextId = contextId;
    }

    public void handle(ICcApplicationContext appCtx) throws HyracksDataException, InterruptedException {
        RequestStatus status;
        ClusterControllerService ccs = (ClusterControllerService)appCtx.getServiceContext().getControllerService();
        CCApplication application = (CCApplication)ccs.getApplication();
        IStatementExecutorContext executorsCtx = application.getStatementExecutorContext();
        JobId jobId = executorsCtx.getJobIdFromClientContextId(this.contextId);
        if (jobId == null) {
            LOGGER.log(Level.WARN, "No job found for context id " + this.contextId);
            status = RequestStatus.NOT_FOUND;
        } else {
            try {
                IHyracksClientConnection hcc = application.getHcc();
                hcc.cancelJob(jobId);
                executorsCtx.removeJobIdFromClientContextId(this.contextId);
                status = RequestStatus.SUCCESS;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARN, "unexpected exception thrown from cancel", (Throwable)e);
                status = RequestStatus.FAILED;
            }
        }
        CancelQueryResponse response = new CancelQueryResponse(this.reqId, status);
        CCMessageBroker messageBroker = (CCMessageBroker)appCtx.getServiceContext().getMessageBroker();
        try {
            messageBroker.sendApplicationMessageToNC(response, this.nodeId);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Failure sending response to nc", (Throwable)e);
        }
    }
}

