/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.function;

import org.apache.asterix.app.function.DatasetResourcesDatasource;
import org.apache.asterix.app.function.FunctionRewriter;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;

public class DatasetResourcesRewriter
extends FunctionRewriter {
    public static final FunctionIdentifier DATASET_RESOURCES = new FunctionIdentifier("asterix", "dataset-resources", 2);
    public static final DatasetResourcesRewriter INSTANCE = new DatasetResourcesRewriter(DATASET_RESOURCES);

    private DatasetResourcesRewriter(FunctionIdentifier functionId) {
        super(functionId);
    }

    @Override
    public DatasetResourcesDatasource toDatasource(IOptimizationContext context, AbstractFunctionCallExpression f) throws AlgebricksException {
        String dataverseName = this.getString(f.getArguments(), 0);
        String datasetName = this.getString(f.getArguments(), 1);
        MetadataProvider metadataProvider = (MetadataProvider)context.getMetadataProvider();
        Dataset dataset = metadataProvider.findDataset(dataverseName, datasetName);
        if (dataset == null) {
            throw new AlgebricksException("Could not find dataset " + datasetName + " in dataverse " + dataverseName);
        }
        return new DatasetResourcesDatasource(context.getComputationNodeDomain(), dataset.getDatasetId());
    }
}

