/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.active;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.asterix.active.ActiveEvent;
import org.apache.asterix.active.ActivityState;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.active.IActiveEntityEventsListener;
import org.apache.asterix.active.IActiveNotificationHandler;
import org.apache.asterix.active.message.ActivePartitionMessage;
import org.apache.asterix.app.active.ActiveEntityEventsListener;
import org.apache.asterix.common.api.IMetadataLockManager;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.metadata.api.IActiveEntityController;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.IJobLifecycleListener;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.api.util.SingleThreadEventProcessor;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActiveNotificationHandler
extends SingleThreadEventProcessor<ActiveEvent>
implements IActiveNotificationHandler,
IJobLifecycleListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Level level = Level.INFO;
    public static final String ACTIVE_ENTITY_PROPERTY_NAME = "ActiveJob";
    private final Map<EntityId, IActiveEntityEventsListener> entityEventListeners;
    private final Map<JobId, EntityId> jobId2EntityId = new HashMap<JobId, EntityId>();
    private boolean initialized = false;
    private boolean suspended = false;

    public ActiveNotificationHandler() {
        super(ActiveNotificationHandler.class.getSimpleName());
        this.entityEventListeners = new HashMap<EntityId, IActiveEntityEventsListener>();
    }

    protected void handle(ActiveEvent event) {
        EntityId entityId = this.jobId2EntityId.get(event.getJobId());
        if (entityId != null) {
            IActiveEntityEventsListener listener = this.entityEventListeners.get(entityId);
            LOGGER.log(level, "Next event is of type " + event.getEventKind());
            if (event.getEventKind() == ActiveEvent.Kind.JOB_FINISHED) {
                LOGGER.log(level, "Removing the job");
                this.jobId2EntityId.remove(event.getJobId());
            }
            if (listener != null) {
                LOGGER.log(level, "Notifying the listener");
                listener.notify(event);
            }
        } else {
            LOGGER.log(Level.ERROR, "Entity not found for received message for job " + event.getJobId());
        }
    }

    public void notifyJobCreation(JobId jobId, JobSpecification jobSpecification) throws HyracksDataException {
        LOGGER.log(level, "notifyJobCreation(JobId jobId, JobSpecification jobSpecification) was called with jobId = " + jobId);
        Serializable property = jobSpecification.getProperty(ACTIVE_ENTITY_PROPERTY_NAME);
        if (property == null || !(property instanceof EntityId)) {
            LOGGER.log(level, "Job is not of type active job. property found to be: " + property);
            return;
        }
        EntityId entityId = (EntityId)property;
        this.monitorJob(jobId, entityId);
        boolean found = this.jobId2EntityId.get(jobId) != null;
        LOGGER.log(level, "Job was found to be: " + (found ? "Active" : "Inactive"));
        this.add(new ActiveEvent(jobId, ActiveEvent.Kind.JOB_CREATED, entityId, (Object)jobSpecification));
    }

    private synchronized void monitorJob(JobId jobId, EntityId entityId) {
        LOGGER.log(level, "monitorJob(JobId jobId, ActiveJob activeJob) called with job id: " + jobId);
        boolean found = this.jobId2EntityId.get(jobId) != null;
        LOGGER.log(level, "Job was found to be: " + (found ? "Active" : "Inactive"));
        if (this.entityEventListeners.containsKey(entityId)) {
            if (this.jobId2EntityId.containsKey(jobId)) {
                LOGGER.error("Job is already being monitored for job: " + jobId);
                return;
            }
            LOGGER.log(level, "monitoring started for job id: " + jobId);
        } else {
            LOGGER.info("No listener was found for the entity: " + entityId);
        }
        this.jobId2EntityId.put(jobId, entityId);
    }

    public synchronized void notifyJobStart(JobId jobId) throws HyracksException {
        EntityId entityId = this.jobId2EntityId.get(jobId);
        if (entityId != null) {
            this.add(new ActiveEvent(jobId, ActiveEvent.Kind.JOB_STARTED, entityId, null));
        }
    }

    public synchronized void notifyJobFinish(JobId jobId, JobStatus jobStatus, List<Exception> exceptions) throws HyracksException {
        LOGGER.log(level, "Getting notified of job finish for JobId: " + jobId);
        EntityId entityId = this.jobId2EntityId.get(jobId);
        if (entityId != null) {
            this.add(new ActiveEvent(jobId, ActiveEvent.Kind.JOB_FINISHED, entityId, (Object)Pair.of((Object)jobStatus, exceptions)));
        } else {
            LOGGER.log(level, "NO NEED TO NOTIFY JOB FINISH!");
        }
    }

    public void receive(ActivePartitionMessage message) {
        this.add(new ActiveEvent(message.getJobId(), ActiveEvent.Kind.PARTITION_EVENT, message.getActiveRuntimeId().getEntityId(), (Object)message));
    }

    public IActiveEntityEventsListener getListener(EntityId entityId) {
        LOGGER.log(level, "getActiveEntityListener(EntityId entityId) was called with entity " + entityId);
        IActiveEntityEventsListener listener = this.entityEventListeners.get(entityId);
        LOGGER.log(level, "Listener found: " + listener);
        return this.entityEventListeners.get(entityId);
    }

    public synchronized IActiveEntityEventsListener[] getEventListeners() {
        LOGGER.log(level, "getEventListeners() was called");
        LOGGER.log(level, "returning " + this.entityEventListeners.size() + " Listeners");
        return this.entityEventListeners.values().toArray(new IActiveEntityEventsListener[this.entityEventListeners.size()]);
    }

    public synchronized void registerListener(IActiveEntityEventsListener listener) throws HyracksDataException {
        if (this.suspended) {
            throw new RuntimeDataException(3096, new Serializable[0]);
        }
        LOGGER.log(level, "registerListener(IActiveEntityEventsListener listener) was called for the entity " + listener.getEntityId());
        if (this.entityEventListeners.containsKey(listener.getEntityId())) {
            throw new RuntimeDataException(3093, new Serializable[]{listener.getEntityId()});
        }
        this.entityEventListeners.put(listener.getEntityId(), listener);
    }

    public synchronized void unregisterListener(IActiveEntityEventsListener listener) throws HyracksDataException {
        if (this.suspended) {
            throw new RuntimeDataException(3096, new Serializable[0]);
        }
        LOGGER.log(level, "unregisterListener(IActiveEntityEventsListener listener) was called for the entity " + listener.getEntityId());
        IActiveEntityEventsListener registeredListener = this.entityEventListeners.remove(listener.getEntityId());
        if (registeredListener == null) {
            throw new RuntimeDataException(3097, new Serializable[]{listener.getEntityId()});
        }
        if (registeredListener.isActive()) {
            this.entityEventListeners.put(registeredListener.getEntityId(), registeredListener);
            throw new RuntimeDataException(3098, new Serializable[]{listener.getEntityId()});
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) throws HyracksDataException {
        if (this.initialized) {
            throw new RuntimeDataException(3099, new Serializable[0]);
        }
        this.initialized = initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void recover() {
        LOGGER.log(level, "Starting active recovery");
        Iterator<IActiveEntityEventsListener> iterator = this.entityEventListeners.values().iterator();
        while (iterator.hasNext()) {
            IActiveEntityEventsListener listener;
            IActiveEntityEventsListener iActiveEntityEventsListener = listener = iterator.next();
            synchronized (iActiveEntityEventsListener) {
                LOGGER.log(level, "Entity " + listener.getEntityId() + " is " + listener.getStats());
                if (listener.getState() == ActivityState.PERMANENTLY_FAILED && listener instanceof IActiveEntityController) {
                    LOGGER.log(level, "Recovering");
                    ((IActiveEntityController)listener).recover();
                } else {
                    LOGGER.log(level, "Only notifying");
                    listener.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(MetadataProvider mdProvider) throws AlgebricksException, HyracksDataException, InterruptedException {
        ActiveNotificationHandler activeNotificationHandler = this;
        synchronized (activeNotificationHandler) {
            if (this.suspended) {
                throw new RuntimeDataException(3107, new Serializable[0]);
            }
            LOGGER.log(level, "Suspending active events handler");
            this.suspended = true;
        }
        IMetadataLockManager lockManager = mdProvider.getApplicationContext().getMetadataLockManager();
        Collection<IActiveEntityEventsListener> registeredListeners = this.entityEventListeners.values();
        for (IActiveEntityEventsListener listener : registeredListeners) {
            String dataverseName = listener.getEntityId().getDataverse();
            String entityName = listener.getEntityId().getEntityName();
            LOGGER.log(level, "Suspending " + listener.getEntityId());
            LOGGER.log(level, "Acquiring locks");
            lockManager.acquireActiveEntityWriteLock(mdProvider.getLocks(), dataverseName + '.' + entityName);
            List<Dataset> datasets = ((ActiveEntityEventsListener)listener).getDatasets();
            for (Dataset dataset : datasets) {
                lockManager.acquireDatasetExclusiveModificationLock(mdProvider.getLocks(), DatasetUtil.getFullyQualifiedName((Dataset)dataset));
            }
            LOGGER.log(level, "locks acquired");
            ((ActiveEntityEventsListener)listener).suspend(mdProvider);
            LOGGER.log(level, listener.getEntityId() + " suspended");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(MetadataProvider mdProvider) throws HyracksDataException, InterruptedException {
        LOGGER.log(level, "Resuming active events handler");
        for (IActiveEntityEventsListener listener : this.entityEventListeners.values()) {
            LOGGER.log(level, "Resuming " + listener.getEntityId());
            ((ActiveEntityEventsListener)listener).resume(mdProvider);
            LOGGER.log(level, listener.getEntityId() + " resumed");
        }
        Object object = this;
        synchronized (object) {
            this.suspended = false;
        }
    }
}

