/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import org.apache.asterix.translator.IStatementExecutorContext;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.AbstractServlet;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueryCancellationServlet
extends AbstractServlet {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final String CLIENT_CONTEXT_ID = "client_context_id";

    public QueryCancellationServlet(ConcurrentMap<String, Object> ctx, String ... paths) {
        super(ctx, paths);
    }

    protected void delete(IServletRequest request, IServletResponse response) throws IOException {
        String clientContextId = request.getParameter((CharSequence)CLIENT_CONTEXT_ID);
        if (clientContextId == null) {
            response.setStatus(HttpResponseStatus.BAD_REQUEST);
            return;
        }
        IStatementExecutorContext runningQueries = (IStatementExecutorContext)this.ctx.get("org.apache.asterix.RUNINNG_QUERIES");
        IHyracksClientConnection hcc = (IHyracksClientConnection)this.ctx.get("org.apache.asterix.HYRACKS_CONNECTION");
        JobId jobId = runningQueries.getJobIdFromClientContextId(clientContextId);
        if (jobId == null) {
            response.setStatus(HttpResponseStatus.NOT_FOUND);
            return;
        }
        try {
            hcc.cancelJob(jobId);
            runningQueries.removeJobIdFromClientContextId(clientContextId);
            response.setStatus(HttpResponseStatus.OK);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "unexpected exception thrown from cancel", (Throwable)e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

