/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.apache.asterix.api.http.server.ResultUtil;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.dataset.IHyracksDataset;
import org.apache.hyracks.client.dataset.HyracksDataset;
import org.apache.hyracks.http.server.AbstractServlet;
import org.apache.hyracks.ipc.exceptions.IPCException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AbstractQueryApiServlet
extends AbstractServlet {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final IApplicationContext appCtx;

    AbstractQueryApiServlet(IApplicationContext appCtx, ConcurrentMap<String, Object> ctx, String[] paths) {
        super(ctx, paths);
        this.appCtx = appCtx;
    }

    protected IHyracksDataset getHyracksDataset() throws Exception {
        try {
            return this.doGetHyracksDataset();
        }
        catch (IPCException e) {
            LOGGER.log(Level.WARN, "Failed getting hyracks dataset connection. Resetting hyracks connection.", (Throwable)e);
            this.ctx.put("org.apache.asterix.HYRACKS_CONNECTION", this.appCtx.getHcc());
            return this.doGetHyracksDataset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IHyracksDataset doGetHyracksDataset() throws Exception {
        IHyracksDataset hds = (IHyracksDataset)this.ctx.get("org.apache.asterix.HYRACKS_DATASET");
        if (hds == null) {
            ConcurrentMap concurrentMap = this.ctx;
            synchronized (concurrentMap) {
                hds = (IHyracksDataset)this.ctx.get("org.apache.asterix.HYRACKS_DATASET");
                if (hds == null) {
                    hds = new HyracksDataset(this.getHyracksClientConnection(), this.appCtx.getCompilerProperties().getFrameSize(), 1);
                    this.ctx.put("org.apache.asterix.HYRACKS_DATASET", hds);
                }
            }
        }
        return hds;
    }

    protected IHyracksClientConnection getHyracksClientConnection() throws Exception {
        IHyracksClientConnection hcc = (IHyracksClientConnection)this.ctx.get("org.apache.asterix.HYRACKS_CONNECTION");
        if (hcc == null) {
            throw new RuntimeDataException(14, new Serializable[]{"org.apache.asterix.HYRACKS_CONNECTION"});
        }
        return hcc;
    }

    protected static UUID printRequestId(PrintWriter pw) {
        UUID requestId = UUID.randomUUID();
        ResultUtil.printField(pw, ResultFields.REQUEST_ID.str(), requestId.toString());
        return requestId;
    }

    protected static void printHandle(PrintWriter pw, String handle, boolean comma) {
        ResultUtil.printField(pw, ResultFields.HANDLE.str(), handle, comma);
    }

    public static enum ErrorField {
        CODE("code"),
        MSG("msg"),
        STACK("stack");

        private final String str;

        private ErrorField(String str) {
            this.str = str;
        }

        public String str() {
            return this.str;
        }
    }

    public static enum ResultStatus {
        RUNNING("running"),
        SUCCESS("success"),
        TIMEOUT("timeout"),
        FAILED("failed"),
        FATAL("fatal");

        private final String str;

        private ResultStatus(String str) {
            this.str = str;
        }

        public String str() {
            return this.str;
        }
    }

    public static enum ResultFields {
        REQUEST_ID("requestID"),
        CLIENT_ID("clientContextID"),
        SIGNATURE("signature"),
        TYPE("type"),
        STATUS("status"),
        RESULTS("results"),
        HANDLE("handle"),
        ERRORS("errors"),
        METRICS("metrics"),
        PLANS("plans");

        private final String str;

        private ResultFields(String str) {
            this.str = str;
        }

        public String str() {
            return this.str;
        }
    }
}

